/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class PyClassFixer
extends PyFixer<PyClass> {
    public PyClassFixer() {
        super(PyClass.class);
    }

    @Override
    public void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor2, @NotNull PyClass pyClass) throws IncorrectOperationException {
        PsiElement colon;
        if (editor2 == null) {
            PyClassFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            PyClassFixer.$$$reportNull$$$0(1);
        }
        if (pyClass == null) {
            PyClassFixer.$$$reportNull$$$0(2);
        }
        if ((colon = PyPsiUtils.getFirstChildOfType(pyClass, PyTokenTypes.COLON)) == null) {
            PyArgumentList argList = (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)pyClass, PyArgumentList.class);
            int colonOffset = PyUtil.sure(argList).getTextRange().getEndOffset();
            String textToInsert = ":";
            if (pyClass.getNameNode() == null) {
                int newCaretOffset = argList.getTextOffset();
                if (argList.getTextLength() == 0) {
                    ++newCaretOffset;
                    textToInsert = " :";
                }
                processor2.registerUnresolvedError(newCaretOffset);
            }
            editor2.getDocument().insertString(colonOffset, (CharSequence)textToInsert);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pyClass";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyClassFixer";
        objectArray[2] = "doApply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

