/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteSelectionAction
extends DumbAwareAction {
    public PyExecuteSelectionAction() {
        super(PyBundle.messagePointer("python.execute.selection.action.execute.selection.in.console", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(0);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) instanceof EditorImpl) {
            PyExecuteConsoleCustomizer.Companion.getInstance().notifySciCellGutterExecuted((EditorImpl)editor2, "ExecuteInPyConsoleAction");
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (editor2 != null && project != null) {
            PythonRunConfiguration config = PyExecuteConsoleCustomizer.Companion.getInstance().getContextConfig(e.getDataContext());
            String selectionText = PyExecuteSelectionAction.getSelectionText(editor2);
            if (selectionText != null) {
                PyExecuteInConsole.executeCodeInConsole(project, selectionText, editor2, true, true, false, config);
            } else {
                TextRange range = EditorUtil.calcCaretLineTextRange((Editor)editor2);
                if (!range.isEmpty()) {
                    String line = editor2.getDocument().getText(range);
                    PyExecuteInConsole.executeCodeInConsole(project, line.trim(), editor2, true, true, false, config);
                    editor2.getCaretModel().moveToOffset(range.getEndOffset());
                    editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            }
        }
    }

    @Nullable
    private static String getSelectionText(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(1);
        }
        if (editor2.getSelectionModel().hasSelection()) {
            SelectionModel model2 = editor2.getSelectionModel();
            return model2.getSelectedText();
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(3);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (PyExecuteSelectionAction.isPython(editor2)) {
            String text = PyExecuteSelectionAction.getSelectionText(editor2);
            if (text != null) {
                presentation.setText(PyBundle.message("python.execute.selection.action.execute.selection.in.console", new Object[0]));
                enabled = !text.isEmpty();
            } else if (!EditorUtil.calcCaretLineTextRange((Editor)editor2).isEmpty()) {
                presentation.setText(PyBundle.message("python.execute.selection.action.execute.line.in.console", new Object[0]));
                enabled = true;
            }
        }
        presentation.setEnabledAndVisible(enabled);
    }

    public static boolean isPython(Editor editor2) {
        if (editor2 == null) {
            return false;
        }
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        return psi instanceof PyFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/actions/PyExecuteSelectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/actions/PyExecuteSelectionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionText";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

