/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.psi.PyElementType;
import java.util.LinkedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PyPsiUtilsCore {
    private PyPsiUtilsCore() {
    }

    @ApiStatus.Internal
    public static <T extends PyAstElement> T @NotNull [] nodesToPsi(ASTNode[] nodes, T[] array) {
        PyAstElement[] psiElements = (PyAstElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array), (int)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = (PyAstElement)nodes[i].getPsi();
        }
        if (psiElements == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(0);
        }
        return psiElements;
    }

    @Nullable
    public static PsiElement getNextNonCommentSibling(@Nullable PsiElement start, boolean strict) {
        if (!(strict || start instanceof PsiWhiteSpace || start instanceof PsiComment)) {
            return start;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)start);
    }

    @Nullable
    public static PsiElement getFirstChildOfType(@NotNull PsiElement element, @NotNull PyElementType type) {
        ASTNode child;
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(2);
        }
        return (child = element.getNode().findChildByType((IElementType)type)) != null ? child.getPsi() : null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        ASTNode node;
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(4);
        }
        if ((node = element.getNode()) != null) {
            ASTNode[] children = node.getChildren(filter);
            return 0 <= number && number < children.length ? children[number].getPsi() : null;
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSiblingOnSameLine(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(5);
        }
        for (PsiElement cur = element.getNextSibling(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof PsiWhiteSpace)) {
                return cur;
            }
            if (cur.textContains('\n')) break;
        }
        return null;
    }

    @Nullable
    public static String strValue(@Nullable PyAstExpression expression) {
        return expression instanceof PyAstStringLiteralExpression ? ((PyAstStringLiteralExpression)expression).getStringValue() : null;
    }

    @Nullable
    public static QualifiedName asQualifiedName(@Nullable PyAstExpression expr) {
        return expr instanceof PyAstQualifiedExpression ? ((PyAstQualifiedExpression)expr).asQualifiedName() : null;
    }

    @Nullable
    public static QualifiedName asQualifiedName(@NotNull PyAstQualifiedExpression expr) {
        if (expr == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(6);
        }
        LinkedList<String> path = new LinkedList<String>();
        String firstName = expr.getReferencedName();
        if (firstName == null) {
            return null;
        }
        path.add(firstName);
        PyAstExpression qualifier = expr.getQualifier();
        while (qualifier != null) {
            PyAstReferenceExpression qualifierReference = (PyAstReferenceExpression)ObjectUtils.tryCast((Object)qualifier, PyAstReferenceExpression.class);
            if (qualifierReference == null) {
                return null;
            }
            String qualifierName = qualifierReference.getReferencedName();
            if (qualifierName == null) {
                return null;
            }
            path.add(0, qualifierName);
            qualifier = qualifierReference.getQualifier();
        }
        return QualifiedName.fromComponents(path);
    }

    public static void assertValid(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
    }

    @Nullable
    public static PyAstExpression flattenParens(@Nullable PyAstExpression expr) {
        while (expr instanceof PyAstParenthesizedExpression) {
            expr = ((PyAstParenthesizedExpression)expr).getContainedExpression();
        }
        return expr;
    }

    @Nullable
    public static PsiElement getParentRightBefore(@NotNull PsiElement element, @NotNull PsiElement superParent) {
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(7);
        }
        if (superParent == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(8);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, element1 -> element1.getParent() == superParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/impl/PyPsiUtilsCore";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesToPsi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/impl/PyPsiUtilsCore";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildOfType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSiblingOnSameLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asQualifiedName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentRightBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

