/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.carets;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.codeWithMe.model.RemoteCaretData;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J'\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010*\u001a\u00020\u00172\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\u001aH\u00d6\u0001J\t\u0010-\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0016\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006."}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "data", "Lcom/jetbrains/codeWithMe/model/RemoteCaretData;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/jetbrains/codeWithMe/model/RemoteCaretData;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getData", "()Lcom/jetbrains/codeWithMe/model/RemoteCaretData;", "addRemoveListener", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "action", "Lkotlin/Function0;", "isValid", "", "()Z", "startOffset", "", "getStartOffset", "()I", "endOffset", "getEndOffset", "offset", "getOffset", "userName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getUserName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "intellij.cwm.plugin.common"})
public final class RemoteCaret {
    @NotNull
    private final Editor editor;
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final RemoteCaretData data;

    public RemoteCaret(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull RemoteCaretData data) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.editor = editor;
        this.highlighter = highlighter;
        this.data = data;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final RemoteCaretData getData() {
        return this.data;
    }

    public final void addRemoveListener(@NotNull Lifetime lifetime, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.editor.getDocument(), (Project)this.editor.getProject(), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markup = (MarkupModelEx)markupModel;
        markup.addMarkupModelListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), new MarkupModelListener(this, action2){
            final /* synthetic */ RemoteCaret this$0;
            final /* synthetic */ Function0<Unit> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
            }

            public void afterRemoved(RangeHighlighterEx h) {
                Intrinsics.checkNotNullParameter((Object)h, (String)"h");
                if (Intrinsics.areEqual((Object)h, (Object)this.this$0.getHighlighter())) {
                    this.$action.invoke();
                }
            }
        });
    }

    public final boolean isValid() {
        return this.highlighter.isValid();
    }

    public final int getStartOffset() {
        return this.highlighter.getStartOffset();
    }

    public final int getEndOffset() {
        return this.highlighter.getEndOffset();
    }

    public final int getOffset() {
        return this.data.getShowCaretAtStart() ? this.getStartOffset() : this.getEndOffset();
    }

    @NotNull
    public final String getUserName() {
        return this.data.getUser().getName();
    }

    @NotNull
    public final Editor component1() {
        return this.editor;
    }

    @NotNull
    public final RangeHighlighter component2() {
        return this.highlighter;
    }

    @NotNull
    public final RemoteCaretData component3() {
        return this.data;
    }

    @NotNull
    public final RemoteCaret copy(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull RemoteCaretData data) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new RemoteCaret(editor, highlighter, data);
    }

    public static /* synthetic */ RemoteCaret copy$default(RemoteCaret remoteCaret, Editor editor, RangeHighlighter rangeHighlighter, RemoteCaretData remoteCaretData, int n, Object object) {
        if ((n & 1) != 0) {
            editor = remoteCaret.editor;
        }
        if ((n & 2) != 0) {
            rangeHighlighter = remoteCaret.highlighter;
        }
        if ((n & 4) != 0) {
            remoteCaretData = remoteCaret.data;
        }
        return remoteCaret.copy(editor, rangeHighlighter, remoteCaretData);
    }

    @NotNull
    public String toString() {
        return "RemoteCaret(editor=" + this.editor + ", highlighter=" + this.highlighter + ", data=" + this.data + ")";
    }

    public int hashCode() {
        int result = this.editor.hashCode();
        result = result * 31 + this.highlighter.hashCode();
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteCaret)) {
            return false;
        }
        RemoteCaret remoteCaret = (RemoteCaret)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)remoteCaret.editor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.highlighter, (Object)remoteCaret.highlighter)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)remoteCaret.data);
    }
}

