/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.tuweni.toml.TomlArray;
import org.apache.tuweni.toml.TomlInvalidTypeException;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.TomlType;

final class MutableTomlArray
implements TomlArray {
    static final TomlArray EMPTY = new MutableTomlArray(true);
    private final List<Element> elements = new ArrayList<Element>();
    private final boolean definedAsLiteral;
    private TomlType type = null;

    MutableTomlArray() {
        this(false);
    }

    MutableTomlArray(boolean definedAsLiteral) {
        this.definedAsLiteral = definedAsLiteral;
    }

    boolean wasDefinedAsLiteral() {
        return this.definedAsLiteral;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.type == null;
    }

    @Override
    public boolean containsStrings() {
        return this.type == null || this.type == TomlType.STRING;
    }

    @Override
    public boolean containsLongs() {
        return this.type == null || this.type == TomlType.INTEGER;
    }

    @Override
    public boolean containsDoubles() {
        return this.type == null || this.type == TomlType.FLOAT;
    }

    @Override
    public boolean containsBooleans() {
        return this.type == null || this.type == TomlType.BOOLEAN;
    }

    @Override
    public boolean containsOffsetDateTimes() {
        return this.type == null || this.type == TomlType.OFFSET_DATE_TIME;
    }

    @Override
    public boolean containsLocalDateTimes() {
        return this.type == null || this.type == TomlType.LOCAL_DATE_TIME;
    }

    @Override
    public boolean containsLocalDates() {
        return this.type == null || this.type == TomlType.LOCAL_DATE;
    }

    @Override
    public boolean containsLocalTimes() {
        return this.type == null || this.type == TomlType.LOCAL_TIME;
    }

    @Override
    public boolean containsArrays() {
        return this.type == null || this.type == TomlType.ARRAY;
    }

    @Override
    public boolean containsTables() {
        return this.type == null || this.type == TomlType.TABLE;
    }

    @Override
    public Object get(int index) {
        return this.elements.get((int)index).value;
    }

    @Override
    public TomlPosition inputPositionOf(int index) {
        return this.elements.get((int)index).position;
    }

    MutableTomlArray append(Object value, TomlPosition position) {
        Objects.requireNonNull(value);
        if (value instanceof Integer) {
            value = ((Integer)value).longValue();
        }
        TomlType origType = this.type;
        Optional<TomlType> valueType = TomlType.typeFor(value);
        if (!valueType.isPresent()) {
            throw new IllegalArgumentException("Unsupported type " + value.getClass().getSimpleName());
        }
        if (this.type != null) {
            if (valueType.get() != this.type) {
                throw new TomlInvalidTypeException("Cannot add a " + TomlType.typeNameFor(value) + " to an array containing " + this.type.typeName() + "s");
            }
        } else {
            this.type = valueType.get();
        }
        try {
            this.elements.add(new Element(value, position));
        }
        catch (Throwable e) {
            this.type = origType;
            throw e;
        }
        return this;
    }

    @Override
    public List<Object> toList() {
        return this.elements.stream().map(e -> e.value).collect(Collectors.toList());
    }

    private static class Element {
        final Object value;
        final TomlPosition position;

        private Element(Object value, TomlPosition position) {
            this.value = value;
            this.position = position;
        }
    }
}

