/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.shared.branch;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.vcs.git.shared.ui.GitBranchPresentation;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/git/shared/branch/GitBranchesClippedNamesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/intellij/vcs/git/shared/branch/GitBranchesClippedNamesCache$ClippedBranch;", "cacheDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "getOrCache", "branchName", "maxBranchNameLength", "", "truncateBranchName", "clear", "", "dispose", "ClippedBranch", "Companion", "intellij.vcs.git.shared"})
@SourceDebugExtension(value={"SMAP\nGitBranchesClippedNamesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesClippedNamesCache.kt\ncom/intellij/vcs/git/shared/branch/GitBranchesClippedNamesCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class GitBranchesClippedNamesCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<String, ClippedBranch> cache;
    @NotNull
    private final CheckedDisposable cacheDisposable;
    private static final long CACHE_MAX_SIZE = 1000L;
    private static final long CACHE_ACCESS_EXPIRATION_MIN = 5L;

    /*
     * WARNING - void declaration
     */
    public GitBranchesClippedNamesCache(@NotNull Project project) {
        void it;
        CheckedDisposable checkedDisposable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Cache cache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        CheckedDisposable checkedDisposable2 = checkedDisposable = Disposer.newCheckedDisposable();
        GitBranchesClippedNamesCache gitBranchesClippedNamesCache = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        CheckedDisposable checkedDisposable3 = checkedDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable3, (String)"also(...)");
        gitBranchesClippedNamesCache.cacheDisposable = checkedDisposable3;
    }

    @NotNull
    public final String getOrCache(@NotNull String branchName, int maxBranchNameLength) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        if (this.cacheDisposable.isDisposed()) {
            return branchName;
        }
        Object object = this.cache.get((Object)branchName, arg_0 -> GitBranchesClippedNamesCache.getOrCache$lambda$2(arg_0 -> GitBranchesClippedNamesCache.getOrCache$lambda$1(this, branchName, maxBranchNameLength, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ClippedBranch oldClippedBranch = (ClippedBranch)object;
        if (oldClippedBranch.getLength() == maxBranchNameLength) {
            return oldClippedBranch.getClippedName();
        }
        ClippedBranch clippedBranch = this.truncateBranchName(branchName, maxBranchNameLength);
        this.cache.put((Object)branchName, (Object)clippedBranch);
        return clippedBranch.getClippedName();
    }

    private final ClippedBranch truncateBranchName(String branchName, int maxBranchNameLength) {
        String string = GitBranchPresentation.truncateBranchName(this.project, branchName, maxBranchNameLength, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"truncateBranchName(...)");
        return new ClippedBranch(string, maxBranchNameLength);
    }

    public final void clear() {
        this.cache.invalidateAll();
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private static final ClippedBranch getOrCache$lambda$1(GitBranchesClippedNamesCache this$0, String $branchName, int $maxBranchNameLength, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.truncateBranchName($branchName, $maxBranchNameLength);
    }

    private static final ClippedBranch getOrCache$lambda$2(Function1 $tmp0, Object p0) {
        return (ClippedBranch)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/git/shared/branch/GitBranchesClippedNamesCache$ClippedBranch;", "", "clippedName", "", "length", "", "<init>", "(Ljava/lang/String;I)V", "getClippedName", "()Ljava/lang/String;", "getLength", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.vcs.git.shared"})
    private static final class ClippedBranch {
        @NotNull
        private final String clippedName;
        private final int length;

        public ClippedBranch(@NotNull String clippedName, int length) {
            Intrinsics.checkNotNullParameter((Object)clippedName, (String)"clippedName");
            this.clippedName = clippedName;
            this.length = length;
        }

        @NotNull
        public final String getClippedName() {
            return this.clippedName;
        }

        public final int getLength() {
            return this.length;
        }

        @NotNull
        public final String component1() {
            return this.clippedName;
        }

        public final int component2() {
            return this.length;
        }

        @NotNull
        public final ClippedBranch copy(@NotNull String clippedName, int length) {
            Intrinsics.checkNotNullParameter((Object)clippedName, (String)"clippedName");
            return new ClippedBranch(clippedName, length);
        }

        public static /* synthetic */ ClippedBranch copy$default(ClippedBranch clippedBranch, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = clippedBranch.clippedName;
            }
            if ((n2 & 2) != 0) {
                n = clippedBranch.length;
            }
            return clippedBranch.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ClippedBranch(clippedName=" + this.clippedName + ", length=" + this.length + ")";
        }

        public int hashCode() {
            int result = this.clippedName.hashCode();
            result = result * 31 + Integer.hashCode(this.length);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClippedBranch)) {
                return false;
            }
            ClippedBranch clippedBranch = (ClippedBranch)other;
            if (!Intrinsics.areEqual((Object)this.clippedName, (Object)clippedBranch.clippedName)) {
                return false;
            }
            return this.length == clippedBranch.length;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/git/shared/branch/GitBranchesClippedNamesCache$Companion;", "", "<init>", "()V", "CACHE_MAX_SIZE", "", "CACHE_ACCESS_EXPIRATION_MIN", "intellij.vcs.git.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

