/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DvcsBranchUtil {
    @NotNull
    public static String getPathFor(@Nullable Repository repository) {
        String string = repository == null ? "" : repository.getRoot().getPath();
        if (string == null) {
            DvcsBranchUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static @Unmodifiable List<Change> swapRevisions(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            DvcsBranchUtil.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.map(changes, change -> {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision == null || afterRevision == null) {
                return new Change(afterRevision, beforeRevision);
            }
            return new Change(afterRevision, beforeRevision, change.getFileStatus());
        });
        if (list == null) {
            DvcsBranchUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nls
    @NotNull
    public static String shortenBranchName(@Nls @NotNull String fullBranchName) {
        if (fullBranchName == null) {
            DvcsBranchUtil.$$$reportNull$$$0(3);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)fullBranchName, (int)100, (int)5);
        if (string == null) {
            DvcsBranchUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFor";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "swapRevisions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "swapRevisions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shortenBranchName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

