/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.util.function.Supplier;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class PreciseVerticalScrollHelper
extends MouseAdapter {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Supplier<? extends MarkdownHtmlPanelEx> htmlPanelSupplier;
    private int lastOffset;

    PreciseVerticalScrollHelper(@NotNull EditorImpl editor2, @NotNull Supplier<? extends MarkdownHtmlPanelEx> htmlPanelSupplier) {
        if (editor2 == null) {
            PreciseVerticalScrollHelper.$$$reportNull$$$0(0);
        }
        if (htmlPanelSupplier == null) {
            PreciseVerticalScrollHelper.$$$reportNull$$$0(1);
        }
        this.lastOffset = 0;
        this.editor = editor2;
        this.htmlPanelSupplier = htmlPanelSupplier;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        int currentOffset = this.editor.getScrollingModel().getVerticalScrollOffset();
        if (this.lastOffset == currentOffset) {
            this.boundaryReached(event);
        } else {
            this.lastOffset = currentOffset;
        }
    }

    private void boundaryReached(MouseWheelEvent event) {
        if (event.isShiftDown()) {
            return;
        }
        MarkdownHtmlPanelEx actualPanel = this.htmlPanelSupplier.get();
        if (actualPanel == null) {
            return;
        }
        if (event.getScrollType() == 0) {
            int multiplier = Registry.intValue((String)"ide.browser.jcef.osr.wheelRotation.factor", (int)1);
            int amount = event.getScrollAmount() * event.getWheelRotation() * multiplier;
            actualPanel.scrollBy(0, amount);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "htmlPanelSupplier";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/markdown/ui/preview/PreciseVerticalScrollHelper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

