/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownSetColumnAlignmentIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "<init>", "()V", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "startInWriteAction", "invoke", "", "intellij.markdown"})
public final class MarkdownSetColumnAlignmentIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.set.column.alignment.intention.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTableCell cell = TableUtils.findCell(element2);
        if (cell == null) return false;
        if (editor2 == null) return false;
        MarkdownTable markdownTable = cell.getParentTable();
        if (markdownTable == null) return false;
        if (!TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable)) return false;
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTable table;
        MarkdownTableCell cell;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTableCell markdownTableCell = cell = TableUtils.findCell(element2);
        MarkdownTable markdownTable = table = markdownTableCell != null ? markdownTableCell.getParentTable() : null;
        if (cell == null || table == null || editor2 == null) {
            return;
        }
        ActionsKt.invokeLater$default(null, () -> MarkdownSetColumnAlignmentIntention.invoke$lambda$0(editor2), (int)1, null);
    }

    private static final Unit invoke$lambda$0(Editor $editor) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)$editor.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context = dataContext;
        Object object = ActionManager.getInstance().getAction("Markdown.TableColumnActions.ColumnAlignmentActions.Popup");
        ActionGroup group = object instanceof ActionGroup ? (ActionGroup)object : null;
        if (group == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(MarkdownBundle.message("markdown.set.column.alignment.intention.popup.text", new Object[0]), group, context, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup2 = listPopup;
        popup2.showInFocusCenter();
        return Unit.INSTANCE;
    }
}

