/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "firstEnterPosition", "", "Ljava/lang/Integer;", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isEnabled", "", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownTableEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownTableEnterHandler.kt\norg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,72:1\n7#2,6:73\n7#2,6:79\n*S KotlinDebug\n*F\n+ 1 MarkdownTableEnterHandler.kt\norg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler\n*L\n49#1:73,6\n57#1:79,6\n*E\n"})
public final class MarkdownTableEnterHandler
implements EnterHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer firstEnterPosition;
    @NotNull
    private static final String insertTag = "<br/>";

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Integer cellIndex;
        MarkdownTableCell cell;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!this.isEnabled()) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"preprocessEnter(...)");
            return result;
        }
        Integer enterPosition = this.firstEnterPosition;
        this.firstEnterPosition = null;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int actualCaretOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        if (!TableUtils.isProbablyInsideTableCell(document2, actualCaretOffset)) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"preprocessEnter(...)");
            return result;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownTableCell markdownTableCell = cell = TableUtils.findCell(file, actualCaretOffset);
        MarkdownTable table = markdownTableCell != null ? markdownTableCell.getParentTable() : null;
        MarkdownTableCell markdownTableCell2 = cell;
        Integer n = cellIndex = markdownTableCell2 != null ? Integer.valueOf(markdownTableCell2.getColumnIndex()) : null;
        if (cell == null || table == null || cellIndex == null) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"preprocessEnter(...)");
            return result;
        }
        Integer n2 = enterPosition;
        if (n2 != null && actualCaretOffset == n2) {
            int start = actualCaretOffset - 5;
            int end = actualCaretOffset;
            if (actualCaretOffset > 5 && Intrinsics.areEqual((Object)document2.getText(new TextRange(start, end)), (Object)insertTag)) {
                Project project$iv = null;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(document2, start, end){
                    final /* synthetic */ Document $document$inlined;
                    final /* synthetic */ int $start$inlined;
                    final /* synthetic */ int $end$inlined;
                    {
                        this.$document$inlined = document;
                        this.$start$inlined = n;
                        this.$end$inlined = n2;
                    }

                    public final void run() {
                        boolean bl = false;
                        this.$document$inlined.deleteString(this.$start$inlined, this.$end$inlined);
                    }
                }, name$iv, groupId$iv);
                caretOffset.set((Object)start);
            }
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"preprocessEnter(...)");
            return result;
        }
        caretAdvance.set((Object)5);
        Project project$iv = null;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(editor2){
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$editor$inlined = editor2;
            }

            public final void run() {
                boolean bl = false;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)"<br/>");
            }
        }, name$iv, groupId$iv);
        this.firstEnterPosition = actualCaretOffset + 5;
        return EnterHandlerDelegate.Result.Stop;
    }

    private final boolean isEnabled() {
        return ((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getInsertHtmlLineBreakInsideTables();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler$Companion;", "", "<init>", "()V", "insertTag", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

