/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.xml.DtdParsing;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityContextType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEntityDeclImpl
extends XmlElementImpl
implements XmlEntityDecl {
    public XmlEntityDeclImpl() {
        super(XmlElementType.XML_ENTITY_DECL);
    }

    public PsiElement getNameElement() {
        for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlTokenImpl xmlToken;
            if (!(e instanceof XmlTokenImpl) || (xmlToken = (XmlTokenImpl)e).getTokenType() != XmlTokenType.XML_NAME) continue;
            return xmlToken;
        }
        return null;
    }

    public XmlAttributeValue getValueElement() {
        if (this.isInternalReference()) {
            for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi((ASTNode)e);
            }
        } else {
            for (TreeElement e = this.getLastChildNode(); e != null; e = e.getTreePrev()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi((ASTNode)e);
            }
        }
        return null;
    }

    public String getName() {
        PsiElement nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : "";
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiElement nameElement;
        if (name == null) {
            XmlEntityDeclImpl.$$$reportNull$$$0(0);
        }
        if ((nameElement = this.getNameElement()) != null) {
            return ElementManipulators.handleContentChange((PsiElement)nameElement, (TextRange)new TextRange(0, nameElement.getTextLength()), (String)name);
        }
        return null;
    }

    public PsiElement parse(PsiFile baseFile, XmlEntityContextType contextType, XmlEntityRef originalElement) {
        PsiElement dep = (PsiElement)DEPENDING_ELEMENT.get((UserDataHolder)this.getParent());
        PsiElement dependsOnElement = this.getValueElement(dep instanceof PsiFile ? (PsiFile)dep : baseFile);
        String value = null;
        if (dependsOnElement instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)dependsOnElement;
            value = attributeValue.getValue();
        } else if (dependsOnElement instanceof PsiFile) {
            PsiFile file = (PsiFile)dependsOnElement;
            value = file.getText();
        }
        if (value == null) {
            return null;
        }
        DtdParsing dtdParsing = new DtdParsing((CharSequence)value, XmlElementType.XML_ELEMENT_DECL, contextType, baseFile);
        PsiElement generated = dtdParsing.parse().getPsi().getFirstChild();
        if (contextType == XmlEntityContextType.ELEMENT_CONTENT_SPEC && generated instanceof XmlElementContentSpec) {
            generated = generated.getFirstChild();
        }
        XmlEntityDeclImpl.setDependsOnElement(generated, dependsOnElement);
        return XmlEntityDeclImpl.setOriginalElement(generated, (PsiElement)originalElement);
    }

    private static PsiElement setDependsOnElement(PsiElement generated, PsiElement dependsOnElement) {
        for (PsiElement e = generated; e != null; e = e.getNextSibling()) {
            e.putUserData(DEPENDING_ELEMENT, (Object)dependsOnElement);
        }
        return generated;
    }

    private static PsiElement setOriginalElement(PsiElement element, PsiElement valueElement) {
        for (PsiElement e = element; e != null; e = e.getNextSibling()) {
            e.putUserData(INCLUDING_ELEMENT, (Object)((XmlElement)valueElement));
        }
        return element;
    }

    @Nullable
    private PsiElement getValueElement(PsiFile baseFile) {
        XmlAttributeValue attributeValue = this.getValueElement();
        if (this.isInternalReference()) {
            return attributeValue;
        }
        if (attributeValue != null) {
            String value = attributeValue.getValue();
            XmlFile xmlFile = XmlUtil.findNamespaceByLocation(baseFile, value);
            if (xmlFile != null) {
                return xmlFile;
            }
            int i = XmlUtil.getPrefixLength(value);
            if (i > 0) {
                return XmlUtil.findNamespaceByLocation(baseFile, value.substring(i));
            }
        }
        return null;
    }

    public boolean isInternalReference() {
        for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlToken token;
            if (!(e.getElementType() instanceof IXmlLeafElementType) || (token = (XmlToken)SourceTreeToPsiMap.treeElementToPsi((ASTNode)e)).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && token.getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.getNameElement();
        if (psiElement == null) {
            XmlEntityDeclImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public int getTextOffset() {
        PsiElement name = this.getNameElement();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }

    public boolean canNavigate() {
        if (this.isPhysical()) {
            return super.canNavigate();
        }
        PsiNamedElement psiNamedElement = XmlUtil.findRealNamedElement((PsiNamedElement)this);
        return psiNamedElement != null;
    }

    public void navigate(boolean requestFocus) {
        if (!this.isPhysical()) {
            ((Navigatable)XmlUtil.findRealNamedElement((PsiNamedElement)this)).navigate(requestFocus);
            return;
        }
        super.navigate(requestFocus);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlEntityDeclImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlEntityDeclImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

