/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementContextType
extends TemplateContextType {
    public XmlElementContextType() {
        super(XmlBundle.message("xml.tag", new Object[0]));
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        int startOffset;
        PsiFile file;
        if (templateActionContext == null) {
            XmlElementContextType.$$$reportNull$$$0(0);
        }
        if (!XmlContextType.isInXml(file = templateActionContext.getFile(), startOffset = templateActionContext.getStartOffset())) {
            return false;
        }
        return XmlElementContextType.isInXmlElementContext(templateActionContext);
    }

    public static boolean isInXmlElementContext(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            XmlElementContextType.$$$reportNull$$$0(1);
        }
        int startOffset = templateActionContext.getStartOffset();
        int endOffset = templateActionContext.getEndOffset();
        PsiElement parent = XmlElementContextType.findCommonParent(templateActionContext);
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        TextRange range = parent.getTextRange();
        return range.getStartOffset() >= startOffset && range.getEndOffset() <= endOffset;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            XmlElementContextType.$$$reportNull$$$0(2);
        }
        PsiFile file = templateActionContext.getFile();
        int startOffset = templateActionContext.getStartOffset();
        int endOffset = templateActionContext.getEndOffset();
        if (endOffset <= startOffset) {
            return null;
        }
        PsiElement start2 = file.findElementAt(startOffset);
        PsiElement end = file.findElementAt(endOffset - 1);
        if (start2 instanceof PsiWhiteSpace) {
            start2 = start2.getNextSibling();
        }
        if (end instanceof PsiWhiteSpace) {
            end = end.getPrevSibling();
        }
        if (start2 == null || end == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)start2, (PsiElement)end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "templateActionContext";
        objectArray2[1] = "com/intellij/codeInsight/template/XmlElementContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInXmlElementContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findCommonParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

