/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEncodingReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(XmlEncodingReferenceProvider.class);
    private static final TokenSet ATTRIBUTE_VALUE_STD_TOKENS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN});
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            XmlEncodingReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            XmlEncodingReferenceProvider.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(element instanceof XmlAttributeValue);
        XmlAttributeValue value = (XmlAttributeValue)element;
        PsiReference[] psiReferenceArray = new PsiReference[]{new XmlEncodingReference(value, value.getValue(), XmlEncodingReferenceProvider.xmlAttributeValueRange(value), 0)};
        if (psiReferenceArray == null) {
            XmlEncodingReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    protected static TextRange xmlAttributeValueRange(XmlAttributeValue xmlAttributeValue) {
        ASTNode valueNode = XmlChildRole.ATTRIBUTE_VALUE_VALUE_FINDER.findChild(xmlAttributeValue.getNode());
        XmlAttributeValue toHighlight = valueNode == null ? xmlAttributeValue : valueNode.getPsi();
        TextRange childRange = toHighlight.getTextRange();
        TextRange range = xmlAttributeValue.getTextRange();
        return childRange.shiftRight(-range.getStartOffset());
    }

    public static PsiReference[] extractFromContentAttribute(XmlAttributeValue value) {
        boolean hasNonStandardTokens = ContainerUtil.exists((Object[])value.getChildren(), ch -> !ATTRIBUTE_VALUE_STD_TOKENS.contains(ch.getNode().getElementType()));
        if (hasNonStandardTokens) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = value.getValue();
        int start2 = text.indexOf(CHARSET_PREFIX);
        if (start2 != -1) {
            int end = text.indexOf(59, start2 += CHARSET_PREFIX.length());
            if (end == -1) {
                end = text.length();
            }
            String charsetName = text.substring(start2, end);
            TextRange textRange = new TextRange(start2, end).shiftRight(XmlEncodingReferenceProvider.xmlAttributeValueRange(value).getStartOffset());
            return new PsiReference[]{new XmlEncodingReference(value, charsetName, textRange, 0)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

