/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.action;

import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectConnection;
import org.jetbrains.plugins.gitlab.api.GitLabProjectConnectionManager;
import org.jetbrains.plugins.gitlab.api.GitLabVersion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/action/GitLabURIUtil;", "", "<init>", "()V", "getServerVersion", "Lorg/jetbrains/plugins/gitlab/api/GitLabVersion;", "project", "Lcom/intellij/openapi/project/Project;", "getWebURI", "Ljava/net/URI;", "repository", "revisionOrBranch", "", "relativePath", "lineRange", "Lkotlin/ranges/IntRange;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabOpenInBrowserActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabOpenInBrowserActionGroup.kt\norg/jetbrains/plugins/gitlab/ui/action/GitLabURIUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n30#2,2:75\n1#3:77\n*S KotlinDebug\n*F\n+ 1 GitLabOpenInBrowserActionGroup.kt\norg/jetbrains/plugins/gitlab/ui/action/GitLabURIUtil\n*L\n44#1:75,2\n*E\n"})
public final class GitLabURIUtil {
    @NotNull
    public static final GitLabURIUtil INSTANCE = new GitLabURIUtil();

    private GitLabURIUtil() {
    }

    private final GitLabVersion getServerVersion(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitLabProjectConnectionManager> serviceClass$iv = GitLabProjectConnectionManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitLabProjectConnection gitLabProjectConnection = (GitLabProjectConnection)((GitLabProjectConnectionManager)object).getConnectionState().getValue();
        return gitLabProjectConnection != null ? gitLabProjectConnection.getServerVersion() : null;
    }

    @NotNull
    public final URI getWebURI(@Nullable Project project, @NotNull URI repository, @NotNull String revisionOrBranch) {
        GitLabVersion gitLabVersion;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)revisionOrBranch, (String)"revisionOrBranch");
        Project project2 = project;
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            gitLabVersion = INSTANCE.getServerVersion(it);
        } else {
            gitLabVersion = null;
        }
        GitLabVersion version = gitLabVersion;
        return version != null && version.compareTo(new GitLabVersion(16, 0, null, null, 12, null)) < 0 ? URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)repository, (String)"commit"), (String)revisionOrBranch) : URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)repository, (String)"-"), (String)"commit"), (String)revisionOrBranch);
    }

    @NotNull
    public final URI getWebURI(@Nullable Project project, @NotNull URI repository, @NotNull String revisionOrBranch, @NotNull String relativePath, @Nullable IntRange lineRange) {
        URI uRI;
        URI fileUri;
        GitLabVersion version;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)revisionOrBranch, (String)"revisionOrBranch");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Project project2 = project;
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            v1 = INSTANCE.getServerVersion(it);
        } else {
            v1 = version = null;
        }
        if (version != null && version.compareTo(new GitLabVersion(16, 0, null, null, 12, null)) < 0) {
            URI uRI2 = URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)repository, (String)"blob"), (String)revisionOrBranch);
            String string = URLUtil.encodePath((String)relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodePath(...)");
            v4 = URIUtilKt.resolveRelative((URI)uRI2, (String)string);
        } else {
            URI uRI3 = URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)repository, (String)"-"), (String)"blob"), (String)revisionOrBranch);
            String string = URLUtil.encodePath((String)relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodePath(...)");
            v4 = fileUri = URIUtilKt.resolveRelative((URI)uRI3, (String)string);
        }
        if (lineRange != null) {
            StringBuilder fragmentBuilder = new StringBuilder();
            fragmentBuilder.append("L").append(lineRange.getFirst() + 1);
            if (lineRange.getLast() != lineRange.getFirst()) {
                fragmentBuilder.append("-L").append(lineRange.getLast() + 1);
            }
            uRI = UriUtilKt.withFragment((URI)fileUri, (String)fragmentBuilder.toString());
        } else {
            uRI = fileUri;
        }
        return uRI;
    }
}

