/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.lexer;

import com.intellij.openapi.util.text.StringUtil;

public final class YAMLGrammarCharUtil {
    private static final String NS_INDICATORS = "-?:,\\[\\]\\{\\}#&*!|>'\\\"%@`";
    private static final String NS_FLOW_INDICATORS = ",[]{}";
    private static final String COMMON_SPACE_CHARS = "\n\r\t ";

    private YAMLGrammarCharUtil() {
    }

    public static boolean isIndicatorChar(char c) {
        return StringUtil.containsChar((String)NS_INDICATORS, (char)c);
    }

    public static boolean isPlainSafe(char c) {
        return !YAMLGrammarCharUtil.isSpaceLike(c) && !StringUtil.containsChar((String)NS_FLOW_INDICATORS, (char)c);
    }

    public static boolean isSpaceLike(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean isNonSpaceChar(char c) {
        return !StringUtil.containsChar((String)COMMON_SPACE_CHARS, (char)c);
    }
}

