/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodoTreeStructure;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class CustomChangelistTodosTreeBuilder
extends TodoTreeBuilder {
    public static final TodoItem[] EMPTY_ITEMS = TodoItem.EMPTY_ARRAY;
    private final PsiTodoSearchHelper myCustomPsiTodoSearchHelper;

    public CustomChangelistTodosTreeBuilder(@NotNull JTree tree, @NotNull Project project, @NotNull Collection<? extends TodoItem> initialTodoItems) {
        if (tree == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(1);
        }
        if (initialTodoItems == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(2);
        }
        super(tree, project);
        this.myCustomPsiTodoSearchHelper = new MyPsiTodoSearchHelper(initialTodoItems);
    }

    @NotNull
    protected PsiTodoSearchHelper getSearchHelper() {
        PsiTodoSearchHelper psiTodoSearchHelper = this.myCustomPsiTodoSearchHelper;
        if (psiTodoSearchHelper == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(3);
        }
        return psiTodoSearchHelper;
    }

    @NotNull
    protected abstract Set<TodoItem> doFindAllTodoItems(@Nullable TodoFilter var1);

    @NotNull
    protected abstract Set<TodoItem> doFindTodoForFile(@NotNull PsiFile var1, @Nullable TodoFilter var2);

    private boolean isFileDirty(@NotNull PsiFile file) {
        if (file == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(4);
        }
        return this.myDirtyFileSet.contains(file.getVirtualFile());
    }

    @NotNull
    protected TodoTreeStructure createTreeStructure() {
        return new CustomChangelistTodoTreeStructure(this.myProject, this.myCustomPsiTodoSearchHelper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTodoItems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileDirty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class MyPsiTodoSearchHelper
    implements PsiTodoSearchHelper {
        private final MultiMap<PsiFile, TodoItem> myMap;

        private MyPsiTodoSearchHelper(Collection<? extends TodoItem> todoItems) {
            if (todoItems == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(0);
            }
            this.myMap = new MultiMap();
            this.buildMap(todoItems);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildMap(@NotNull Collection<? extends TodoItem> todoItems) {
            if (todoItems == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(1);
            }
            MultiMap<PsiFile, TodoItem> multiMap = this.myMap;
            synchronized (multiMap) {
                this.myMap.clear();
                for (TodoItem todoItem : todoItems) {
                    this.myMap.putValue((Object)todoItem.getFile(), (Object)todoItem);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public PsiFile @NotNull [] findFilesWithTodoItems() {
            TodoFilter todoFilter = CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter();
            Set<TodoItem> todoItems = CustomChangelistTodosTreeBuilder.this.doFindAllTodoItems(todoFilter);
            this.buildMap(todoItems);
            MultiMap<PsiFile, TodoItem> multiMap = this.myMap;
            // MONITORENTER : multiMap
            Set files = this.myMap.keySet();
            PsiFile[] psiFileArray = files.toArray(PsiFile.EMPTY_ARRAY);
            // MONITOREXIT : multiMap
            if (psiFileArray != null) return psiFileArray;
            MyPsiTodoSearchHelper.$$$reportNull$$$0(2);
            return psiFileArray;
        }

        public boolean processFilesWithTodoItems(@NotNull Processor<? super PsiFile> processor) {
            if (processor == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(3);
            }
            return ContainerUtil.process((Object[])this.findFilesWithTodoItems(), processor);
        }

        public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(4);
            }
            TodoItem[] todoItemArray = this.findPatternedTodoItems(file, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(5);
            }
            return todoItemArray;
        }

        public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(6);
            }
            TodoItem[] todoItemArray = this.findTodoItems(file);
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(7);
            }
            return todoItemArray;
        }

        public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file, int startOffset, int endOffset) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(8);
            }
            TodoItem[] todoItemArray = this.findTodoItems(file, startOffset, endOffset);
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(9);
            }
            return todoItemArray;
        }

        public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file, int startOffset, int endOffset) {
            TodoItem[] todoItems;
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(10);
            }
            if ((todoItems = this.findTodoItems(file)).length == 0) {
                if (todoItems == null) {
                    MyPsiTodoSearchHelper.$$$reportNull$$$0(11);
                }
                return todoItems;
            }
            TextRange textRange = new TextRange(startOffset, endOffset);
            ArrayList<TodoItem> result2 = new ArrayList<TodoItem>();
            for (TodoItem todoItem : todoItems) {
                if (!todoItem.getTextRange().contains(textRange)) continue;
                result2.add(todoItem);
            }
            TodoItem[] todoItemArray = result2.isEmpty() ? EMPTY_ITEMS : result2.toArray(TodoItem.EMPTY_ARRAY);
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(12);
            }
            return todoItemArray;
        }

        public int getTodoItemsCount(@NotNull PsiFile file) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(13);
            }
            return this.findTodoItems(file).length;
        }

        public int getTodoItemsCount(@NotNull PsiFile file, @NotNull TodoPattern pattern) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(14);
            }
            if (pattern == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(15);
            }
            TodoFilter filter = new TodoFilter();
            filter.addTodoPattern(pattern);
            return this.findPatternedTodoItems(file, filter).length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TodoItem[] findPatternedTodoItems(PsiFile file, TodoFilter todoFilter) {
            if (CustomChangelistTodosTreeBuilder.this.isFileDirty(file)) {
                Set<TodoItem> todoItems = CustomChangelistTodosTreeBuilder.this.doFindTodoForFile(file, todoFilter);
                MultiMap<PsiFile, TodoItem> multiMap = this.myMap;
                synchronized (multiMap) {
                    this.myMap.remove((Object)file);
                    for (TodoItem todoItem : todoItems) {
                        this.myMap.putValue((Object)file, (Object)todoItem);
                    }
                }
            }
            MultiMap<PsiFile, TodoItem> multiMap = this.myMap;
            synchronized (multiMap) {
                Collection todoItems = this.myMap.get((Object)file);
                return todoItems.isEmpty() ? EMPTY_ITEMS : todoItems.toArray(TodoItem.EMPTY_ARRAY);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 7, 9, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "todoItems";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$MyPsiTodoSearchHelper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$MyPsiTodoSearchHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFilesWithTodoItems";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findTodoItems";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findTodoItemsLight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "buildMap";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processFilesWithTodoItems";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findTodoItems";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findTodoItemsLight";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getTodoItemsCount";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 7, 9, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

