/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.DebugArtifactPublisher;
import com.intellij.testFramework.ErrorLog;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestLoggerKt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class TestLoggerFactory
implements Logger.Factory {
    private static final String LOG_DIR = "testlog";
    private static final String LOG_FILE_NAME = "idea.log";
    private static final String SPLIT_LOGS_SUBDIR = "splitTestLogs";
    private static final long LOG_SIZE_LIMIT = 0x6400000L;
    private static final long LOG_SEEK_WINDOW = 102400L;
    private static final char FAILED_TEST_DEBUG_OUTPUT_MARKER = '\u2003';
    private static final int MAX_BUFFER_LENGTH = Integer.getInteger("idea.single.test.log.max.length", 10000000);
    private final StringBuilder myBuffer = new StringBuilder();
    private long myTestStartedMillis;
    private boolean myInitialized;
    private boolean mySplitTestLogs = Boolean.getBoolean("idea.split.test.logs");
    private static final boolean myEchoDebugToStdout = Boolean.getBoolean("idea.test.logs.echo.debug.to.stdout");
    private static final AtomicInteger myRethrowErrorsNumber = new AtomicInteger(0);
    private final AtomicReference<DebugArtifactPublisher> myDebugArtifactPublisher = new AtomicReference();

    private TestLoggerFactory() {
    }

    @Nullable
    private static TestLoggerFactory getTestLoggerFactory() {
        Logger.Factory factory = Logger.getFactory();
        return factory instanceof TestLoggerFactory ? (TestLoggerFactory)factory : null;
    }

    @NotNull
    public synchronized Logger getLoggerInstance(@NotNull String category) {
        if (category == null) {
            TestLoggerFactory.$$$reportNull$$$0(0);
        }
        if (!this.myInitialized && TestLoggerFactory.reconfigure()) {
            this.myInitialized = true;
        }
        return new TestLogger(java.util.logging.Logger.getLogger(category), this);
    }

    public static int getRethrowErrorNumber() {
        return myRethrowErrorsNumber.get();
    }

    public static boolean reconfigure() {
        try {
            Path logProperties;
            String customConfigPath = System.getProperty("idea.log.config.properties.file");
            Path path = logProperties = customConfigPath != null ? Path.of(customConfigPath, new String[0]) : Path.of(PathManager.getHomePath(), "test-log.properties");
            if (Files.exists(logProperties, new LinkOption[0])) {
                if (customConfigPath != null) {
                    System.out.println("Configuring j.u.l.LogManager from file: " + String.valueOf(logProperties));
                }
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(logProperties, new OpenOption[0]));){
                    LogManager.getLogManager().readConfiguration(in);
                }
            } else {
                System.err.println("Configuration file for j.u.l.LogManager does not exist: " + String.valueOf(logProperties));
            }
            Path logDir = TestLoggerFactory.getTestLogDir();
            Files.createDirectories(logDir, new FileAttribute[0]);
            Path logFile = logDir.resolve(LOG_FILE_NAME);
            JulLogger.clearHandlers();
            JulLogger.configureLogFileAndConsole((Path)logFile, (boolean)false, (boolean)true, (boolean)false, null, null, null);
            if (myEchoDebugToStdout) {
                TestLoggerFactory.addConsoleAppenderForDebugRecords();
            }
            System.out.printf("Test log file: %s%n", logFile.toUri());
            if (Files.exists(logFile, new LinkOption[0]) && Files.size(logFile) >= 0x6400000L) {
                Files.writeString(logFile, (CharSequence)"", new OpenOption[0]);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void addConsoleAppenderForDebugRecords() {
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        rootLogger.addHandler(new FilteringLogToStdoutJulHandler(Level.FINE));
    }

    @NotNull
    public static Path getTestLogDir() {
        String property = System.getProperty("idea.log.path");
        Path path = property == null ? Path.of(PathManager.getSystemPath(), LOG_DIR) : Path.of(property, new String[0]).normalize();
        if (path == null) {
            TestLoggerFactory.$$$reportNull$$$0(1);
        }
        return path;
    }

    public static void dumpLogToStdout(@NotNull String testStartMarker) {
        if (testStartMarker == null) {
            TestLoggerFactory.$$$reportNull$$$0(2);
        }
        TestLoggerFactory.dumpLogTo(testStartMarker, System.out);
    }

    public static void dumpLogTo(@NotNull String testStartMarker, PrintStream out) {
        Path logFile;
        if (testStartMarker == null) {
            TestLoggerFactory.$$$reportNull$$$0(3);
        }
        if (Files.exists(logFile = TestLoggerFactory.getTestLogDir().resolve(LOG_FILE_NAME), new LinkOption[0])) {
            try {
                String logText;
                long length = Files.size(logFile);
                if (length > 102400L) {
                    try (RandomAccessFile file = new RandomAccessFile(logFile.toFile(), "r");){
                        file.seek(length - 102400L);
                        byte[] bytes = new byte[102400];
                        int read = file.read(bytes);
                        logText = new String(bytes, 0, read, StandardCharsets.UTF_8);
                    }
                } else {
                    logText = Files.readString(logFile);
                }
                out.println("\n\nIdea Log at " + String.valueOf(logFile) + ":");
                int startPos = logText.lastIndexOf(testStartMarker);
                out.println(startPos > 0 ? logText.substring(startPos) : logText);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, Class<?> ... classes) {
        if (parentDisposable == null) {
            TestLoggerFactory.$$$reportNull$$$0(4);
        }
        if (classes == null) {
            TestLoggerFactory.$$$reportNull$$$0(5);
        }
        TestLoggerFactory.enableDebugLogging(parentDisposable, Stream.of(classes).map(klass -> "#" + klass.getName()));
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, String ... categories) {
        if (parentDisposable == null) {
            TestLoggerFactory.$$$reportNull$$$0(6);
        }
        if (categories == null) {
            TestLoggerFactory.$$$reportNull$$$0(7);
        }
        TestLoggerFactory.enableDebugLogging(parentDisposable, Stream.of(categories));
    }

    private static void enableDebugLogging(@NotNull Disposable parentDisposable, @NotNull Stream<String> categories) {
        if (parentDisposable == null) {
            TestLoggerFactory.$$$reportNull$$$0(8);
        }
        if (categories == null) {
            TestLoggerFactory.$$$reportNull$$$0(9);
        }
        categories.map(Logger::getInstance).filter(logger -> !logger.isDebugEnabled()).forEach(logger -> {
            logger.setLevel(LogLevel.DEBUG);
            Disposer.register((Disposable)parentDisposable, () -> logger.setLevel(LogLevel.INFO));
        });
    }

    public static void enableTraceLogging(@NotNull Disposable parentDisposable, Class<?> ... classes) {
        if (parentDisposable == null) {
            TestLoggerFactory.$$$reportNull$$$0(10);
        }
        if (classes == null) {
            TestLoggerFactory.$$$reportNull$$$0(11);
        }
        for (Class<?> klass : classes) {
            Logger logger = Logger.getInstance((String)("#" + klass.getName()));
            if (logger.isTraceEnabled()) continue;
            logger.setLevel(LogLevel.TRACE);
            Disposer.register((Disposable)parentDisposable, () -> logger.setLevel(LogLevel.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buffer(@NotNull LogLevel level, @NotNull String category, @Nullable String message, @Nullable Throwable t) {
        if (level == null) {
            TestLoggerFactory.$$$reportNull$$$0(12);
        }
        if (category == null) {
            TestLoggerFactory.$$$reportNull$$$0(13);
        }
        String source = category.substring(Math.max(category.length() - 30, 0));
        String format = String.format("%1$tH:%1$tM:%1$tS,%1$tL %2$-6s %3$30s - ", System.currentTimeMillis(), level.getLevelName(), source);
        StringBuilder stringBuilder = this.myBuffer;
        synchronized (stringBuilder) {
            this.myBuffer.append(format);
            if (message != null) {
                this.myBuffer.append(message);
            }
            this.myBuffer.append(System.lineSeparator());
            if (t != null) {
                StringWriter writer = new StringWriter(4096);
                t.printStackTrace(new PrintWriter(writer));
                this.myBuffer.append(writer.getBuffer());
                this.myBuffer.append(System.lineSeparator());
            }
            if (this.myBuffer.length() > MAX_BUFFER_LENGTH) {
                this.myBuffer.delete(0, this.myBuffer.length() - MAX_BUFFER_LENGTH + MAX_BUFFER_LENGTH / 4);
            }
        }
    }

    @Nullable
    private static String dumpComparisonFailures(@Nullable Throwable t) {
        if (t == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ExceptionUtil.causeAndSuppressed((Throwable)t, ComparisonFailure.class).forEach(e -> TestLoggerFactory.logComparisonFailure(sb, e.getExpected(), e.getActual()));
        ExceptionUtil.causeAndSuppressed((Throwable)t, junit.framework.ComparisonFailure.class).forEach(e -> TestLoggerFactory.logComparisonFailure(sb, e.getExpected(), e.getActual()));
        return sb.isEmpty() ? null : sb.toString();
    }

    private static void logComparisonFailure(@NotNull StringBuilder sb, @Nullable String expected, @Nullable String actual) {
        if (sb == null) {
            TestLoggerFactory.$$$reportNull$$$0(14);
        }
        if (expected == null && actual == null) {
            return;
        }
        sb.append("Comparison Failure").append(System.lineSeparator());
        if (actual == null) {
            sb.append("Actual [null]");
        } else {
            sb.append("Actual [[").append(actual).append("]]");
        }
        sb.append(System.lineSeparator());
        if (expected == null) {
            sb.append("Expected [null]");
        } else {
            sb.append("Expected [[").append(expected).append("]]");
        }
        sb.append(System.lineSeparator());
    }

    public static void onTestStarted() {
        myRethrowErrorsNumber.set(0);
        TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
        if (factory != null) {
            factory.clearLogBuffer();
            DebugArtifactPublisher publisher = factory.myDebugArtifactPublisher.getAndSet(null);
            if (publisher != null) {
                publisher.cleanup();
            }
            factory.myTestStartedMillis = System.currentTimeMillis();
        }
    }

    public static void onTestFinished(boolean success, @NotNull Description description) {
        if (description == null) {
            TestLoggerFactory.$$$reportNull$$$0(15);
        }
        TestLoggerFactory.onTestFinished(success, description.getDisplayName());
    }

    public static void onTestFinished(boolean success, @NotNull String testName) {
        TestLoggerFactory factory;
        if (testName == null) {
            TestLoggerFactory.$$$reportNull$$$0(16);
        }
        if ((factory = TestLoggerFactory.getTestLoggerFactory()) != null) {
            factory.myTestStartedMillis = 0L;
            DebugArtifactPublisher publisher = factory.myDebugArtifactPublisher.getAndSet(null);
            if (publisher != null) {
                if (!success) {
                    publisher.publishArtifacts(testName);
                } else {
                    publisher.cleanup();
                }
            }
            factory.dumpLogBuffer(success, testName);
        }
    }

    public static void logTestFailure(@Nullable Throwable t) {
        TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
        if (factory != null) {
            String comparisonFailures = TestLoggerFactory.dumpComparisonFailures(t);
            Object message = comparisonFailures != null ? "test failed: " + comparisonFailures : "Test failed";
            factory.buffer(LogLevel.ERROR, "#TestFramework", (String)message, t);
        }
    }

    public static void publishArtifactIfTestFails(@NotNull Path artifactPath, @NotNull String artifactName) {
        TestLoggerFactory factory;
        if (artifactPath == null) {
            TestLoggerFactory.$$$reportNull$$$0(17);
        }
        if (artifactName == null) {
            TestLoggerFactory.$$$reportNull$$$0(18);
        }
        if ((factory = TestLoggerFactory.getTestLoggerFactory()) != null) {
            factory.getOrCreateDebugArtifactPublisher().storeArtifact(artifactPath, artifactName);
        }
    }

    private DebugArtifactPublisher getOrCreateDebugArtifactPublisher() {
        DebugArtifactPublisher publisher = this.myDebugArtifactPublisher.get();
        if (publisher != null) {
            return publisher;
        }
        Path storagePath = PathManager.getLogDir().resolve("debug-artifacts");
        this.myDebugArtifactPublisher.compareAndSet(null, new DebugArtifactPublisher(storagePath));
        return this.myDebugArtifactPublisher.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLogBuffer() {
        StringBuilder stringBuilder = this.myBuffer;
        synchronized (stringBuilder) {
            this.myBuffer.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLogBuffer(boolean success, @NotNull String testName) {
        Object buffer;
        if (testName == null) {
            TestLoggerFactory.$$$reportNull$$$0(19);
        }
        StringBuilder stringBuilder = this.myBuffer;
        synchronized (stringBuilder) {
            buffer = success || this.myBuffer.isEmpty() ? null : this.myBuffer.toString();
            this.myBuffer.setLength(0);
        }
        if (buffer != null) {
            if (this.mySplitTestLogs) {
                Path logDir = TestLoggerFactory.getTestLogDir().resolve(SPLIT_LOGS_SUBDIR);
                Path logFile = FileUtil.findSequentNonexistentFile((File)logDir.toFile(), (String)FileUtil.sanitizeFileName((String)testName), (String)"log").toPath();
                try {
                    Files.createDirectories(logDir, new FileAttribute[0]);
                    Files.writeString(logFile, (CharSequence)buffer, new OpenOption[0]);
                    String headerFooter = StringUtil.repeat((String)"=", (int)80);
                    buffer = "\n" + headerFooter + "\nLog saved to: " + String.valueOf(logFile) + "\n" + headerFooter + "\n";
                }
                catch (IOException e) {
                    buffer = (String)buffer + "\nError writing split log, disabling splitting: " + String.valueOf(logFile) + "\n" + String.valueOf(e);
                    this.mySplitTestLogs = false;
                }
            }
            if (System.getenv("TEAMCITY_VERSION") != null) {
                String finalBuffer = buffer;
                TeamCityLogger.block("DEBUG log", () -> System.out.println(finalBuffer));
            } else {
                List lines2 = LineTokenizer.tokenizeIntoList((CharSequence)buffer, (boolean)false, (boolean)false);
                if (!((String)lines2.get(0)).startsWith("\n")) {
                    lines2 = ContainerUtil.prepend(lines2.subList(1, lines2.size()), (Object[])new String[]{"\n" + (String)lines2.get(0)});
                }
                System.err.println(String.join((CharSequence)"\u2003\n", lines2));
            }
        }
    }

    @NotNull
    public static TestRule createTestWatcher() {
        RuleChain ruleChain = RuleChain.emptyRuleChain().around((TestRule)new TestWatcher(){

            protected void succeeded(Description description) {
                TestLoggerFactory.onTestFinished(true, description);
            }

            protected void failed(Throwable e, Description description) {
                TestLoggerFactory.logTestFailure(e);
                TestLoggerFactory.onTestFinished(false, description);
            }

            protected void skipped(AssumptionViolatedException e, Description description) {
                TestLoggerFactory.onTestFinished(true, description);
            }

            protected void starting(@NotNull Description d) {
                if (d == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestLoggerFactory.onTestStarted();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/testFramework/TestLoggerFactory$1", "starting"));
            }
        }).around((base, description) -> new Statement(){

            public void evaluate() {
                TestLoggerKt.recordErrorsLoggedInTheCurrentThreadAndReportThemAsFailures(() -> base.evaluate());
            }
        });
        if (ruleChain == null) {
            TestLoggerFactory.$$$reportNull$$$0(20);
        }
        return ruleChain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TestLoggerFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartMarker";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TestLoggerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLogDir";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
            case 1: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dumpLogToStdout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dumpLogTo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enableDebugLogging";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableTraceLogging";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buffer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logComparisonFailure";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onTestFinished";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "publishArtifactIfTestFails";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "dumpLogBuffer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 20 -> new IllegalStateException(string);
        };
    }

    private static final class TestLogger
    extends JulLogger {
        private final TestLoggerFactory myFactory;

        private TestLogger(java.util.logging.Logger julLogger, TestLoggerFactory factory) {
            super(julLogger);
            this.myFactory = factory;
        }

        public void error(String message, @Nullable Throwable t, String ... details) {
            if (details == null) {
                TestLogger.$$$reportNull$$$0(0);
            }
            Set<LoggedErrorProcessor.Action> actions = LoggedErrorProcessor.getInstance().processError(this.getLoggerName(), Objects.requireNonNullElse(message, ""), details, t);
            ErrorLog errorLog = TestLoggerKt.getErrorLog();
            if (actions.contains((Object)LoggedErrorProcessor.Action.RETHROW) && errorLog != null) {
                errorLog.recordLoggedError((String)message, t);
                return;
            }
            if (actions.contains((Object)LoggedErrorProcessor.Action.LOG)) {
                if (t instanceof TestLoggerAssertionError && ((String)message).equals(t.getMessage()) && details.length == 0) {
                    throw (TestLoggerAssertionError)((Object)t);
                }
                message = (String)message + DefaultLogger.detailsToString((String[])details) + DefaultLogger.attachmentsToString((Throwable)t);
                t = TestLogger.ensureNotControlFlow((Throwable)t);
                if (this.myFactory.mySplitTestLogs) {
                    this.myFactory.buffer(LogLevel.ERROR, this.getLoggerName(), (String)message, t);
                }
                super.info((String)message, t);
            }
            if (actions.contains((Object)LoggedErrorProcessor.Action.STDERR) && DefaultLogger.shouldDumpExceptionToStderr()) {
                System.err.println("ERROR: " + (String)message);
                if (t != null) {
                    t.printStackTrace(System.err);
                }
            }
            if (actions.contains((Object)LoggedErrorProcessor.Action.RETHROW)) {
                myRethrowErrorsNumber.incrementAndGet();
                throw new TestLoggerAssertionError((String)message, t);
            }
        }

        public void warn(String message, @Nullable Throwable t) {
            if (LoggedErrorProcessor.getInstance().processWarn(this.getLoggerName(), Objects.requireNonNullElse(message, ""), t)) {
                message = (String)message + DefaultLogger.attachmentsToString((Throwable)t);
                t = TestLogger.ensureNotControlFlow((Throwable)t);
                if (this.myFactory.mySplitTestLogs) {
                    this.myFactory.buffer(LogLevel.WARNING, this.getLoggerName(), (String)message, t);
                }
                super.warn((String)message, t);
            }
        }

        public void info(String message, @Nullable Throwable t) {
            super.info(message, t);
            this.myFactory.buffer(LogLevel.INFO, this.getLoggerName(), message, t);
        }

        public void debug(String message, @Nullable Throwable t) {
            if (this.isDebugEnabled()) {
                super.debug(message, t);
                this.myFactory.buffer(LogLevel.DEBUG, this.getLoggerName(), message, t);
            }
        }

        public void trace(String message) {
            if (this.isTraceEnabled()) {
                super.trace(message);
                this.myFactory.buffer(LogLevel.TRACE, this.getLoggerName(), message, null);
            }
        }

        public void trace(@Nullable Throwable t) {
            if (this.isTraceEnabled()) {
                super.trace(t);
                this.myFactory.buffer(LogLevel.TRACE, this.getLoggerName(), null, t);
            }
        }

        public boolean isDebugEnabled() {
            return !Accessor.isInStressTest() || super.isDebugEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/testFramework/TestLoggerFactory$TestLogger", "error"));
        }

        private static class Accessor {
            @NotNull
            private static final MethodHandle isInStressTest = Accessor.getMethodHandle();

            private Accessor() {
            }

            @NotNull
            private static MethodHandle getMethodHandle() {
                MethodHandle methodHandle;
                try {
                    Class<?> clazz = Class.forName("com.intellij.openapi.application.ex.ApplicationManagerEx");
                    MethodHandle handle = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup()).findStatic(clazz, "isInStressTest", MethodType.methodType(Boolean.TYPE));
                    Object result = handle.invokeWithArguments(new Object[0]);
                    assert (result instanceof Boolean);
                    methodHandle = handle;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                if (methodHandle == null) {
                    Accessor.$$$reportNull$$$0(0);
                }
                return methodHandle;
            }

            private static boolean isInStressTest() {
                try {
                    return (Boolean)isInStressTest.invokeWithArguments(new Object[0]);
                }
                catch (Throwable ignored) {
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TestLoggerFactory$TestLogger$Accessor", "getMethodHandle"));
            }
        }
    }

    private static class FilteringLogToStdoutJulHandler
    extends LogToStdoutJulHandler {
        FilteringLogToStdoutJulHandler(Level level) {
            this.setFilter(record -> record.getLevel().intValue() <= level.intValue());
        }
    }

    private static class WithTimeSinceTestStartedJulFormatter
    extends IdeaLogRecordFormatter {
        WithTimeSinceTestStartedJulFormatter() {
            super(true);
        }

        protected long getStartedMillis() {
            TestLoggerFactory factory = TestLoggerFactory.getTestLoggerFactory();
            return factory == null ? 0L : factory.myTestStartedMillis;
        }
    }

    public static class LogToStdoutJulHandler
    extends StreamHandler {
        private boolean initialized;

        public LogToStdoutJulHandler() {
            super(System.out, (Formatter)((Object)new WithTimeSinceTestStartedJulFormatter()));
            this.setLevel(Level.ALL);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        @Override
        protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
            if (this.initialized) {
                throw new UnsupportedOperationException("TestLoggerFactory.setOutputStream");
            }
            super.setOutputStream(out);
            this.initialized = true;
        }

        @Override
        public synchronized void close() {
            this.flush();
        }
    }

    @ApiStatus.Internal
    public static final class TestLoggerAssertionError
    extends AssertionError {
        TestLoggerAssertionError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

