/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion.collectionAssertion;

import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opentest4j.AssertionFailedError;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J@\u0010\r\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J<\u0010\u000e\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J<\u0010\u000f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J.\u0010\u0010\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J;\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u00062\u0006\u0010\t\u001a\u0002H\u00062\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/testFramework/assertion/collectionAssertion/CollectionAssertions;", "", "<init>", "()V", "assertEqualsOrdered", "", "T", "expected", "", "actual", "messageSupplier", "Lkotlin/Function0;", "", "assertEqualsUnordered", "doAssertEqualsUnordered", "assertContainsUnordered", "assertEmpty", "throwAssertionFailedError", "", "description", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)Ljava/lang/Void;", "intellij.platform.testFramework"})
public final class CollectionAssertions {
    @NotNull
    public static final CollectionAssertions INSTANCE = new CollectionAssertions();

    private CollectionAssertions() {
    }

    @JvmStatic
    public static final <T> void assertEqualsOrdered(@Nullable Collection<? extends T> expected, @Nullable Collection<? extends T> actual, @Nullable Function0<String> messageSupplier) {
        CollectionAssertions.assertEqualsUnordered(expected, actual, messageSupplier);
        Collection<? extends T> collection = expected;
        Collection<? extends T> collection2 = actual;
        if (!Intrinsics.areEqual((Object)(collection != null ? CollectionsKt.toList((Iterable)collection) : null), (Object)(collection2 != null ? CollectionsKt.toList((Iterable)collection2) : null))) {
            INSTANCE.throwAssertionFailedError(expected, actual, messageSupplier, "Incorrect actual elements order.");
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void assertEqualsOrdered$default(Collection collection, Collection collection2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        CollectionAssertions.assertEqualsOrdered(collection, collection2, (Function0<String>)function0);
    }

    @JvmStatic
    public static final <T> void assertEqualsUnordered(@Nullable Collection<? extends T> expected, @Nullable Collection<? extends T> actual, @Nullable Function0<String> messageSupplier) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            INSTANCE.throwAssertionFailedError(expected, actual, messageSupplier, StringsKt.trimMargin$default((String)("\n        |Expecting actual:\n        |  " + actual + "\n        |to match:\n        |  " + expected + "\n        |but one of them is null.\n      "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
        INSTANCE.doAssertEqualsUnordered(expected, actual, messageSupplier);
    }

    public static /* synthetic */ void assertEqualsUnordered$default(Collection collection, Collection collection2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        CollectionAssertions.assertEqualsUnordered(collection, collection2, (Function0<String>)function0);
    }

    private final <T> void doAssertEqualsUnordered(Collection<? extends T> expected, Collection<? extends T> actual, Function0<String> messageSupplier) {
        Set expectedSet = CollectionsKt.toSet((Iterable)expected);
        Set actualSet = CollectionsKt.toSet((Iterable)actual);
        Set notFound = SetsKt.minus((Set)expectedSet, (Iterable)actualSet);
        Set notExpected = SetsKt.minus((Set)actualSet, (Iterable)expectedSet);
        if (!((Collection)notExpected).isEmpty() && !((Collection)notFound).isEmpty()) {
            this.throwAssertionFailedError(expected, actual, messageSupplier, StringsKt.trimMargin$default((String)("\n        |Expecting actual:\n        |  " + actual + "\n        |to contain exactly in any order:\n        |  " + expected + "\n        |elements not found:\n        |  " + notFound + "\n        |and elements not expected:\n        |  " + notExpected + "\n      "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
        if (!((Collection)notFound).isEmpty()) {
            this.throwAssertionFailedError(expected, actual, messageSupplier, StringsKt.trimMargin$default((String)("\n        |Expecting actual:\n        |  " + actual + "\n        |to contain exactly in any order:\n        |  " + expected + "\n        |but could not find the following elements:\n        |  " + notFound + "\n      "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
        if (!((Collection)notExpected).isEmpty()) {
            this.throwAssertionFailedError(expected, actual, messageSupplier, StringsKt.trimMargin$default((String)("\n        |Expecting actual:\n        |  " + actual + "\n        |to contain exactly in any order:\n        |  " + expected + "\n        |but the following elements were unexpected:\n        |  " + notExpected + "\n      "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
    }

    static /* synthetic */ void doAssertEqualsUnordered$default(CollectionAssertions collectionAssertions, Collection collection, Collection collection2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        collectionAssertions.doAssertEqualsUnordered(collection, collection2, (Function0<String>)function0);
    }

    @JvmStatic
    public static final <T> void assertContainsUnordered(@NotNull Collection<? extends T> expected, @NotNull Collection<? extends T> actual, @Nullable Function0<String> messageSupplier) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Set expectedSet = CollectionsKt.toSet((Iterable)expected);
        Set actualSet = CollectionsKt.toSet((Iterable)actual);
        Set notFound = SetsKt.minus((Set)expectedSet, (Iterable)actualSet);
        if (!((Collection)notFound).isEmpty()) {
            INSTANCE.throwAssertionFailedError(expected, actual, messageSupplier, StringsKt.trimMargin$default((String)("\n        |Expecting actual:\n        |  " + actual + "\n        |to contain in any order:\n        |  " + expected + "\n        |but could not find the following elements:\n        |  " + notFound + "\n      "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void assertContainsUnordered$default(Collection collection, Collection collection2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        CollectionAssertions.assertContainsUnordered(collection, collection2, (Function0<String>)function0);
    }

    @JvmStatic
    public static final <T> void assertEmpty(@NotNull Collection<? extends T> actual, @Nullable Function0<String> messageSupplier) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        if (!actual.isEmpty()) {
            INSTANCE.throwAssertionFailedError(CollectionsKt.emptyList(), actual, messageSupplier, StringsKt.trimMargin$default((String)("\n        |Expecting empty but was:\n        |  " + actual + "\n      "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void assertEmpty$default(Collection collection, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        CollectionAssertions.assertEmpty(collection, (Function0<String>)function0);
    }

    private final <T> Void throwAssertionFailedError(T expected, T actual, Function0<String> messageSupplier, String description) {
        Function0<String> function0 = messageSupplier;
        String message = function0 != null ? (String)function0.invoke() : null;
        String message2 = message == null ? description : message + "\n" + description;
        throw new AssertionFailedError(message2, expected, actual);
    }
}

