/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddColumnAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddColumnAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddColumnAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(GridUtil.canMutateColumns((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            AddColumnAction.$$$reportNull$$$0(2);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        AddColumnAction.insertColumn(dataGrid);
    }

    public static void insertColumn(@NotNull DataGrid grid) {
        GridDataHookUp hookup;
        if (grid == null) {
            AddColumnAction.$$$reportNull$$$0(3);
        }
        if ((hookup = grid.getDataHookup()) instanceof CsvDocumentDataHookUp) {
            CsvFormat format = ((CsvDocumentDataHookUp)hookup).getFormat();
            if (format.headerRecord == null) {
                AddColumnAction.insertColumn(grid, null);
                return;
            }
        }
        NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
        JTextField nameField = contentPanel.getTextField();
        String defaultColumnName = GridUtilCore.generateColumnName((GridModel)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS));
        nameField.setText(defaultColumnName);
        nameField.selectAll();
        JBPopup popup = NewItemPopupUtil.createNewItemPopup((String)DataGridBundle.message((String)"action.insert.column.dialog.title", (Object[])new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
        contentPanel.setApplyAction(event -> {
            String name = nameField.getText();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            popup.closeOk(event);
            AddColumnAction.insertColumn(grid, name);
        });
        popup.showCenteredInCurrentWindow(grid.getProject());
    }

    public static void insertColumn(@NotNull DataGrid grid, @Nullable String columnName) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            AddColumnAction.$$$reportNull$$$0(4);
        }
        if ((mutator = GridUtil.getColumnsMutator(grid)) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.insertColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), columnName));
            return;
        }
        mutator.insertColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), columnName);
    }

    public static GridRequestSource newInsertOrCloneColumnRequestSource(@NotNull DataGrid grid) {
        if (grid == null) {
            AddColumnAction.$$$reportNull$$$0(5);
        }
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid));
        source.getActionCallback().doWhenDone(() -> {
            ModelIndex column = ModelIndex.forColumn((CoreGrid)grid, (int)(grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnCount() - 1));
            GridUtil.scrollToLocally(grid, (ViewIndex<GridRow>)ViewIndex.forRow((CoreGrid)grid, (int)0), (ViewIndex<GridColumn>)column.toView((CoreGrid)grid));
        });
        return source;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/AddColumnAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/AddColumnAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertColumn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newInsertOrCloneColumnRequestSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

