/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.listener;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.ref.WeakReference;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class WeakEventListener
implements AWTEventListener {
    private final WeakReference<AWTEventListener> listenerReference;
    private final Toolkit toolkit;

    @Nonnull
    public static WeakEventListener attachAsWeakEventListener(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener listener, long eventMask) {
        WeakEventListener l = new WeakEventListener(toolkit, listener);
        toolkit.addAWTEventListener(l, eventMask);
        return l;
    }

    private WeakEventListener(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener listener) {
        this.listenerReference = new WeakReference<AWTEventListener>(listener);
        this.toolkit = toolkit;
    }

    @Nonnull
    public AWTEventListener underlyingListener() {
        return (AWTEventListener)this.listenerReference.get();
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        AWTEventListener listener = (AWTEventListener)this.listenerReference.get();
        if (listener == null) {
            this.dispose();
            return;
        }
        listener.eventDispatched(e);
    }

    public void dispose() {
        this.toolkit.removeAWTEventListener(this);
    }

    @VisibleForTesting
    void simulateUnderlyingListenerIsGarbageCollected() {
        this.listenerReference.clear();
    }
}

