/*
 * Decompiled with CFR 0.152.
 */
package training.git.lesson;

import com.intellij.openapi.project.Project;
import git4idea.config.GitExecutableManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.git.GitLessonsUtil;
import training.git.GitProjectUtil;
import training.learn.course.KLesson;
import training.learn.course.LessonProperties;
import training.learn.exceptons.LessonPreparationException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0007\u001a\u00020\u0003X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR%\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Ltraining/git/lesson/GitLesson;", "Ltraining/learn/course/KLesson;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "branchName", "getBranchName", "()Ljava/lang/String;", "properties", "Ltraining/learn/course/LessonProperties;", "getProperties", "()Ltraining/learn/course/LessonProperties;", "fullLessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getFullLessonContent", "()Lkotlin/jvm/functions/Function1;", "prepare", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git.featuresTrainer"})
public abstract class GitLesson
extends KLesson {
    @NotNull
    private final LessonProperties properties;

    public GitLesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(id, name);
        this.properties = new LessonProperties(false, false, "212", 3, null);
    }

    @NotNull
    protected abstract String getBranchName();

    @Override
    @NotNull
    public LessonProperties getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Function1<LessonContext, Unit> getFullLessonContent() {
        return arg_0 -> GitLesson._get_fullLessonContent_$lambda$0(this, arg_0);
    }

    @Override
    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!GitExecutableManager.getInstance().testGitExecutableVersionValid(project)) {
            throw new LessonPreparationException("Git is not installed or version is invalid", null, 2, null);
        }
        GitProjectUtil.INSTANCE.restoreGitLessonsFiles(project, this.getBranchName());
    }

    private static final Unit _get_fullLessonContent_$lambda$0(GitLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        GitLessonsUtil.INSTANCE.refreshGitLogOnOpen(lessonContext);
        super.getFullLessonContent().invoke((Object)lessonContext);
        return Unit.INSTANCE;
    }
}

