/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.RawSwingDispatcher;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStatusBarProgress;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CannotAddVcsLogWindowException;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogManagerKt;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLogBaseKt;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 X2\u00020\u0001:\u0005TUVWXBY\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u001a\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u00104\u001a\u00020\u0012H\u0007J\b\u00105\u001a\u00020\u0012H\u0007J\b\u00106\u001a\u00020\u0012H\u0007J\b\u00107\u001a\u00020\u000bH\u0007J\u001a\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000b2\b\u0010;\u001a\u0004\u0018\u00010<H\u0007J\"\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u0002090>2\u0006\u0010:\u001a\u00020\u000b2\b\u0010;\u001a\u0004\u0018\u00010<H\u0005J%\u00108\u001a\u0002H?\"\b\b\u0000\u0010?*\u00020&2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H?0>H\u0007\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020&H\u0002J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0016J\b\u0010G\u001a\u00020\u000bH\u0007J\b\u0010H\u001a\u00020\u0012H\u0015J\u0012\u0010I\u001a\u00020\u00122\b\u0010J\u001a\u0004\u0018\u00010KH\u0007J\b\u0010L\u001a\u00020\u0012H\u0003J\b\u0010M\u001a\u00020\rH\u0002J\"\u0010I\u001a\u00020\u00122\b\b\u0002\u0010N\u001a\u00020\r2\b\b\u0002\u0010O\u001a\u00020\rH\u0087@\u00a2\u0006\u0002\u0010PJ,\u0010Q\u001a\u00020\u00122\u0006\u0010R\u001a\u00020\u001c2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010S\u001a\u00020#H\u0002R\u0016\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00101R\u0011\u00103\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b3\u00101\u00a8\u0006Y"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "name", "", "isIndexEnabled", "", "errorHandler", "Lkotlin/Function2;", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler$Source;", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;Ljava/util/Map;Ljava/lang/String;ZLkotlin/jvm/functions/Function2;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getUiProperties", "()Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;", "getName", "()Ljava/lang/String;", "dataDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "getDataManager", "()Lcom/intellij/vcs/log/data/VcsLogData;", "postponableRefresher", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher;", "managedUis", "", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "uiRegistrationTraces", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "getColorManager", "()Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "statusBarProgress", "Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress;", "disposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isDisposed", "()Z", "isLogVisible", "isLogUpToDate", "initialize", "initializeIfNeeded", "scheduleUpdate", "generateNewLogId", "createLogUi", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "logId", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "getMainLogUiFactory", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "U", "factory", "(Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;)Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "installRefresher", "ui", "getLogUis", "", "Lcom/intellij/vcs/log/VcsLogUi;", "getLogUiInformation", "disposeUi", "dispose", "callback", "Ljava/lang/Runnable;", "disposeData", "startDisposing", "useRawSwingDispatcher", "clearStorage", "(ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshLogOnVcsEvents", "disposableParent", "refresher", "MyErrorHandler", "VcsLogUiFactory", "BaseVcsLogUiFactory", "MainVcsLogUiFactory", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.NonExtendable
@SourceDebugExtension(value={"SMAP\nVcsLogManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogManager.kt\ncom/intellij/vcs/log/impl/VcsLogManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n188#2,3:477\n216#2,2:482\n1869#3,2:480\n*S KotlinDebug\n*F\n+ 1 VcsLogManager.kt\ncom/intellij/vcs/log/impl/VcsLogManager\n*L\n79#1:477,3\n302#1:482,2\n220#1:480,2\n*E\n"})
public class VcsLogManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ApiStatus.Internal
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogTabsProperties uiProperties;
    @ApiStatus.Internal
    @NotNull
    private final String name;
    @Nullable
    private final Function2<VcsLogErrorHandler.Source, Throwable, Unit> errorHandler;
    @NotNull
    private final Disposable dataDisposable;
    @NotNull
    private final VcsLogData dataManager;
    @NotNull
    private final PostponableLogRefresher postponableRefresher;
    @NotNull
    private final Map<String, VcsLogUiEx> managedUis;
    @NotNull
    private final Map<String, Throwable> uiRegistrationTraces;
    @NotNull
    private final VcsLogColorManager colorManager;
    @NotNull
    private final VcsLogStatusBarProgress statusBarProgress;
    @NotNull
    private final AtomicBoolean disposed;
    @ApiStatus.Internal
    @NotNull
    public static final String MAIN_LOG_ID = "MAIN";
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull String name, boolean isIndexEnabled, @Nullable Function2<? super VcsLogErrorHandler.Source, ? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.project = project;
        this.uiProperties = uiProperties;
        this.name = name;
        this.errorHandler = errorHandler;
        Disposable disposable = Disposer.newDisposable((String)("Vcs Log Data Disposable for " + this.name));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.dataDisposable = disposable;
        this.dataManager = new VcsLogData(this.project, logProviders, new MyErrorHandler(), isIndexEnabled, this.dataDisposable);
        this.postponableRefresher = new PostponableLogRefresher(this.dataManager);
        this.managedUis = new LinkedHashMap();
        this.uiRegistrationTraces = new LinkedHashMap();
        this.colorManager = VcsLogColorManagerFactory.create(logProviders.keySet());
        Set<VirtualFile> set = this.dataManager.getIndex().getIndexingRoots();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
        VcsLogProgress vcsLogProgress = this.dataManager.getProgress();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogProgress, (String)"getProgress(...)");
        this.statusBarProgress = new VcsLogStatusBarProgress(this.project, logProviders, set, vcsLogProgress);
        this.disposed = new AtomicBoolean(false);
        this.refreshLogOnVcsEvents(this.dataManager, logProviders, this.postponableRefresher);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VcsLogTabsProperties getUiProperties() {
        return this.uiProperties;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final VcsLogData getDataManager() {
        return this.dataManager;
    }

    @NotNull
    public final VcsLogColorManager getColorManager() {
        return this.colorManager;
    }

    public final boolean isDisposed() {
        return this.disposed.get();
    }

    private final boolean isLogVisible() {
        boolean bl;
        block3: {
            Map<String, VcsLogUiEx> $this$any$iv = this.managedUis;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, VcsLogUiEx>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, VcsLogUiEx> element$iv;
                    Map.Entry<String, VcsLogUiEx> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!VcsLogManagerKt.access$isVisible(it.getValue())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @RequiresEdt
    public final boolean isLogUpToDate() {
        return this.dataManager.getDataPack().isFull() && !this.postponableRefresher.hasPostponedRoots();
    }

    @ApiStatus.Internal
    public final void initialize() {
        this.dataManager.initialize();
    }

    @ApiStatus.Internal
    public final void initializeIfNeeded() {
        if (this.isLogVisible()) {
            this.dataManager.initialize();
        }
    }

    @ApiStatus.Internal
    @RequiresEdt
    public final void scheduleUpdate() {
        this.initialize();
        this.postponableRefresher.refreshPostponedRoots();
    }

    @ApiStatus.Internal
    @NotNull
    public final String generateNewLogId() {
        Set<String> existingIds = this.managedUis.keySet();
        String newId = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)UUID.randomUUID().toString(), (String)"toString(...)");
        } while (existingIds.contains(newId));
        return newId;
    }

    @ApiStatus.Internal
    @NotNull
    public final MainVcsLogUi createLogUi(@NotNull String logId, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        return this.createLogUi(this.getMainLogUiFactory(logId, filters));
    }

    @ApiStatus.Internal
    @NotNull
    protected final VcsLogUiFactory<? extends MainVcsLogUi> getMainLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        CustomVcsLogUiFactoryProvider factoryProvider = (CustomVcsLogUiFactoryProvider)CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.findFirstSafe((AreaInstance)this.project, arg_0 -> VcsLogManager.getMainLogUiFactory$lambda$2(arg_0 -> VcsLogManager.getMainLogUiFactory$lambda$1(this, arg_0), arg_0));
        if (factoryProvider == null) {
            return new MainVcsLogUiFactory(logId, filters, this.uiProperties, this.colorManager);
        }
        VcsLogUiFactory<? extends MainVcsLogUi> vcsLogUiFactory = factoryProvider.createLogUiFactory(logId, this, filters);
        Intrinsics.checkNotNullExpressionValue(vcsLogUiFactory, (String)"createLogUiFactory(...)");
        return vcsLogUiFactory;
    }

    @ApiStatus.Internal
    @NotNull
    public final <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            LOG.error("Trying to create new VcsLogUi on a disposed VcsLogManager instance");
            throw new ProcessCanceledException();
        }
        U ui = factory.createLogUi(this.project, this.dataManager);
        String string = ((VcsLogUi)ui).getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String id = string;
        if (this.managedUis.containsKey(id)) {
            Disposer.dispose((Disposable)((Disposable)ui));
            throw new CannotAddVcsLogWindowException("Log ui with id '" + id + "' was already added. Existing uis:\n" + this.getLogUiInformation(), this.uiRegistrationTraces.get(id));
        }
        this.managedUis.put(id, (VcsLogUiEx)ui);
        this.uiRegistrationTraces.put(id, new Throwable("Creation trace for " + ui));
        this.installRefresher((VcsLogUiEx)ui);
        Disposer.register((Disposable)((Disposable)ui), () -> VcsLogManager.createLogUi$lambda$3(ui, this, id));
        return ui;
    }

    private final void installRefresher(VcsLogUiEx ui) {
        Disposable disposable = ui;
        String string = ui.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.postponableRefresher.registerRefresher(disposable, string, new PostponableLogRefresher.Refresher(ui){
            final /* synthetic */ VcsLogUiEx $ui;
            {
                this.$ui = $ui;
            }

            public void setDataPack(DataPack dataPack) {
                Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
                VcsLogManager.access$getLOG$cp().debug("Refreshing log window " + this.$ui);
                this.$ui.getRefresher().setDataPack(VcsLogManagerKt.access$isVisible(this.$ui), dataPack);
            }

            public void validate(boolean refresh) {
                this.$ui.getRefresher().setValid(true, refresh);
            }
        });
        HierarchyListener listener2 = new HierarchyListener(ui, this){
            private boolean wasVisible;
            final /* synthetic */ VcsLogUiEx $ui;
            final /* synthetic */ VcsLogManager this$0;
            {
                this.$ui = $ui;
                this.this$0 = $receiver;
                this.wasVisible = VcsLogManagerKt.access$isVisible($ui);
            }

            public void hierarchyChanged(HierarchyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (BitUtil.isSet((long)e.getChangeFlags(), (long)4L)) {
                    boolean nowVisible = VcsLogManagerKt.access$isVisible(this.$ui);
                    if (nowVisible && !this.wasVisible) {
                        VcsLogUsageTriggerCollector.triggerTabNavigated(this.this$0.getProject());
                        VcsLogManager.access$getLOG$cp().debug("Activated log ui '" + this.$ui + "'");
                        PostponableLogRefresher postponableLogRefresher = VcsLogManager.access$getPostponableRefresher$p(this.this$0);
                        String string = this.$ui.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        postponableLogRefresher.refresherActivated(string);
                    }
                    this.wasVisible = nowVisible;
                }
            }
        };
        ui.getMainComponent().addHierarchyListener(listener2);
        Disposer.register((Disposable)ui, () -> VcsLogManager.installRefresher$lambda$4(ui, listener2));
    }

    @NotNull
    public List<VcsLogUi> getLogUis() {
        return CollectionsKt.toList((Iterable)this.managedUis.values());
    }

    @ApiStatus.Internal
    @NotNull
    public final String getLogUiInformation() {
        return CollectionsKt.joinToString$default((Iterable)this.managedUis.values(), (CharSequence)"\n", null, null, (int)0, null, VcsLogManager::getLogUiInformation$lambda$5, (int)30, null);
    }

    @ApiStatus.Internal
    @RequiresEdt
    protected void disposeUi() {
        ThreadingAssertions.assertEventDispatchThread();
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.managedUis.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VcsLogUiEx it = (VcsLogUiEx)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        Disposer.dispose((Disposable)this.statusBarProgress);
    }

    @ApiStatus.Obsolete
    @ApiStatus.Internal
    @RequiresEdt
    public final void dispose(@Nullable Runnable callback) {
        if (!this.startDisposing()) {
            return;
        }
        this.disposeUi();
        ApplicationManager.getApplication().executeOnPooledThread(() -> VcsLogManager.dispose$lambda$7(this, callback));
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    private final void disposeData() {
        ThreadingAssertions.assertBackgroundThread();
        Disposer.dispose((Disposable)this.dataDisposable);
        LOG.debug("Disposed " + this.name);
    }

    private final boolean startDisposing() {
        boolean wasNotStartedBefore = this.disposed.compareAndSet(false, true);
        if (!wasNotStartedBefore) {
            LOG.warn(this.name + " is already disposed. Ignoring dispose request", new Throwable("Dispose trace for " + this.name));
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @Nullable
    public final Object dispose(boolean useRawSwingDispatcher, boolean clearStorage, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof dispose.2)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                boolean Z$1;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VcsLogManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.dispose(false, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.startDisposing()) {
                    return Unit.INSTANCE;
                }
                uiDispatcher = useRawSwingDispatcher != false ? (CoroutineContext)RawSwingDispatcher.INSTANCE : CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uiDispatcher);
                $continuation.Z$0 = useRawSwingDispatcher;
                $continuation.Z$1 = clearStorage;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)uiDispatcher, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ VcsLogManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.this$0.disposeUi();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                clearStorage = $continuation.Z$1;
                useRawSwingDispatcher = $continuation.Z$0;
                uiDispatcher = (CoroutineContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uiDispatcher);
                $continuation.Z$0 = useRawSwingDispatcher;
                $continuation.Z$1 = clearStorage;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(clearStorage != false, this, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ boolean $clearStorage;
                    final /* synthetic */ VcsLogManager this$0;
                    {
                        this.$clearStorage = $clearStorage;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                storageToClear = this.$clearStorage != false ? VcsProjectLogBaseKt.storageIds(this.this$0) : CollectionsKt.emptyList();
                                VcsLogManager.access$disposeData(this.this$0);
                                var3_4 = storageToClear.iterator();
lbl8:
                                // 4 sources

                                while (var3_4.hasNext()) {
                                    storageId = var3_4.next();
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)storageToClear);
                                    this.L$1 = var3_4;
                                    this.L$2 = storageId;
                                    this.label = 1;
                                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(storageId, null){
                                        int label;
                                        final /* synthetic */ StorageId $storageId;
                                        {
                                            this.$storageId = $storageId;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    return Boxing.boxBoolean((boolean)this.$storageId.cleanupAllStorageFiles());
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    ** if (v0 != var6_2) goto lbl19
lbl18:
                                    // 1 sources

                                    return var6_2;
lbl19:
                                    // 1 sources

                                    ** GOTO lbl29
                                }
                                break;
                            }
                            case 1: {
                                storageId = (StorageId)this.L$2;
                                var3_4 = (Iterator<StorageId>)this.L$1;
                                storageToClear = (List)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl29:
                                    // 2 sources

                                    if (!(deleted = ((Boolean)v0).booleanValue())) ** GOTO lbl32
                                    VcsLogManager.access$getLOG$cp().info("Deleted " + storageId.getStoragePath());
                                    ** GOTO lbl8
lbl32:
                                    // 1 sources

                                    VcsLogManager.access$getLOG$cp().error("Could not delete " + storageId.getStoragePath());
                                }
                                catch (Throwable t) {
                                    VcsLogManager.access$getLOG$cp().error(t);
                                }
                                ** GOTO lbl8
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                clearStorage = $continuation.Z$1;
                useRawSwingDispatcher = $continuation.Z$0;
                uiDispatcher = (CoroutineContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object dispose$default(VcsLogManager vcsLogManager, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dispose");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return vcsLogManager.dispose(bl, bl2, (Continuation<? super Unit>)continuation);
    }

    private final void refreshLogOnVcsEvents(Disposable disposableParent, Map<VirtualFile, ? extends VcsLogProvider> logProviders, PostponableLogRefresher refresher) {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap providers2roots = multiMap;
        Map<VirtualFile, ? extends VcsLogProvider> $this$forEach$iv = logProviders;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<VirtualFile, ? extends VcsLogProvider> element$iv;
            Map.Entry<VirtualFile, ? extends VcsLogProvider> entry = element$iv = object2.next();
            boolean bl = false;
            VirtualFile key = entry.getKey();
            VcsLogProvider value = entry.getValue();
            providers2roots.putValue((Object)value, (Object)key);
        }
        VcsLogRefresher wrappedRefresher = arg_0 -> VcsLogManager.refreshLogOnVcsEvents$lambda$10(refresher, this, arg_0);
        for (Object object2 : providers2roots.entrySet()) {
            Disposable disposable;
            Intrinsics.checkNotNull((Object)object2);
            VcsLogProvider key = (VcsLogProvider)object2.getKey();
            Collection value = (Collection)object2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key.subscribeToRootRefreshEvents(value, wrappedRefresher), (String)"subscribeToRootRefreshEvents(...)");
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    private static final boolean getMainLogUiFactory$lambda$1(VcsLogManager this$0, CustomVcsLogUiFactoryProvider it) {
        return it.isActive(this$0.dataManager.getLogProviders());
    }

    private static final boolean getMainLogUiFactory$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void createLogUi$lambda$3(VcsLogUiEx $ui, VcsLogManager this$0, String $id) {
        LOG.debug("Removing disposed log ui " + $ui);
        this$0.managedUis.remove($id);
        this$0.uiRegistrationTraces.remove($id);
    }

    private static final void installRefresher$lambda$4(VcsLogUiEx $ui, installRefresher.listener.1 $listener) {
        $ui.getMainComponent().removeHierarchyListener($listener);
    }

    private static final CharSequence getLogUiInformation$lambda$5(VcsLogUiEx ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        String isVisible = VcsLogManagerKt.access$isVisible(ui) ? " (visible)" : "";
        String isDisposed = Disposer.isDisposed((Disposable)ui.getRefresher()) ? " (disposed)" : "";
        return ui + isVisible + isDisposed;
    }

    private static final void dispose$lambda$7(VcsLogManager this$0, Runnable $callback) {
        block0: {
            this$0.disposeData();
            Runnable runnable = $callback;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final void refreshLogOnVcsEvents$lambda$10$lambda$9(PostponableLogRefresher $refresher, VirtualFile $root, VcsLogManager this$0) {
        Intrinsics.checkNotNull((Object)$root);
        $refresher.refresh($root, !Companion.keepUpToDate() && !this$0.isLogVisible());
    }

    private static final void refreshLogOnVcsEvents$lambda$10(PostponableLogRefresher $refresher, VcsLogManager this$0, VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ApplicationManager.getApplication().invokeLater(() -> VcsLogManager.refreshLogOnVcsEvents$lambda$10$lambda$9($refresher, root, this$0), ModalityState.any());
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean keepUpToDate() {
        return Companion.keepUpToDate();
    }

    @JvmStatic
    @NotNull
    public static final Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project) {
        return Companion.findLogProviders(roots, project);
    }

    public static final /* synthetic */ PostponableLogRefresher access$getPostponableRefresher$p(VcsLogManager $this) {
        return $this.postponableRefresher;
    }

    public static final /* synthetic */ void access$disposeData(VcsLogManager $this) {
        $this.disposeData();
    }

    static {
        Logger logger = Logger.getInstance(VcsLogManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J?\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H$\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogManager$BaseVcsLogUiFactory;", "T", "Lcom/intellij/vcs/log/ui/VcsLogUiImpl;", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "logId", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "<init>", "(Ljava/lang/String;Lcom/intellij/vcs/log/VcsLogFilterCollection;Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "createLogUi", "project", "Lcom/intellij/openapi/project/Project;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;)Lcom/intellij/vcs/log/ui/VcsLogUiImpl;", "createVcsLogUiImpl", "properties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresherImpl;", "(Ljava/lang/String;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/ui/VcsLogColorManager;Lcom/intellij/vcs/log/visible/VisiblePackRefresherImpl;Lcom/intellij/vcs/log/VcsLogFilterCollection;)Lcom/intellij/vcs/log/ui/VcsLogUiImpl;", "intellij.platform.vcs.log.impl"})
    @ApiStatus.Internal
    public static abstract class BaseVcsLogUiFactory<T extends VcsLogUiImpl>
    implements VcsLogUiFactory<T> {
        @NotNull
        private final String logId;
        @Nullable
        private final VcsLogFilterCollection filters;
        @NotNull
        private final VcsLogTabsProperties uiProperties;
        @NotNull
        private final VcsLogColorManager colorManager;

        public BaseVcsLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogTabsProperties uiProperties, @NotNull VcsLogColorManager colorManager) {
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            this.logId = logId;
            this.filters = filters;
            this.uiProperties = uiProperties;
            this.colorManager = colorManager;
        }

        @Override
        @NotNull
        public T createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            MainVcsLogUiProperties mainVcsLogUiProperties = this.uiProperties.createProperties(this.logId);
            Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUiProperties, (String)"createProperties(...)");
            MainVcsLogUiProperties properties = mainVcsLogUiProperties;
            VcsLogFiltererImpl vcsLogFilterer = new VcsLogFiltererImpl(logData);
            VcsLogUiProperties.VcsLogUiProperty<PermanentGraph.Options> vcsLogUiProperty = MainVcsLogUiProperties.GRAPH_OPTIONS;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"GRAPH_OPTIONS");
            PermanentGraph.Options initialOptions = properties.get(vcsLogUiProperty);
            VcsLogFilterCollection vcsLogFilterCollection = this.filters;
            if (vcsLogFilterCollection == null) {
                vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[0]);
            }
            VcsLogFilterCollection initialFilters = vcsLogFilterCollection;
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, initialFilters, initialOptions, vcsLogFilterer, this.logId);
            return this.createVcsLogUiImpl(this.logId, logData, properties, this.colorManager, refresher, this.filters);
        }

        @NotNull
        protected abstract T createVcsLogUiImpl(@NotNull String var1, @NotNull VcsLogData var2, @NotNull MainVcsLogUiProperties var3, @NotNull VcsLogColorManager var4, @NotNull VisiblePackRefresherImpl var5, @Nullable VcsLogFilterCollection var6);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J*\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogManager$Companion;", "", "<init>", "()V", "MAIN_LOG_ID", "", "Lorg/jetbrains/annotations/NonNls;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "keepUpToDate", "", "findLogProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "roots", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ApiStatus.Internal
        public final boolean keepUpToDate() {
            return Registry.Companion.is("vcs.log.keep.up.to.date") && !PowerSaveMode.isEnabled();
        }

        @JvmStatic
        @NotNull
        public final Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project) {
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (roots.isEmpty()) {
                return MapsKt.emptyMap();
            }
            Map logProviders = new HashMap();
            List allLogProviders = VcsLogProvider.LOG_PROVIDER_EP.getExtensionList((AreaInstance)project);
            block0: for (VcsRoot root : roots) {
                AbstractVcs vcs = root.getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)root.getPath(), (String)"getPath(...)");
                if (vcs == null) {
                    LOG.debug("Skipping invalid VCS root: " + root);
                    continue;
                }
                for (VcsLogProvider provider : allLogProviders) {
                    VirtualFile path;
                    if (!Intrinsics.areEqual((Object)provider.getSupportedVcs(), (Object)vcs.getKeyInstanceMethod())) continue;
                    logProviders.put(path, provider);
                    continue block0;
                }
            }
            return logProviders;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ:\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory;", "Lcom/intellij/vcs/log/impl/VcsLogManager$BaseVcsLogUiFactory;", "Lcom/intellij/vcs/log/ui/VcsLogUiImpl;", "logId", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "properties", "Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "<init>", "(Ljava/lang/String;Lcom/intellij/vcs/log/VcsLogFilterCollection;Lcom/intellij/vcs/log/impl/VcsLogTabsProperties;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "createVcsLogUiImpl", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresherImpl;", "intellij.platform.vcs.log.impl"})
    private static final class MainVcsLogUiFactory
    extends BaseVcsLogUiFactory<VcsLogUiImpl> {
        public MainVcsLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogTabsProperties properties, @NotNull VcsLogColorManager colorManager) {
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            super(logId, filters, properties, colorManager);
        }

        @Override
        @NotNull
        protected VcsLogUiImpl createVcsLogUiImpl(@NotNull String logId, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePackRefresherImpl refresher, @Nullable VcsLogFilterCollection filters) {
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
            return new VcsLogUiImpl(logId, logData, colorManager, properties, refresher, filters);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\t2\u000b\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogManager$MyErrorHandler;", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "<init>", "(Lcom/intellij/vcs/log/impl/VcsLogManager;)V", "myErrors", "Lit/unimi/dsi/fastutil/ints/IntSet;", "myIsBroken", "Ljava/util/concurrent/atomic/AtomicBoolean;", "handleError", "", "source", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler$Source;", "throwable", "", "displayMessage", "message", "", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.vcs.log.impl"})
    private final class MyErrorHandler
    implements VcsLogErrorHandler {
        @NotNull
        private final IntSet myErrors;
        @NotNull
        private final AtomicBoolean myIsBroken;

        public MyErrorHandler() {
            IntSet intSet = IntSets.synchronize((IntSet)((IntSet)new IntOpenHashSet()));
            Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"synchronize(...)");
            this.myErrors = intSet;
            this.myIsBroken = new AtomicBoolean(false);
        }

        @Override
        public void handleError(@NotNull VcsLogErrorHandler.Source source, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            if (this.myIsBroken.compareAndSet(false, true)) {
                if (VcsLogManager.this.errorHandler != null) {
                    VcsLogManager.this.errorHandler.invoke((Object)source, (Object)throwable);
                } else {
                    LOG.error("Vcs Log exception from " + source, throwable);
                }
                if (source == VcsLogErrorHandler.Source.Storage) {
                    VcsLogIndex vcsLogIndex = VcsLogManager.this.getDataManager().getIndex();
                    Intrinsics.checkNotNull((Object)vcsLogIndex, (String)"null cannot be cast to non-null type com.intellij.vcs.log.data.index.VcsLogModifiableIndex");
                    ((VcsLogModifiableIndex)vcsLogIndex).markCorrupted();
                }
            } else {
                int errorHashCode = ThrowableInterner.computeTraceHashCode((Throwable)throwable);
                if (this.myErrors.add(errorHashCode)) {
                    LOG.debug("Vcs Log storage is broken and is being recreated", throwable);
                }
            }
        }

        @Override
        public void displayMessage(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            VcsNotifier.getInstance((Project)VcsLogManager.this.getProject()).notifyError("vcs.log.fatal.error", "", message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e7\u0080\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u001d\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "T", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "", "createLogUi", "project", "Lcom/intellij/openapi/project/Project;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;)Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "intellij.platform.vcs.log.impl"})
    @ApiStatus.Experimental
    public static interface VcsLogUiFactory<T extends VcsLogUiEx> {
        @NotNull
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2);
    }
}

