/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.Hashes;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Tag(value="rename")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0010\u00a2\u0006\u0004\b\t\u0010\u000bJ \u0010\u001a\u001a\u0012\u0012\u000e\u0012\f0\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001e0\u001b2\u0006\u0010\u0002\u001a\u00020\u0014H\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001b0 2\u0006\u0010\u0002\u001a\u00020\u0014H\u0002J$\u0010\"\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0#0 R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/history/RenameRecord;", "", "root", "", "parentPath", "childPath", "hashes", "", "Lcom/intellij/vcs/log/history/Hashes;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/vcs/log/history/Hashes;)V", "()V", "getRoot", "()Ljava/lang/String;", "getParentPath", "getChildPath", "getHashes", "()[Lcom/intellij/vcs/log/history/Hashes;", "[Lcom/intellij/vcs/log/history/Hashes;", "rootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "getRootFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "rootFile$delegate", "Lkotlin/Lazy;", "getPaths", "Lcom/intellij/vcs/log/history/EdgeData;", "Lcom/intellij/openapi/vcs/FilePath;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getCommits", "", "Lcom/intellij/vcs/log/CommitId;", "getCommitsAndPaths", "Lkotlin/Pair;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDirectoryRenamesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryRenamesProvider.kt\ncom/intellij/vcs/log/history/RenameRecord\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n11546#2,9:84\n13472#2:93\n13473#2:95\n11555#2:96\n1#3:94\n1563#4:97\n1634#4,3:98\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryRenamesProvider.kt\ncom/intellij/vcs/log/history/RenameRecord\n*L\n75#1:84,9\n75#1:93\n75#1:95\n75#1:96\n75#1:94\n80#1:97\n80#1:98,3\n*E\n"})
public final class RenameRecord {
    @Attribute(value="root")
    @NotNull
    private final String root;
    @Attribute(value="parentPath")
    @NotNull
    private final String parentPath;
    @Attribute(value="childPath")
    @NotNull
    private final String childPath;
    @XCollection(propertyElementName="hashesList")
    @NotNull
    private final Hashes[] hashes;
    @NotNull
    private final Lazy rootFile$delegate;

    public RenameRecord(@NotNull String root, @NotNull String parentPath, @NotNull String childPath, @NotNull Hashes[] hashes) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)childPath, (String)"childPath");
        Intrinsics.checkNotNullParameter((Object)hashes, (String)"hashes");
        this.root = root;
        this.parentPath = parentPath;
        this.childPath = childPath;
        this.hashes = hashes;
        this.rootFile$delegate = LazyKt.lazy(() -> RenameRecord.rootFile_delegate$lambda$0(this));
    }

    @NotNull
    public final String getRoot() {
        return this.root;
    }

    @NotNull
    public final String getParentPath() {
        return this.parentPath;
    }

    @NotNull
    public final String getChildPath() {
        return this.childPath;
    }

    @NotNull
    public final Hashes[] getHashes() {
        return this.hashes;
    }

    public RenameRecord() {
        this("", "", "", new Hashes[0]);
    }

    private final VirtualFile getRootFile() {
        Lazy lazy = this.rootFile$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final EdgeData<FilePath> getPaths(VirtualFile root) {
        return new EdgeData<FilePath>(VcsUtil.getFilePath((VirtualFile)root, (String)this.parentPath, (boolean)true), VcsUtil.getFilePath((VirtualFile)root, (String)this.childPath, (boolean)true));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EdgeData<CommitId>> getCommits(VirtualFile root) {
        void $this$mapNotNullTo$iv$iv;
        Hashes[] $this$mapNotNull$iv = this.hashes;
        boolean $i$f$mapNotNull = false;
        Hashes[] hashesArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            EdgeData<CommitId> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it.getCommitIds(root) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<EdgeData<CommitId>, EdgeData<FilePath>>> getCommitsAndPaths() {
        List list;
        VirtualFile virtualFile = this.getRootFile();
        if (virtualFile != null) {
            void $this$mapTo$iv$iv;
            VirtualFile root = virtualFile;
            boolean bl = false;
            EdgeData<FilePath> paths = this.getPaths(root);
            Iterable $this$map$iv = this.getCommits(root);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EdgeData edgeData = (EdgeData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Pair((Object)it, paths));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final VirtualFile rootFile_delegate$lambda$0(RenameRecord this$0) {
        return LocalFileSystem.getInstance().findFileByPath(this$0.root);
    }
}

