/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.CommitFileState;
import com.intellij.vcs.log.history.CommitMetadataWithPath;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0004\"\n\b\u0001\u0010\u0003*\u0004\u0018\u00010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001H\u0002\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"union", "Lcom/intellij/util/containers/MultiMap;", "K", "V", "", "map", "createCommitMetadataWithPath", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevisionEx;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class FileHistoryFiltererKt {
    private static final <K, V> MultiMap<K, V> union(MultiMap<K, V> $this$union, MultiMap<K, V> map) {
        if ($this$union.isEmpty()) {
            return map;
        }
        if (map.isEmpty()) {
            return $this$union;
        }
        MultiMap result = new MultiMap();
        result.putAllValues($this$union);
        result.putAllValues(map);
        return result;
    }

    private static final CommitMetadataWithPath createCommitMetadataWithPath(VcsLogObjectsFactory $this$createCommitMetadataWithPath, VcsLogStorage storage, VcsFileRevisionEx revision, VirtualFile root) {
        Hash hash = $this$createCommitMetadataWithPath.createHash(revision.getRevisionNumber().asString());
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"createHash(...)");
        Hash commitHash = hash;
        List list = CollectionsKt.emptyList();
        long l = revision.getRevisionDate().getTime();
        String string = revision.getCommitMessage();
        Intrinsics.checkNotNull((Object)string);
        String string2 = CommitPresentationUtil.getSubject(string);
        String string3 = revision.getAuthor();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = revision.getAuthorEmail();
        Intrinsics.checkNotNull((Object)string4);
        String string5 = revision.getCommitMessage();
        Intrinsics.checkNotNull((Object)string5);
        String string6 = revision.getCommitterName();
        Intrinsics.checkNotNull((Object)string6);
        String string7 = revision.getCommitterEmail();
        Intrinsics.checkNotNull((Object)string7);
        Date date = revision.getAuthorDate();
        Intrinsics.checkNotNull((Object)date);
        VcsCommitMetadata vcsCommitMetadata = $this$createCommitMetadataWithPath.createCommitMetadata(commitHash, list, l, root, string2, string3, string4, string5, string6, string7, date.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"createCommitMetadata(...)");
        VcsCommitMetadata metadata = vcsCommitMetadata;
        int n = storage.getCommitIndex(commitHash, root);
        FilePath filePath = revision.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getPath(...)");
        return new CommitMetadataWithPath(n, metadata, new CommitFileState(filePath, revision.isDeleted()));
    }

    public static final /* synthetic */ MultiMap access$union(MultiMap $receiver, MultiMap map) {
        return FileHistoryFiltererKt.union($receiver, map);
    }

    public static final /* synthetic */ CommitMetadataWithPath access$createCommitMetadataWithPath(VcsLogObjectsFactory $receiver, VcsLogStorage storage, VcsFileRevisionEx revision, VirtualFile root) {
        return FileHistoryFiltererKt.createCommitMetadataWithPath($receiver, storage, revision, root);
    }
}

