/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00102\n\u0010\u0019\u001a\u00060\u0015j\u0002`\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00042\n\u0010\u0019\u001a\u00060\u0015j\u0002`\u0016J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\n\u0010\u001d\u001a\u00060\u0015j\u0002`\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0017\u001a\u00020\u00042\n\u0010\u001d\u001a\u00060\u0015j\u0002`\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0017R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/vcs/log/data/RefsModel;", "Lcom/intellij/vcs/log/VcsLogRefs;", "allRefsByRoot", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "<init>", "(Ljava/util/Map;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;)V", "getAllRefsByRoot", "()Ljava/util/Map;", "bestRefForHead", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/VcsRef;", "rootForHead", "updateCacheForHead", "", "head", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "root", "bestRefToHead", "headIndex", "rootAtHead", "refsToCommit", "", "index", "getBranches", "", "stream", "Ljava/util/stream/Stream;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nRefsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefsModel.kt\ncom/intellij/vcs/log/data/RefsModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n61#2,5:92\n295#3,2:97\n*S KotlinDebug\n*F\n+ 1 RefsModel.kt\ncom/intellij/vcs/log/data/RefsModel\n*L\n33#1:92,5\n43#1:97,2\n*E\n"})
public final class RefsModel
implements VcsLogRefs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<VirtualFile, CompressedRefs> allRefsByRoot;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> providers;
    @NotNull
    private final Int2ObjectMap<VcsRef> bestRefForHead;
    @NotNull
    private final Int2ObjectMap<VirtualFile> rootForHead;
    @NotNull
    private static final Logger LOG;

    public RefsModel(@NotNull Map<VirtualFile, CompressedRefs> allRefsByRoot, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers) {
        Intrinsics.checkNotNullParameter(allRefsByRoot, (String)"allRefsByRoot");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.allRefsByRoot = allRefsByRoot;
        this.storage = storage;
        this.providers = providers;
        this.bestRefForHead = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.rootForHead = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    }

    @NotNull
    public final Map<VirtualFile, CompressedRefs> getAllRefsByRoot() {
        return this.allRefsByRoot;
    }

    private final void updateCacheForHead(int head, VirtualFile root) {
        this.rootForHead.put(head, (Object)root);
        Iterable iterable = this.refsToCommit(root, head);
        VcsLogProvider vcsLogProvider = this.providers.get(root);
        Intrinsics.checkNotNull((Object)vcsLogProvider);
        Comparator comparator = vcsLogProvider.getReferenceManager().getBranchLayoutComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getBranchLayoutComparator(...)");
        VcsRef bestRef = (VcsRef)CollectionsKt.minWithOrNull((Iterable)iterable, (Comparator)comparator);
        if (bestRef != null) {
            this.bestRefForHead.put(head, (Object)bestRef);
        } else {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("No references at head " + this.storage.getCommitId(head), e$iv);
            }
        }
    }

    @Nullable
    public final VcsRef bestRefToHead(int headIndex) {
        return (VcsRef)this.bestRefForHead.get(headIndex);
    }

    @Nullable
    public final VirtualFile rootAtHead(int headIndex) {
        return (VirtualFile)this.rootForHead.get(headIndex);
    }

    @NotNull
    public final List<VcsRef> refsToCommit(int index) {
        if (this.allRefsByRoot.size() <= 10) {
            SmartList<VcsRef> refs;
            SmartList<VcsRef> smartList;
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = this.allRefsByRoot.values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CompressedRefs it = (CompressedRefs)element$iv;
                    boolean bl = false;
                    if (!it.contains(index)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            return (smartList = (refs = (SmartList<VcsRef>)v0)) != null && (smartList = smartList.refsToCommit(index)) != null ? (List)smartList : CollectionsKt.emptyList();
        }
        CommitId commitId = this.storage.getCommitId(index);
        if (commitId == null) {
            return CollectionsKt.emptyList();
        }
        CommitId id = commitId;
        VirtualFile virtualFile = id.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return this.refsToCommit(virtualFile, index);
    }

    @NotNull
    public final List<VcsRef> refsToCommit(@NotNull VirtualFile root, int index) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        SmartList<VcsRef> smartList = this.allRefsByRoot.get(root);
        return smartList != null && (smartList = smartList.refsToCommit(index)) != null ? (List)smartList : CollectionsKt.emptyList();
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        List list = this.allRefsByRoot.values().stream().flatMap(arg_0 -> RefsModel.getBranches$lambda$2(getBranches.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    @RequiresBackgroundThread
    @NotNull
    public Stream<VcsRef> stream() {
        Stream<VcsRef> stream2 = this.allRefsByRoot.values().stream().flatMap(arg_0 -> RefsModel.stream$lambda$3(stream.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"flatMap(...)");
        return stream2;
    }

    private static final Stream getBranches$lambda$2(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream stream$lambda$3(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final RefsModel createEmptyInstance(@NotNull VcsLogStorage storage) {
        return Companion.createEmptyInstance(storage);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final RefsModel create(@NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Set<Integer> heads, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers) {
        return Companion.create(refs, heads, storage, providers);
    }

    static {
        Logger logger = Logger.getInstance(RefsModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007JJ\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u00112\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\rH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/data/RefsModel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createEmptyInstance", "Lcom/intellij/vcs/log/data/RefsModel;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "create", "refs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "heads", "", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nRefsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefsModel.kt\ncom/intellij/vcs/log/data/RefsModel$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,91:1\n216#2,2:92\n216#2,2:94\n*S KotlinDebug\n*F\n+ 1 RefsModel.kt\ncom/intellij/vcs/log/data/RefsModel$Companion\n*L\n79#1:92,2\n85#1:94,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final RefsModel createEmptyInstance(@NotNull VcsLogStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return this.create(MapsKt.emptyMap(), SetsKt.emptySet(), storage, MapsKt.emptyMap());
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final RefsModel create(@NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Set<Integer> heads, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers) {
            Map.Entry<VirtualFile, CompressedRefs> entry;
            Map.Entry<Object, CompressedRefs> element$iv;
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            Intrinsics.checkNotNullParameter(heads, (String)"heads");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            RefsModel refsModel = new RefsModel(refs, storage, providers);
            IntOpenHashSet remainingHeads = new IntOpenHashSet((Collection)heads);
            Map<Object, CompressedRefs> $this$forEach$iv = refs;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Object, CompressedRefs>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                VirtualFile root = entry.getKey();
                CompressedRefs refsForRoot = entry.getValue();
                ((IntSet)refsForRoot.getBranches().keySet()).forEach(arg_0 -> Companion.create$lambda$1$lambda$0(refsModel, root, remainingHeads, arg_0));
            }
            $this$forEach$iv = storage.getCommitIds((Collection)remainingHeads);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                int head = ((Number)entry.getKey()).intValue();
                CommitId commitId = (CommitId)entry.getValue();
                VirtualFile virtualFile = commitId.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                refsModel.updateCacheForHead(head, virtualFile);
            }
            return refsModel;
        }

        private static final void create$lambda$1$lambda$0(RefsModel $refsModel, VirtualFile $root, IntOpenHashSet $remainingHeads, int commit) {
            $refsModel.updateCacheForHead(commit, $root);
            $remainingHeads.remove(commit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

