/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.modeling.ngram;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.ArrayTrieCounter;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/JMModel;", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "order", "", "lambda", "", "counter", "Lcom/intellij/completion/ngram/slp/counting/Counter;", "(IDLcom/intellij/completion/ngram/slp/counting/Counter;)V", "config", "Lcom/intellij/completion/ngram/slp/modeling/ngram/JMModel$JMMConfig;", "getConfig", "()Lcom/intellij/completion/ngram/slp/modeling/ngram/JMModel$JMMConfig;", "modelWithConfidence", "Lkotlin/Pair;", "in", "", "counts", "", "Companion", "JMMConfig", "bd0177eacd27ae4e"})
public final class JMModel
extends NGramModel {
    @NotNull
    private final JMMConfig config;
    private final double lambda;
    private static final double DEFAULT_LAMBDA = 0.5;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Pair<Double, Double> modelWithConfidence(@NotNull List<Integer> in, @NotNull long[] counts) {
        Intrinsics.checkParameterIsNotNull(in, (String)"in");
        Intrinsics.checkParameterIsNotNull((Object)counts, (String)"counts");
        long count = counts[0];
        long contextCount = counts[1];
        double MLE = (double)count / (double)contextCount;
        return new Pair((Object)MLE, (Object)this.lambda);
    }

    @Override
    @NotNull
    protected JMMConfig getConfig() {
        return this.config;
    }

    public JMModel(int order, double lambda, @NotNull Counter counter) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        super(order, counter);
        this.lambda = lambda;
        String string = this.getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this::class.java.toString()");
        this.config = new JMMConfig(order, string, this.lambda);
    }

    public /* synthetic */ JMModel(int n, double d, Counter counter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            d = DEFAULT_LAMBDA;
        }
        if ((n2 & 4) != 0) {
            counter = new ArrayTrieCounter();
        }
        this(n, d, counter);
    }

    public JMModel() {
        this(0, 0.0, null, 7, null);
    }

    static {
        DEFAULT_LAMBDA = 0.5;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/JMModel$JMMConfig;", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "order", "", "name", "", "lambda", "", "(ILjava/lang/String;D)V", "getLambda", "()D", "bd0177eacd27ae4e"})
    public static final class JMMConfig
    extends NGramModel.Config {
        private final double lambda;

        public final double getLambda() {
            return this.lambda;
        }

        public JMMConfig(int order, @NotNull String name, double lambda) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            super(order, name);
            this.lambda = lambda;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/JMModel$Companion;", "", "()V", "DEFAULT_LAMBDA", "", "bd0177eacd27ae4e"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

