/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommitCommand
extends HgCommitTypeCommand {
    private final boolean myCloseBranch;
    private final boolean myShouldCommitWithSubrepos;
    @NotNull
    private List<String> mySubrepos;

    public HgCommitCommand(@NotNull Project project, @NotNull HgRepository repository, @NotNull String message, boolean amend, boolean closeBranch, boolean shouldCommitWithSubrepos) {
        if (project == null) {
            HgCommitCommand.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            HgCommitCommand.$$$reportNull$$$0(1);
        }
        if (message == null) {
            HgCommitCommand.$$$reportNull$$$0(2);
        }
        super(project, repository, message, amend);
        this.mySubrepos = Collections.emptyList();
        this.myCloseBranch = closeBranch;
        this.myShouldCommitWithSubrepos = shouldCommitWithSubrepos;
    }

    public HgCommitCommand(@NotNull Project project, @NotNull HgRepository repo, @NotNull String message, boolean amend) {
        if (project == null) {
            HgCommitCommand.$$$reportNull$$$0(3);
        }
        if (repo == null) {
            HgCommitCommand.$$$reportNull$$$0(4);
        }
        if (message == null) {
            HgCommitCommand.$$$reportNull$$$0(5);
        }
        this(project, repo, message, amend, false, false);
    }

    public HgCommitCommand(Project project, @NotNull HgRepository repo, @NotNull String message) {
        if (repo == null) {
            HgCommitCommand.$$$reportNull$$$0(6);
        }
        if (message == null) {
            HgCommitCommand.$$$reportNull$$$0(7);
        }
        this(project, repo, message, false);
    }

    @Override
    protected void executeChunked(@NotNull List<List<String>> chunkedCommits) throws VcsException {
        if (chunkedCommits == null) {
            HgCommitCommand.$$$reportNull$$$0(8);
        }
        if (chunkedCommits.isEmpty()) {
            this.commitChunkFiles(ContainerUtil.emptyList(), this.myAmend, this.myCloseBranch);
        } else {
            int size = chunkedCommits.size();
            if (this.myShouldCommitWithSubrepos && this.myRepository.hasSubrepos()) {
                this.mySubrepos = HgUtil.getNamesWithoutHashes(this.myRepository.getSubrepos());
            }
            this.commitChunkFiles(chunkedCommits.get(0), this.myAmend, !this.mySubrepos.isEmpty(), this.myCloseBranch && size == 1);
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            boolean amendCommit = vcs != null && vcs.getVersion().isAmendSupported();
            for (int i = 1; i < size; ++i) {
                List<String> chunk = chunkedCommits.get(i);
                this.commitChunkFiles(chunk, amendCommit, false, this.myCloseBranch && i == size - 1);
            }
        }
    }

    private void commitChunkFiles(@NotNull List<String> chunk, boolean amendCommit, boolean closeBranch) throws VcsException {
        if (chunk == null) {
            HgCommitCommand.$$$reportNull$$$0(9);
        }
        this.commitChunkFiles(chunk, amendCommit, false, closeBranch);
    }

    private void commitChunkFiles(@NotNull List<String> chunk, boolean amendCommit, boolean withSubrepos, boolean closeBranch) throws VcsException {
        if (chunk == null) {
            HgCommitCommand.$$$reportNull$$$0(10);
        }
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("--logfile");
        parameters.add(this.saveCommitMessage().getAbsolutePath());
        if (withSubrepos) {
            parameters.add("-S");
            parameters.addAll(this.mySubrepos);
        } else if (amendCommit) {
            parameters.add("--amend");
        }
        if (closeBranch) {
            if (chunk.isEmpty() && this.myRepository.getState() != Repository.State.MERGING) {
                parameters.add("-X");
                parameters.add("\"**\"");
            }
            parameters.add("--close-branch");
        }
        parameters.addAll(chunk);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        HgErrorUtil.ensureSuccess(executor.executeInCurrentThread(this.myRepository.getRoot(), "commit", parameters));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkedCommits";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/HgCommitCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeChunked";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "commitChunkFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

