/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.base;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.AbstractToolbarCombo;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.actions.ActionsKt;
import com.jetbrains.rd.ide.model.NameValue;
import com.jetbrains.rd.ide.model.PresentationModel;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.BackendCustomComponentActionKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/actions/base/BackendCustomComponentAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/Disposable;", "actionId", "", "<init>", "(Ljava/lang/String;)V", "getActionId", "()Ljava/lang/String;", "actionLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "dispose", "", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "updateCustomComponent", "panel", "requestBackendComponent", "", "Lcom/jetbrains/rdclient/actions/base/BackendCustomComponentAction$MyPanel;", "getProjectFromHierarchy", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Container;", "MyPanel", "Companion", "intellij.rd.client"})
public final class BackendCustomComponentAction
implements CustomComponentAction,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String actionId;
    @NotNull
    private final LifetimeDefinition actionLifetimeDefinition;

    public BackendCustomComponentAction(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        this.actionId = actionId;
        this.actionLifetimeDefinition = new LifetimeDefinition();
    }

    @NotNull
    public final String getActionId() {
        return this.actionId;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.actionLifetimeDefinition, (boolean)false, (int)1, null);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        MyPanel panel = new MyPanel(place);
        panel.addHierarchyListener(new HierarchyListener(this, panel){
            final /* synthetic */ BackendCustomComponentAction this$0;
            final /* synthetic */ MyPanel $panel;
            {
                this.this$0 = $receiver;
                this.$panel = $panel;
            }

            public void hierarchyChanged(HierarchyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (BackendCustomComponentAction.access$requestBackendComponent(this.this$0, this.this$0.getActionId(), this.$panel, null)) {
                    this.$panel.removeHierarchyListener(this);
                }
            }
        });
        return (JComponent)((Object)panel);
    }

    public void updateCustomComponent(@NotNull JComponent panel, @NotNull Presentation presentation) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (!(panel instanceof MyPanel)) {
            return;
        }
        Component[] componentArray = ((MyPanel)((Object)panel)).getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Component component2 = component = (Component)ArraysKt.singleOrNull((Object[])componentArray);
        if (component2 instanceof AbstractToolbarCombo) {
            ((AbstractToolbarCombo)component).updateFromPresentation(presentation);
        } else if (component2 == null) {
            this.requestBackendComponent(this.actionId, (MyPanel)((Object)panel), presentation);
        }
    }

    private final boolean requestBackendComponent(String actionId, MyPanel panel, Presentation presentation) {
        block4: {
            Project project;
            if (presentation != null) {
                ClientProperty.put((JComponent)((JComponent)((Object)panel)), (Key)BackendCustomComponentActionKt.access$getREQUESTED_FOR_PRESENTATION$p(), (Object)presentation);
            }
            if (Intrinsics.areEqual((Object)ClientProperty.get((Component)((Component)((Object)panel)), (Key)BackendCustomComponentActionKt.access$getCOMPONENT_REQUESTED$p()), (Object)true)) {
                return true;
            }
            Project project2 = project = this.getProjectFromHierarchy((Container)((Object)panel));
            if (!(project2 != null ? !project2.isDisposed() : false)) {
                return false;
            }
            Presentation presentation2 = presentation;
            if (presentation2 == null) {
                presentation2 = (Presentation)ClientProperty.get((Component)((Component)((Object)panel)), (Key)BackendCustomComponentActionKt.access$getREQUESTED_FOR_PRESENTATION$p());
            }
            Presentation presentation3 = presentation2;
            ClientProperty.put((JComponent)((JComponent)((Object)panel)), (Key)BackendCustomComponentActionKt.access$getCOMPONENT_REQUESTED$p(), (Object)true);
            Lifetime actionLifetime = this.actionLifetimeDefinition.getLifetime();
            Presentation presentation4 = presentation3;
            Intrinsics.checkNotNull((Object)presentation4);
            Promise<JComponent> promise = BackendActionDelegationKt.backendGetCustomComponentAsync(actionId, presentation4, panel.getPlace(), project, actionLifetime);
            if (promise == null) break block4;
            promise.onSuccess(arg_0 -> BackendCustomComponentAction.requestBackendComponent$lambda$1(arg_0 -> BackendCustomComponentAction.requestBackendComponent$lambda$0(actionLifetime, panel, this, arg_0), arg_0));
        }
        return true;
    }

    private final Project getProjectFromHierarchy(Container parent) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)parent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context = dataContext;
        return DataContextKt.getProject((DataContext)context);
    }

    private static final Unit requestBackendComponent$lambda$0(Lifetime $actionLifetime, MyPanel $panel, BackendCustomComponentAction this$0, JComponent component) {
        if (RLifetimeKt.isAlive((Lifetime)$actionLifetime) && component != null) {
            $actionLifetime.onTermination((Function0)new Function0<Unit>((Object)$panel){

                public final void invoke() {
                    ((MyPanel)((Object)this.receiver)).removeAll();
                }
            });
            component.setOpaque(false);
            $panel.addToCenter(component);
            Presentation presentation = (Presentation)ClientProperty.get((Component)((Component)((Object)$panel)), (Key)BackendCustomComponentActionKt.access$getREQUESTED_FOR_PRESENTATION$p());
            JComponent jComponent = (JComponent)((Object)$panel);
            Presentation presentation2 = presentation;
            Intrinsics.checkNotNull((Object)presentation2);
            this$0.updateCustomComponent(jComponent, presentation2);
            ClientProperty.put((JComponent)((JComponent)((Object)$panel)), (Key)BackendCustomComponentActionKt.access$getREQUESTED_FOR_PRESENTATION$p(), null);
        }
        return Unit.INSTANCE;
    }

    private static final void requestBackendComponent$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$requestBackendComponent(BackendCustomComponentAction $this, String actionId, MyPanel panel, Presentation presentation) {
        return $this.requestBackendComponent(actionId, panel, presentation);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/actions/base/BackendCustomComponentAction$Companion;", "", "<init>", "()V", "initIfNeeded", "", "backendId", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "model", "Lcom/jetbrains/rd/ide/model/PresentationModel;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nBackendCustomComponentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendCustomComponentAction.kt\ncom/jetbrains/rdclient/actions/base/BackendCustomComponentAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1761#2,3:98\n*S KotlinDebug\n*F\n+ 1 BackendCustomComponentAction.kt\ncom/jetbrains/rdclient/actions/base/BackendCustomComponentAction$Companion\n*L\n90#1:98,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void initIfNeeded(@NotNull String backendId, @NotNull Presentation presentation, @NotNull PresentationModel model2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)backendId, (String)"backendId");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            List list2 = model2.getClientProperties();
            if (list2 != null) {
                boolean bl2;
                block6: {
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            NameValue it = (NameValue)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)ActionsKt.getIS_CUSTOM_COMPONENT_ACTION().toString())) continue;
                            bl2 = true;
                            break block6;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = false;
            }
            if (bl && presentation.getClientProperty(ActionUtil.COMPONENT_PROVIDER) == null) {
                presentation.putClientProperty(ActionUtil.COMPONENT_PROVIDER, (Object)new BackendCustomComponentAction(backendId));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/actions/base/BackendCustomComponentAction$MyPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "place", "", "<init>", "(Ljava/lang/String;)V", "getPlace", "()Ljava/lang/String;", "intellij.rd.client"})
    private static final class MyPanel
    extends BorderLayoutPanel {
        @NotNull
        private final String place;

        public MyPanel(@NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            this.place = place;
            this.setOpaque(false);
        }

        @NotNull
        public final String getPlace() {
            return this.place;
        }
    }
}

