/*========================== begin_copyright_notice ============================

Copyright (C) 2020-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

#include "../imf.h"
#pragma OPENCL FP_CONTRACT OFF
typedef struct
{
    unsigned long TC_tbl[16];
    unsigned long Sgn_tbl[16];
    unsigned long _dAbsMask;
    unsigned long _dRShifter;
    unsigned long _lZero;
    unsigned long _dC1;
    unsigned long _dC2;
    unsigned long _dC3;
    unsigned long _dC4;
    unsigned long _dC5;
    unsigned long _dC6;
    unsigned long _dOne;
    unsigned long _dInf;
    unsigned long _dHShifter;
} __internal_dtanpi_la_data_avx512_t;
static __constant __internal_dtanpi_la_data_avx512_t __internal_dtanpi_la_data_avx512 = {
    {

     0x0000000000000000uL, 0x3fc975f5e0553158uL, 0x3fda827999fcef32uL, 0x3fe561b82ab7f990uL,
     0xbff0000000000000uL, 0xbfe561b82ab7f990uL, 0xbfda827999fcef32uL, 0xbfc975f5e0553158uL,
     0x8000000000000000uL, 0x3fc975f5e0553158uL, 0x3fda827999fcef32uL, 0x3fe561b82ab7f990uL,
     0xbff0000000000000uL, 0xbfe561b82ab7f990uL, 0xbfda827999fcef32uL, 0xbfc975f5e0553158uL,
     },
    {

     0x0000000000000000uL, 0x0000000000000000uL, 0x0000000000000000uL, 0x0000000000000000uL,
     0x8000000000000000uL, 0x8000000000000000uL, 0x8000000000000000uL, 0x8000000000000000uL,
     0x8000000000000000uL, 0x8000000000000000uL, 0x8000000000000000uL, 0x8000000000000000uL,
     0x0000000000000000uL, 0x0000000000000000uL, 0x0000000000000000uL, 0x0000000000000000uL,
     },
    0x7FFFFFFFFFFFFFFFuL,
    0x42f8000000000000uL,
    0x0000000000000000uL,
    0x400921fb54442d18uL,
    0x4024abbce625bf0cuL,
    0x404466bc676d354buL,
    0x40645fffbf5870d4uL,
    0x40845f01bac0427auL,
    0x40a49cc66021fbbcuL,
    0x3ff0000000000000uL,
    0x7ff0000000000000uL,
    0x4330000000000000uL,
};

typedef struct
{
    unsigned long _dCoeffs[256][13];
    unsigned long _dAbsMask;
    unsigned long _dReductionRangeVal;
    unsigned long _dRangeVal;
    unsigned long _dPIu;
    unsigned long _dRShifter;
    unsigned long _lIndexMask;
    unsigned long _dPIoHi;
    unsigned long _dPIoLo;
    unsigned long _dPIoTail;

    unsigned long _dRShift_new;
    unsigned long _dReductionRangeVal_new;
    unsigned long _dPI1;

    unsigned long _dP3;
    unsigned long _dP2;
    unsigned long _dP1;

    unsigned long _dQ4;
    unsigned long _dQ3;
    unsigned long _dQ2;
    unsigned long _dQ1;
    unsigned long _dQ0;
} __internal_dtanpi_la_data_t;
static __constant __internal_dtanpi_la_data_t __internal_dtanpi_la_data = {
    {

     {
      0x3FF921FB54442D18uL,
      0x3C91A62633145C07uL,
      0x0000000000000000uL,
      0x0000000000000000uL,
      0x0000000000000000uL,
      0x3FF0000000000000uL,
      0x0000000000000000uL,
      0x0000000000000000uL,
      0x3FD5555555555559uL,
      0x0000000000000000uL,
      0x3FC1111110FE825DuL,
      0x0000000000000000uL,
      0x3FABA1EEC0271523uL,
      },

     {
      0x3FF8EFB75D9BA4BEuL,
      0x3C760B679AB8CD3BuL,
      0x0000000000000000uL,
      0x3F89224E047E368EuL,
      0xBC1A268EB2C67108uL,
      0x3FF0000000000000uL,
      0x3F23BDBEAD8CF800uL,
      0x3F8923461AE96D62uL,
      0x3FD5589FB822D5EEuL,
      0x3F80C326DCDCFCD0uL,
      0x3FC116A999125B7FuL,
      0x3F7300CC26596ADAuL,
      0x3FAB7B6F1DE289A8uL,
      },

     {
      0x3FF8BD7366F31C64uL,
      0xBC7A81C996DFD5A5uL,
      0x0000000000000000uL,
      0x3F992346247A91F0uL,
      0xBBF126D920C15240uL,
      0x3FF0000000000000uL,
      0x3F43BF447B091000uL,
      0x3F992726F0F98D7FuL,
      0x3FD5628108EFA55CuL,
      0x3F90C8A60639C114uL,
      0x3FC127789EC0BD38uL,
      0x3F830BA6F46C58B7uL,
      0x3FABBEE2C1E62B81uL,
      },

     {
      0x3FF88B2F704A940AuL,
      0xBC92C3BEB21E1E21uL,
      0x0000000000000000uL,
      0x3FA2DBAAE9A05DB0uL,
      0xBC4371F88E84877CuL,
      0x3FF0000000000000uL,
      0x3F563A086B860B00uL,
      0x3FA2E23785EEB488uL,
      0x3FD572FFC353B741uL,
      0x3F993ABD2276BF6AuL,
      0x3FC1439260886581uL,
      0x3F8CAC359DCF5E16uL,
      0x3FAB56F9A068D4C5uL,
      },

     {
      0x3FF858EB79A20BB0uL,
      0xBC9EE70AFE8446D9uL,
      0x0000000000000000uL,
      0x3FA927278A3B1162uL,
      0x3BFB01BD7A51D5C0uL,
      0x3FF0000000000000uL,
      0x3F63C55DB08E1680uL,
      0x3FA936B1EC652161uL,
      0x3FD58A26BD6CCCCDuL,
      0x3FA0DEB5445B4098uL,
      0x3FC16B146127E154uL,
      0x3F9336A98365D094uL,
      0x3FAC19302EB1C4A9uL,
      },

     {
      0x3FF826A782F98355uL,
      0x3C94F5A8B515906FuL,
      0x0000000000000000uL,
      0x3FAF7495EA3F3783uL,
      0xBC407F10D50F4C0AuL,
      0x3FF0000000000000uL,
      0x3F6EEB8B377B1A00uL,
      0x3FAF92FABFD0B7B3uL,
      0x3FD5A805341437FFuL,
      0x3FA52B295E2DCF92uL,
      0x3FC19E2C59B8C033uL,
      0x3F982CF88466EFECuL,
      0x3FAD27509D6C3FEAuL,
      },

     {
      0x3FF7F4638C50FAFBuL,
      0x3C81A4B8D15ECF6DuL,
      0x0000000000000000uL,
      0x3FB2E239CCFF3831uL,
      0x3C5879ED3FF4EEAEuL,
      0x3FF0000000000000uL,
      0x3F764980AEEE3740uL,
      0x3FB2FC879C81123CuL,
      0x3FD5CCAEDC1DC96EuL,
      0x3FA98599B71D86B1uL,
      0x3FC1DD150D55E5CEuL,
      0x3F9D3EB9450DBD01uL,
      0x3FADD6CFBE9AA234uL,
      },

     {
      0x3FF7C21F95A872A1uL,
      0xBC6A877F1DB6080CuL,
      0x0000000000000000uL,
      0x3FB60B9F7597FDECuL,
      0x3C3D1E3FBF3B4E18uL,
      0x3FF0000000000000uL,
      0x3F7E5FFEF4D8DFC0uL,
      0x3FB6357984E124B6uL,
      0x3FD5F83BF8B56900uL,
      0x3FADF0F50CAA06C2uL,
      0x3FC2281476904258uL,
      0x3FA138F0F640FD68uL,
      0x3FAF8D1BCDD8D11FuL,
      },

     {
      0x3FF78FDB9EFFEA47uL,
      0xBC8EE8786039D373uL,
      0x0000000000000000uL,
      0x3FB936BB8C5B2DA2uL,
      0x3C587D23392C2BA2uL,
      0x3FF0000000000000uL,
      0x3F83DDE2A8935DE0uL,
      0x3FB97558DC230BA8uL,
      0x3FD62AC976FBC1B8uL,
      0x3FB1381EB60159F6uL,
      0x3FC27F84438D5029uL,
      0x3FA3E63B3A462E45uL,
      0x3FAF0AE614B2D473uL,
      },

     {
      0x3FF75D97A85761EDuL,
      0xBC9B97887C831272uL,
      0x0000000000000000uL,
      0x3FBC63CE377FC802uL,
      0xBC543F7D42DBAC49uL,
      0x3FF0000000000000uL,
      0x3F892FE02A47EFA0uL,
      0x3FBCBD3001C956C5uL,
      0x3FD664790F293C47uL,
      0x3FB38345DE7C4B0BuL,
      0x3FC2E3C4C02FFDFBuL,
      0x3FA6AA7F0C13520BuL,
      0x3FAFE3C754A9F092uL,
      },

     {
      0x3FF72B53B1AED992uL,
      0x3C98452B3716C4D6uL,
      0x0000000000000000uL,
      0x3FBF93183A8DB9E9uL,
      0xBC4124AC452772E2uL,
      0x3FF0000000000000uL,
      0x3F8F27A3181EE680uL,
      0x3FC00707549D7ECCuL,
      0x3FD6A5716B500730uL,
      0x3FB5DB89BB6B245FuL,
      0x3FC3554867F59648uL,
      0x3FA98919BF6D176AuL,
      0x3FB1AF9A1823147BuL,
      },

     {
      0x3FF6F90FBB065138uL,
      0x3C8843BDD561383DuL,
      0x0000000000000000uL,
      0x3FC1626D85A91E70uL,
      0xBC50084844291CB4uL,
      0x3FF0000000000000uL,
      0x3F92E3863C9A69E0uL,
      0x3FC1B4854BB2B147uL,
      0x3FD6EDDE5416DFFBuL,
      0x3FB8429341CCA17AuL,
      0x3FC3D49AC2C9F46FuL,
      0x3FAC85843914CF90uL,
      0x3FB1B1DC3FA33DDDuL,
      },

     {
      0x3FF6C6CBC45DC8DEuL,
      0xBBD6D61B58C99C43uL,
      0x0000000000000000uL,
      0x3FC2FCAC73A60640uL,
      0x3C52CF95F70B55BAuL,
      0x3FF0000000000000uL,
      0x3F96881A43B33590uL,
      0x3FC367A033B52F5EuL,
      0x3FD73DF0E3CC557AuL,
      0x3FBABA1CAC4F18CDuL,
      0x3FC4624C36BE941BuL,
      0x3FAFA38B2F8876EFuL,
      0x3FB215B1F404D921uL,
      },

     {
      0x3FF69487CDB54084uL,
      0xBC8849735C376AA4uL,
      0x0000000000000000uL,
      0x3FC4986A74CF4E57uL,
      0x3C69AB0A24392F72uL,
      0x3FF0000000000000uL,
      0x3F9A82B60D75F5C0uL,
      0x3FC520EA2BA6A0AEuL,
      0x3FD795DFBFFEE39EuL,
      0x3FBD43F3A7862CC7uL,
      0x3FC4FF04247D700AuL,
      0x3FB1739726786F4FuL,
      0x3FB2FAC67533455BuL,
      },

     {
      0x3FF66243D70CB82AuL,
      0xBC984805FA81DE0AuL,
      0x0000000000000000uL,
      0x3FC635C990CE0D36uL,
      0xBC59DFC0C48C1978uL,
      0x3FF0000000000000uL,
      0x3F9ED49F1F8144C0uL,
      0x3FC6E0F98ED00C32uL,
      0x3FD7F5E75A2DD66EuL,
      0x3FBFE1FBA10F6B0EuL,
      0x3FC5AB7CD1905EB8uL,
      0x3FB32A57A4FAE3F9uL,
      0x3FB4BA60BA656817uL,
      },

     {
      0x3FF62FFFE0642FCFuL,
      0x3C9B94ADB917F93EuL,
      0x0000000000000000uL,
      0x3FC7D4EC54FB5968uL,
      0x3C4FB65648F8ABF4uL,
      0x3FF0000000000000uL,
      0x3FA1BF9C7C60B940uL,
      0x3FC8A86964A1796BuL,
      0x3FD85E4A37F23352uL,
      0x3FC14B181F5BF6AEuL,
      0x3FC66888E3A5D3B3uL,
      0x3FB4F84D7AC0F5DAuL,
      0x3FB62BA6F082700CuL,
      },

     {
      0x3FF5FDBBE9BBA775uL,
      0x3C8EE2C2D963A10CuL,
      0x0000000000000000uL,
      0x3FC975F5E0553158uL,
      0x3C2EEEA31ABB0A10uL,
      0x3FF0000000000000uL,
      0x3FA4420303DEC550uL,
      0x3FCA77D9D62CA610uL,
      0x3FD8CF5143323608uL,
      0x3FC2B15401455507uL,
      0x3FC7370FF0965570uL,
      0x3FB6DFEACA56EACBuL,
      0x3FB6B75DF89DE1ECuL,
      },

     {
      0x3FF5CB77F3131F1BuL,
      0x3C6A70A9025D3E70uL,
      0x0000000000000000uL,
      0x3FCB1909EFD8B762uL,
      0x3C5843049E1321E0uL,
      0x3FF0000000000000uL,
      0x3FA6F2545C478E00uL,
      0x3FCC4FF0A9D74F70uL,
      0x3FD9494C22EF2A54uL,
      0x3FC424CB909A6722uL,
      0x3FC8180A481D5934uL,
      0x3FB8E3D90C36FA83uL,
      0x3FB8D27EAFF0DF70uL,
      },

     {
      0x3FF59933FC6A96C1uL,
      0xBC81AA6E583501D4uL,
      0x0000000000000000uL,
      0x3FCCBE4CEB4B4CF2uL,
      0x3C64A514F790E428uL,
      0x3FF0000000000000uL,
      0x3FA9D1724DE6C940uL,
      0x3FCE3159C5ED3A4EuL,
      0x3FD9CC919D4271B2uL,
      0x3FC5A6A9489AA7F4uL,
      0x3FC90C961E2B49F6uL,
      0x3FBB06EE7CFA3693uL,
      0x3FB9E9447AB1D521uL,
      },

     {
      0x3FF566F005C20E67uL,
      0xBC94F8837880A9A2uL,
      0x0000000000000000uL,
      0x3FCE65E3F27C9F2AuL,
      0x3C6F62A8B8B40082uL,
      0x3FF0000000000000uL,
      0x3FACE04FD3EC1C90uL,
      0x3FD00E63DD639A45uL,
      0x3FDA598003751442uL,
      0x3FC73829AC409F93uL,
      0x3FCA15E3A26F9D65uL,
      0x3FBD4C4574E0CB34uL,
      0x3FBB9C5881865EC1uL,
      },

     {
      0x3FF534AC0F19860CuL,
      0x3C9EE4303B192DA6uL,
      0x0000000000000000uL,
      0x3FD007FA758626AEuL,
      0x3C65A5EB9CA505B6uL,
      0x3FF0000000000000uL,
      0x3FB00FF8E583BEBCuL,
      0x3FD1097A2AA570F5uL,
      0x3FDAF07DA8CAEBA7uL,
      0x3FC8DA9D107525ADuL,
      0x3FCB3545F2ADC1D6uL,
      0x3FBFB739DB465891uL,
      0x3FBDA2C23752D365uL,
      },

     {
      0x3FF502681870FDB2uL,
      0x3C92C0E3EEB304EEuL,
      0x0000000000000000uL,
      0x3FD0DE53475F3B3CuL,
      0x3C67B2CC0A83B8D0uL,
      0x3FF0000000000000uL,
      0x3FB1C8B7D76C7EE0uL,
      0x3FD20A509D4BB6C1uL,
      0x3FDB91F96510DF38uL,
      0x3FCA8F698D62832EuL,
      0x3FCC6C340829132AuL,
      0x3FC125B6D8F6980AuL,
      0x3FBE80E8F3AEF448uL,
      },

     {
      0x3FF4D02421C87558uL,
      0x3C7A765E893370D7uL,
      0x0000000000000000uL,
      0x3FD1B6103D3597E9uL,
      0x3C6CBCB5FED7BFB0uL,
      0x3FF0000000000000uL,
      0x3FB39AFA3392E164uL,
      0x3FD3114C46E2AEF3uL,
      0x3FDC3E6B23EF73B5uL,
      0x3FCC580D1B42EE7FuL,
      0x3FCDBC3D6E14D1FFuL,
      0x3FC28671B66B7EBDuL,
      0x3FC0BFBCFE643140uL,
      },

     {
      0x3FF49DE02B1FECFEuL,
      0xBC7616D2A8653209uL,
      0x0000000000000000uL,
      0x3FD28F459ECAD74DuL,
      0x3C302C86D50F5140uL,
      0x3FF0000000000000uL,
      0x3FB5875F92EDBDF4uL,
      0x3FD41ED6D05A0010uL,
      0x3FDCF65481FC5BEBuL,
      0x3FCE361FE028368DuL,
      0x3FCF2728B941710DuL,
      0x3FC3FFF67496086BuL,
      0x3FC1A12109F041C7uL,
      },

     {
      0x3FF46B9C347764A4uL,
      0xBC91A900F67F753AuL,
      0x0000000000000000uL,
      0x3FD36A08355C63DCuL,
      0xBC6D7145B6A0EB84uL,
      0x3FF0000000000000uL,
      0x3FB78E922B82AB64uL,
      0x3FD5335ED87AB0D5uL,
      0x3FDDBA417913D89CuL,
      0x3FD015AB59BD876BuL,
      0x3FD0576D1EF5DB86uL,
      0x3FC594A6DD2CA170uL,
      0x3FC2F51FBC1D0708uL,
      },

     {
      0x3FF439583DCEDC4AuL,
      0xBC9DCC4D42E59DF2uL,
      0x0000000000000000uL,
      0x3FD4466D542BAC92uL,
      0xBC705073A04E3471uL,
      0x3FF0000000000000uL,
      0x3FB9B14751F8BA20uL,
      0x3FD64F58590170A2uL,
      0x3FDE8AC91D15CFCFuL,
      0x3FD11CC2EF09C664uL,
      0x3FD12AB5AB65B965uL,
      0x3FC7471C9AC8155BuL,
      0x3FC4826BA97C3E62uL,
      },

     {
      0x3FF40714472653EFuL,
      0x3C96106670B43955uL,
      0x0000000000000000uL,
      0x3FD5248AE1701B17uL,
      0x3C7BE8CC944DBC57uL,
      0x3FF0000000000000uL,
      0x3FBBF04005723CCCuL,
      0x3FD7733D1300258AuL,
      0x3FDF688E6ACC7DF5uL,
      0x3FD231520EA793C8uL,
      0x3FD20E93C5183A32uL,
      0x3FC91A331D55B3EEuL,
      0x3FC651721E153056uL,
      },

     {
      0x3FF3D4D0507DCB95uL,
      0x3C83DA34489C213BuL,
      0x0000000000000000uL,
      0x3FD604775FBB27DFuL,
      0x3C6AC647C9CF38D0uL,
      0x3FF0000000000000uL,
      0x3FBE4C49866D2D78uL,
      0x3FD89F8D033946D5uL,
      0x3FE02A20954EE23AuL,
      0x3FD35466F88C5ABCuL,
      0x3FD3044BAC5DC8C8uL,
      0x3FCB110C3D6FEB5EuL,
      0x3FC7761A8DBF67E9uL,
      },

     {
      0x3FF3A28C59D5433BuL,
      0xBC61B19140C0C0D5uL,
      0x0000000000000000uL,
      0x3FD6E649F7D78649uL,
      0x3C678D2AC032531AuL,
      0x3FF0000000000000uL,
      0x3FC0631EFCBE0D16uL,
      0x3FD9D4CEDF38DFCDuL,
      0x3FE0A74F7488C3A6uL,
      0x3FD487249EA3BD6CuL,
      0x3FD40D3A9BDEFA27uL,
      0x3FCD2F1CBD1B58BDuL,
      0x3FC98CBDCEBDACE8uL,
      },

     {
      0x3FF37048632CBAE1uL,
      0xBC8CB2FCE8FC81A5uL,
      0x0000000000000000uL,
      0x3FD7CA1A832D0F84uL,
      0xBC7EE5A71208FD7EuL,
      0x3FF0000000000000uL,
      0x3FC1AF828B5ED674uL,
      0x3FDB13909C0269A2uL,
      0x3FE12C3A0394B7FAuL,
      0x3FD5CAC4A421216CuL,
      0x3FD52AE625505253uL,
      0x3FCF7831018A6159uL,
      0x3FCB98AB42F54A08uL,
      },

     {
      0x3FF33E046C843287uL,
      0xBC9A7CCAC0E4698BuL,
      0x0000000000000000uL,
      0x3FD8B00196B3D022uL,
      0xBC67341EE3041CF4uL,
      0x3FF0000000000000uL,
      0x3FC30BCA73878656uL,
      0x3FDC5C67FF403B73uL,
      0x3FE1B94E72981059uL,
      0x3FD7209990BAE1F6uL,
      0x3FD65EF72AC3A4FAuL,
      0x3FD0F83D8377C340uL,
      0x3FCD97555AF455A0uL,
      },

     {
      0x3FF30BC075DBAA2CuL,
      0x3C995FE8F2B56DBDuL,
      0x0000000000000000uL,
      0x3FD998188E816BF0uL,
      0x3C73DB2BD13E24E8uL,
      0x3FF0000000000000uL,
      0x3FC478794806DE66uL,
      0x3FDDAFF33BF96274uL,
      0x3FE24F039543C659uL,
      0x3FD88A113E071D2DuL,
      0x3FD7AB3E661E65FAuL,
      0x3FD24E4E1B8DC6C3uL,
      0x3FD01ED5FCAC1031uL,
      },

     {
      0x3FF2D97C7F3321D2uL,
      0x3C8A79394C9E8A0AuL,
      0x0000000000000000uL,
      0x3FDA827999FCEF32uL,
      0x3C708A11019E58E9uL,
      0x3FF0000000000000uL,
      0x3FC5F619980C4336uL,
      0x3FDF0ED99BED9B65uL,
      0x3FE2EDD996C1BBEBuL,
      0x3FDA08B785C6EA59uL,
      0x3FD911BC7B12902DuL,
      0x3FD3C0DA5B1130BAuL,
      0x3FD1B590151E4269uL,
      },

     {
      0x3FF2A738888A9978uL,
      0x3C5195059E91C4D2uL,
      0x0000000000000000uL,
      0x3FDB6F3FC8C61E5BuL,
      0xBC6A1CC48267E6BEuL,
      0x3FF0000000000000uL,
      0x3FC7853E65CE5524uL,
      0x3FE03CE61B6A9E63uL,
      0x3FE3965ABF5C8FABuL,
      0x3FDB9E3938F261E9uL,
      0x3FDA94A771ED6FE6uL,
      0x3FD552B7D4636639uL,
      0x3FD2F58F20A08A92uL,
      },

     {
      0x3FF274F491E2111EuL,
      0xBC8613F7E4FA18D6uL,
      0x0000000000000000uL,
      0x3FDC5E87185E67B6uL,
      0x3C4FEBA1F149DF00uL,
      0x3FF0000000000000uL,
      0x3FC92683A68EB5D0uL,
      0x3FE0F8C35C7247C7uL,
      0x3FE4491C4DCA262EuL,
      0x3FDD4C67683395D6uL,
      0x3FDC3667C15EBF94uL,
      0x3FD7070B7FE443C4uL,
      0x3FD4805841782C0CuL,
      },

     {
      0x3FF242B09B3988C4uL,
      0xBC972D483EE33523uL,
      0x0000000000000000uL,
      0x3FDD506C82A2C800uL,
      0x3C6E169413E029AEuL,
      0x3FF0000000000000uL,
      0x3FCADA8ECCC42C48uL,
      0x3FE1BB681D0BE8A7uL,
      0x3FE506BF662527D3uL,
      0x3FDF153B07CB2306uL,
      0x3FDDF9A636394DC9uL,
      0x3FD8E153A4A78673uL,
      0x3FD6937B3797DBB1uL,
      },

     {
      0x3FF2106CA4910069uL,
      0x3C9CAF6B74B6A225uL,
      0x0000000000000000uL,
      0x3FDE450E0D273E7AuL,
      0x3C74138BBC424A0DuL,
      0x3FF0000000000000uL,
      0x3FCCA20F5D4879EAuL,
      0x3FE2853E13FBB7C7uL,
      0x3FE5CFF21905E477uL,
      0x3FE07D6C7D0DAC66uL,
      0x3FDFE1550F550216uL,
      0x3FDAE570CE7F6BD7uL,
      0x3FD89328A3ABE601uL,
      },

     {
      0x3FF1DE28ADE8780FuL,
      0x3C908C1F2850796DuL,
      0x0000000000000000uL,
      0x3FDF3C8AD985D9EEuL,
      0x3C455C31F5355658uL,
      0x3FF0000000000000uL,
      0x3FCE7DBF907D8618uL,
      0x3FE356B5A1D9CA5AuL,
      0x3FE6A57085697F99uL,
      0x3FE17FCB46BE280BuL,
      0x3FE0F858275BAA48uL,
      0x3FDD17B47CA8A83BuL,
      0x3FDA9B369A707A32uL,
      },

     {
      0x3FF1ABE4B73FEFB5uL,
      0x3C71A34B6FA942D3uL,
      0x0000000000000000uL,
      0x3FE01B819B5A7CF7uL,
      0x3C80BED996FBB65FuL,
      0x3FF0000000000000uL,
      0x3FD03732803B2A4CuL,
      0x3FE430465B55C6C0uL,
      0x3FE78806185ACF72uL,
      0x3FE292FF3DF61A34uL,
      0x3FE215A449967BC2uL,
      0x3FDF7CEF2946D3A8uL,
      0x3FDD0F4FF3CD442FuL,
      },

     {
      0x3FF179A0C097675BuL,
      0xBC7EE9E5C1EF600DuL,
      0x0000000000000000uL,
      0x3FE09A4C59BD0D4DuL,
      0xBC451D94A7B70320uL,
      0x3FF0000000000000uL,
      0x3FD13A68B2A5E855uL,
      0x3FE5126F9FD8D89FuL,
      0x3FE8788EEDC53F19uL,
      0x3FE3B86B3E883B76uL,
      0x3FE34A881E7F09C9uL,
      0x3FE10D3EF07D106AuL,
      0x3FDFEBFE6AA0C4E7uL,
      },

     {
      0x3FF1475CC9EEDF01uL,
      0xBC93DDC5BCE200BBuL,
      0x0000000000000000uL,
      0x3FE11AB7190834ECuL,
      0xBC8E577A07DB7162uL,
      0x3FF0000000000000uL,
      0x3FD248F1B07217E3uL,
      0x3FE5FDB93DD01D06uL,
      0x3FE977F956462152uL,
      0x3FE4F192BE91E40AuL,
      0x3FE49932EEB2A51BuL,
      0x3FE27B305435DE1BuL,
      0x3FE176C2BDD3B0A4uL,
      },

     {
      0x3FF11518D34656A6uL,
      0x3C9FFEEDF6B7D68DuL,
      0x0000000000000000uL,
      0x3FE19CD3FE8E405DuL,
      0xBC84E5C1D482FB99uL,
      0x3FF0000000000000uL,
      0x3FD36343ADCAF866uL,
      0x3FE6F2B4260FF6A8uL,
      0x3FEA8747864942E1uL,
      0x3FE6401D47362936uL,
      0x3FE6040F50A52FBFuL,
      0x3FE40BA6192CC669uL,
      0x3FE302E7DAB9BDE8uL,
      },

     {
      0x3FF0E2D4DC9DCE4CuL,
      0x3C93DBA1AA51ADD5uL,
      0x0000000000000000uL,
      0x3FE220B5EF047825uL,
      0x3C5AE1F6C713C510uL,
      0x3FF0000000000000uL,
      0x3FD489DC399ADDECuL,
      0x3FE7F1FB2FEBE8C6uL,
      0x3FEBA791734D6CCEuL,
      0x3FE7A5DA56BAB9DAuL,
      0x3FE78DC9A17C17D7uL,
      0x3FE5C262725357A1uL,
      0x3FE4D1FE58052A33uL,
      },

     {
      0x3FF0B090E5F545F2uL,
      0x3C7EE15577AE1472uL,
      0x0000000000000000uL,
      0x3FE2A6709A74F289uL,
      0x3C76E3B98C26B440uL,
      0x3FF0000000000000uL,
      0x3FD5BD40BF249496uL,
      0x3FE8FC33EFCF6F3AuL,
      0x3FECDA06E4CFC822uL,
      0x3FE924C5BA1C7515uL,
      0x3FE9395A86CEDBCCuL,
      0x3FE7A39B6931C7C5uL,
      0x3FE6D875BED7333EuL,
      },

     {
      0x3FF07E4CEF4CBD98uL,
      0xBC71ABDBB9EA8E6EuL,
      0x0000000000000000uL,
      0x3FE32E1889047FFDuL,
      0xBC810D08F0134DCFuL,
      0x3FF0000000000000uL,
      0x3FD6FDFF12A4297BuL,
      0x3FEA120FA25B9D83uL,
      0x3FEE1FF1BF27E6ABuL,
      0x3FEABF0C6E045EA0uL,
      0x3FEB0A0E2CDCAB88uL,
      0x3FE9B40D41660E8EuL,
      0x3FE92FCC1848D932uL,
      },

     {
      0x3FF04C08F8A4353EuL,
      0xBC908E433AE0CC54uL,
      0x0000000000000000uL,
      0x3FE3B7C3289ED6F3uL,
      0xBC8C4CF3D327FEECuL,
      0x3FF0000000000000uL,
      0x3FD84CAE0A06DE7CuL,
      0x3FEB344C2E4C0F47uL,
      0x3FEF7AB88F5F820CuL,
      0x3FEC771219A99E98uL,
      0x3FED0390B144EACBuL,
      0x3FEBF90A32A17503uL,
      0x3FEBAC50A2912BE1uL,
      },

     {
      0x3FF019C501FBACE4uL,
      0xBC9CB18F8746F50CuL,
      0x0000000000000000uL,
      0x3FE44386DB9CE5DBuL,
      0xBC8A7F79AD342CDEuL,
      0x3FF0000000000000uL,
      0x3FD9A9EE22E82AF2uL,
      0x3FEC63B53FACFD1BuL,
      0x3FF075F0B010F1C9uL,
      0x3FEE4F7738A37AC1uL,
      0x3FEF29F7068A6E02uL,
      0x3FEE78912F3E4890uL,
      0x3FEE7DE5AD19FDA8uL,
      },

     {
      0x3FEFCF0216A64913uL,
      0xBC81A9B7A75A3B87uL,
      0x0000000000000000uL,
      0x3FE4D17B087B265DuL,
      0xBC788AAC4AE1F0D0uL,
      0x3FF0000000000000uL,
      0x3FDB166A3723839CuL,
      0x3FEDA1257F3D5E87uL,
      0x3FF13A8A70704F6BuL,
      0x3FF025900612C493uL,
      0x3FF0C0E778680DE8uL,
      0x3FF09CB2B02DFCCBuL,
      0x3FF0D681147681D3uL,
      },

     {
      0x3FEF6A7A2955385EuL,
      0x3C860FAFBFD97309uL,
      0x0000000000000000uL,
      0x3FE561B82AB7F990uL,
      0x3C87A5FA3E37FD12uL,
      0x3FF0000000000000uL,
      0x3FDC92D84170BCC6uL,
      0x3FEEED87E934644CuL,
      0x3FF20C10F4D7D072uL,
      0x3FF1369E37DA5741uL,
      0x3FF20816F61AB3EEuL,
      0x3FF221953D8712EFuL,
      0x3FF29CA76CD561F8uL,
      },

     {
      0x3FEF05F23C0427AAuL,
      0xBC51B746C796F33CuL,
      0x0000000000000000uL,
      0x3FE5F457E4F4812EuL,
      0x3C8F6EE06A43F015uL,
      0x3FF0000000000000uL,
      0x3FDE1FFA33ABCB2DuL,
      0x3FF024ECA3857FDFuL,
      0x3FF2EB80B3E2C969uL,
      0x3FF25CA858ECE33EuL,
      0x3FF36D6159DB2BC3uL,
      0x3FF3CF427530AFA1uL,
      0x3FF4914D16BF30D2uL,
      },

     {
      0x3FEEA16A4EB316F6uL,
      0xBC8A7D8171BF2FD8uL,
      0x0000000000000000uL,
      0x3FE6897514751DB6uL,
      0x3C7432E08569C822uL,
      0x3FF0000000000000uL,
      0x3FDFBE9EE099229DuL,
      0x3FF0DB94E83152C9uL,
      0x3FF3D9ED602549D9uL,
      0x3FF3999FCB35B63CuL,
      0x3FF4F3F4BB18D34DuL,
      0x3FF5AA9FE2712A89uL,
      0x3FF6B61F156D157EuL,
      },

     {
      0x3FEE3CE261620641uL,
      0x3C7A77CBEAE8FD71uL,
      0x0000000000000000uL,
      0x3FE7212BE621BE6DuL,
      0x3C8AD14CAC5AE1D4uL,
      0x4000000000000000uL,
      0xBFDE905D04D13F70uL,
      0x3FF19B4F7BD63206uL,
      0x3FF4D8845C8EEC38uL,
      0x3FF4EFAAD70924AAuL,
      0x3FF69F610EDFA788uL,
      0x3FF7B93C8525966AuL,
      0x3FF928F49138F1A9uL,
      },

     {
      0x3FEDD85A7410F58DuL,
      0xBC76156546AFA570uL,
      0x0000000000000000uL,
      0x3FE7BB99ED2990CFuL,
      0xBC8AABB1289366EEuL,
      0x4000000000000000uL,
      0xBFDCCC0DD257FE9FuL,
      0x3FF264BAB3E8C3FCuL,
      0x3FF5E88F7CC1F7BCuL,
      0x3FF6612B1AE228E1uL,
      0x3FF873A64164BF00uL,
      0x3FFA016987C44E2AuL,
      0x3FFBFCA608E41B3AuL,
      },

     {
      0x3FED73D286BFE4D8uL,
      0x3C8CAEB4C3DBDBD8uL,
      0x0000000000000000uL,
      0x3FE858DE3B716571uL,
      0x3C8C6340D74EFAEEuL,
      0x4000000000000000uL,
      0xBFDAF377B50F3DE8uL,
      0x3FF338819C6A585BuL,
      0x3FF70B781BB3F9F8uL,
      0x3FF7F0C4DC952BEEuL,
      0x3FFA75444794B0BEuL,
      0x3FFC8A58AEEA152DuL,
      0x3FFF1509C3EC473FuL,
      },

     {
      0x3FED0F4A996ED424uL,
      0x3C61A070AC3E29A0uL,
      0x0000000000000000uL,
      0x3FE8F9197BF85EEBuL,
      0xBC77971D706288A0uL,
      0x4000000000000000uL,
      0xBFD9058D62BBB98DuL,
      0x3FF4175D31199B0CuL,
      0x3FF842CA948070CEuL,
      0x3FF9A1675E6F2233uL,
      0x3FFCA94A75D1DF36uL,
      0x3FFF5C3EE98CB77CuL,
      0x4001549BBD7761F7uL,
      },

     {
      0x3FECAAC2AC1DC370uL,
      0xBC83DE7C6DBCC708uL,
      0x0000000000000000uL,
      0x3FE99C6E0F634394uL,
      0x3C81A125C4B0D75FuL,
      0x4000000000000000uL,
      0xBFD7012EAAC8A987uL,
      0x3FF50215B95FD940uL,
      0x3FF9903A2B193F49uL,
      0x3FFB7656607D37C1uL,
      0x3FFF156F461C0EE0uL,
      0x4001403E48F2741BuL,
      0x40034ACD8D38409AuL,
      },

     {
      0x3FEC463ABECCB2BBuL,
      0x3C83DAEAF976E788uL,
      0x0000000000000000uL,
      0x3FEA43002AE42850uL,
      0xBC7A7C0406D92972uL,
      0x4000000000000000uL,
      0xBFD4E526E33345B8uL,
      0x3FF5F9844B626284uL,
      0x3FFAF5A574C2F3BFuL,
      0x3FFD7334FD198D13uL,
      0x4000E01251879DC7uL,
      0x400300E6F5213CC2uL,
      0x40058BA67D3A054AuL,
      },

     {
      0x3FEBE1B2D17BA207uL,
      0xBC61AEB67D55A7A1uL,
      0x0000000000000000uL,
      0x3FEAECF5F9BA35A6uL,
      0x3C4535083409FF20uL,
      0x4000000000000000uL,
      0xBFD2B02B2D565D55uL,
      0x3FF6FE947B408BACuL,
      0x3FFC751B52A83938uL,
      0x3FFF9C12181CFBBAuL,
      0x4002585B4421C075uL,
      0x4004F6412119D9F1uL,
      0x400814BACED69AF1uL,
      },

     {
      0x3FEB7D2AE42A9153uL,
      0xBC8CB2463821BB58uL,
      0x0000000000000000uL,
      0x3FEB9A77C18C1AF2uL,
      0x3C76EA194A3B7D14uL,
      0x4000000000000000uL,
      0xBFD060D88DF903DFuL,
      0x3FF812463C417D93uL,
      0x3FFE10E093E6DE8DuL,
      0x4000FABB50DD022EuL,
      0x4003F7B45B053F76uL,
      0x4007275FB67DBBCCuL,
      0x400B02CB76CD8FDBuL,
      },

     {
      0x3FEB18A2F6D9809EuL,
      0x3C760E425E23E66FuL,
      0x0000000000000000uL,
      0x3FEC4BB009E77983uL,
      0xBC5346B6895525B8uL,
      0x4000000000000000uL,
      0xBFCBEB63A6D04570uL,
      0x3FF935AFFA8DCC1DuL,
      0x3FFFCB7657D15F0BuL,
      0x4002423AFCE75F54uL,
      0x4005C2CF61AD4B89uL,
      0x40099C675A298F48uL,
      0x400E49F38B657F73uL,
      },

     {
      0x3FEAB41B09886FEAuL,
      0xBC7A7EEED374BC71uL,
      0x0000000000000000uL,
      0x3FED00CBC7384D2EuL,
      0x3C78C4FC635D2596uL,
      0x4000000000000000uL,
      0xBFC6DA3A87611EA6uL,
      0x3FFA6A00F50D3A6FuL,
      0x4000D3D0A6ABBD46uL,
      0x4003A760672280D0uL,
      0x4007BF026C103550uL,
      0x400C5EBD23F4E2D6uL,
      0x4011024DB7867574uL,
      },

     {
      0x3FEA4F931C375F35uL,
      0x3C8A79EFFD795057uL,
      0x0000000000000000uL,
      0x3FEDB9FA89953FCFuL,
      0x3C286C68F5592C40uL,
      0x4000000000000000uL,
      0xBFC18AC418849A6EuL,
      0x3FFBB083E02786D7uL,
      0x4001D438F8A20402uL,
      0x40052D5D6FF7A4BDuL,
      0x4009F262067BAA5AuL,
      0x400F793DA8608BD3uL,
      0x401328BFC5F60A12uL,
      },

     {
      0x3FE9EB0B2EE64E81uL,
      0x3C519ABB2567F739uL,
      0x0000000000000000uL,
      0x3FEE776EAFC91706uL,
      0x3C890664EDC679F9uL,
      0x4000000000000000uL,
      0xBFB7F295AD658764uL,
      0x3FFD0AA1DB7F5E58uL,
      0x4002E8A6F9693556uL,
      0x4006D7CA16B298C6uL,
      0x400C63DFCAA3FB6CuL,
      0x40117C3EE50D7733uL,
      0x401599932C96B999uL,
      },

     {
      0x3FE9868341953DCDuL,
      0xBC861341341F5289uL,
      0x0000000000000000uL,
      0x3FEF395D9F0E3C92uL,
      0xBC550BEC65673F08uL,
      0x4000000000000000uL,
      0xBFA8873C53BE0540uL,
      0x3FFE79E5C65202DEuL,
      0x400412FD76797C7DuL,
      0x4008AAB30DC82D37uL,
      0x400F1B6C68B4AEA4uL,
      0x4013758CE9BD9EE9uL,
      0x40186872A06858F5uL,
      },

     {
      0x3FE921FB54442D18uL,
      0x3C81A62633145C07uL,
      0x3FF0000000000000uL,
      0xBFD17CC1B727220BuL,
      0x3C7AC07996DF1E94uL,
      0x3FE0000000000000uL,
      0xBFBF02F6222C71FBuL,
      0xBFB068BD68BAEFC3uL,
      0x3FA3C0213E30B2A4uL,
      0xBF8A5494A0DD32B3uL,
      0x3F7940CD1D8E923EuL,
      0xBF63CC1BE5088783uL,
      0x3F3FA4A6A27659EEuL,
      },

     {
      0x3FE8BD7366F31C64uL,
      0xBC6A81C996DFD5A5uL,
      0x3FF0000000000000uL,
      0xBFD130BD396BB4A9uL,
      0x3C657D8592EA0982uL,
      0x3FE0000000000000uL,
      0xBFBF68ED595308D6uL,
      0xBFB00C6BF6A673E6uL,
      0x3FA36E9DA9556AA6uL,
      0xBF8991120C7D4BB9uL,
      0x3F7889ABD600821AuL,
      0xBF630EE40468887BuL,
      0x3F52CAD75A194915uL,
      },

     {
      0x3FE858EB79A20BB0uL,
      0xBC8EE70AFE8446D9uL,
      0x3FF0000000000000uL,
      0xBFD0E507EE8B93D7uL,
      0xBC679F09CDD5D366uL,
      0x3FE0000000000000uL,
      0xBFBFCCA52E2AE201uL,
      0xBFAF632A1681FD0BuL,
      0x3FA31F7794BDF922uL,
      0xBF88D31259E30525uL,
      0x3F77D97B728544D6uL,
      0xBF62591A3A2B69D8uL,
      0x3F3605B3887E1AF3uL,
      },

     {
      0x3FE7F4638C50FAFBuL,
      0x3C71A4B8D15ECF6DuL,
      0x3FF0000000000000uL,
      0xBFD099A0163BCD3FuL,
      0xBC7A7F11D963D761uL,
      0x3FD0000000000000uL,
      0x3FBFD1D937A1F094uL,
      0xBFAEB05B52EFB4C0uL,
      0x3FA2D29E032A57DBuL,
      0xBF881A60F7D38723uL,
      0x3F772FBBF1BFA292uL,
      0xBF61AA745B27BAF7uL,
      0x3F51CC1913635CA5uL,
      },

     {
      0x3FE78FDB9EFFEA47uL,
      0xBC7EE8786039D373uL,
      0x3FF0000000000000uL,
      0xBFD04E83F7474877uL,
      0xBC73B117AC20AD03uL,
      0x3FD0000000000000uL,
      0x3FBF7284F47C0E61uL,
      0xBFAE0056458FCED5uL,
      0x3FA28800992AEEE6uL,
      0xBF8766CB6439B11DuL,
      0x3F768C54DBB3684BuL,
      0xBF610297B13942A7uL,
      0x3F5536BD1C2C92E8uL,
      },

     {
      0x3FE72B53B1AED992uL,
      0x3C88452B3716C4D6uL,
      0x3FF0000000000000uL,
      0xBFD003B1DF5A0F86uL,
      0xBC716CEB71FB7130uL,
      0x3FD0000000000000uL,
      0x3FBF155566FA6884uL,
      0xBFAD530628A37C7AuL,
      0x3FA23F8F96E80A99uL,
      0xBF86B82113BDC04EuL,
      0x3F75EF0B9C9DF1C1uL,
      0xBF60613421CB6A8BuL,
      0x3F48E48E9081596FuL,
      },

     {
      0x3FE6C6CBC45DC8DEuL,
      0xBBC6D61B58C99C43uL,
      0x3FF0000000000000uL,
      0xBFCF7250459C1976uL,
      0xBC40B5B081F067D4uL,
      0x3FD0000000000000uL,
      0x3FBEBA422E0FE0E5uL,
      0xBFACA856C815D042uL,
      0x3FA1F93BD218DCE9uL,
      0xBF860E335AB42933uL,
      0x3F75578EEA5D18CCuL,
      0xBF5F8BFBAD564EB5uL,
      0x3F434A80D203FDB7uL,
      },

     {
      0x3FE66243D70CB82AuL,
      0xBC884805FA81DE0AuL,
      0x3FF0000000000000uL,
      0xBFCEDDCA38F25FECuL,
      0x3C65AACB9E8B4E8CuL,
      0x3FD0000000000000uL,
      0x3FBE6143274A35BFuL,
      0xBFAC00347C15ABB2uL,
      0x3FA1B4F6B03A62C8uL,
      0xBF8568D557225239uL,
      0x3F74C5A8346B014EuL,
      0xBF5E61680C7E3887uL,
      0x3F45A81E03A2004AuL,
      },

     {
      0x3FE5FDBBE9BBA775uL,
      0x3C7EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0xBFCE49CE5AF9DC29uL,
      0x3C382336F1C6B420uL,
      0x3FD0000000000000uL,
      0x3FBE0A506D218F3CuL,
      0xBFAB5A8C23E49FEAuL,
      0x3FA172B22117D625uL,
      0xBF84C7DBDBF304B9uL,
      0x3F74391DF553E941uL,
      0xBF5D4211231EF20FuL,
      0x3F52AB1CCD6F9451uL,
      },

     {
      0x3FE59933FC6A96C1uL,
      0xBC71AA6E583501D4uL,
      0x3FF0000000000000uL,
      0xBFCDB6597A2E1B61uL,
      0x3C6CB71A947AAB6BuL,
      0x3FD0000000000000uL,
      0x3FBDB56255580CA4uL,
      0xBFAAB74B20D856E7uL,
      0x3FA1326099896038uL,
      0xBF842B1D5CF84F74uL,
      0x3F73B1CC2C4E32E8uL,
      0xBF5C2D7D75B7FBCEuL,
      0x3F53DB94CE05D10AuL,
      },

     {
      0x3FE534AC0F19860CuL,
      0x3C8EE4303B192DA6uL,
      0x3FF0000000000000uL,
      0xBFCD236870E769B5uL,
      0xBC523CE78218C3F0uL,
      0x3FD0000000000000uL,
      0x3FBD62716F68B5FEuL,
      0xBFAA165F518C38ABuL,
      0x3FA0F3F50E789484uL,
      0xBF839271DC18DB75uL,
      0x3F732F8BAC4C5496uL,
      0xBF5B23248F865BB8uL,
      0x3F36E307E32E173BuL,
      },

     {
      0x3FE4D02421C87558uL,
      0x3C6A765E893370D7uL,
      0x3FF0000000000000uL,
      0xBFCC90F8250157F7uL,
      0xBC657D8312BFEA16uL,
      0x3FD0000000000000uL,
      0x3FBD117683053E13uL,
      0xBFA977B70D411C29uL,
      0x3FA0B762F022F359uL,
      0xBF82FDB2D7324A8FuL,
      0x3F72B2030A36AAE0uL,
      0xBF5A22A22953FC15uL,
      0x3F473A2F09CB1310uL,
      },

     {
      0x3FE46B9C347764A4uL,
      0xBC81A900F67F753AuL,
      0x3FF0000000000000uL,
      0xBFCBFF05878394D3uL,
      0xBC486912F813DEBCuL,
      0x3FD0000000000000uL,
      0x3FBCC26A8EA2077FuL,
      0xBFA8DB411F68EE69uL,
      0x3FA07C9E25737218uL,
      0xBF826CBB3713A292uL,
      0x3F72392A32F26712uL,
      0xBF592B76EEB6E333uL,
      0x3F39BADB57E2A4EBuL,
      },

     {
      0x3FE40714472653EFuL,
      0x3C86106670B43955uL,
      0x3FF0000000000000uL,
      0xBFCB6D8D944D0371uL,
      0x3C6CDD9D6EA4B883uL,
      0x3FD0000000000000uL,
      0x3FBC7546C60FE5C7uL,
      0xBFA840ECC35C53FDuL,
      0x3FA0439B07C380F3uL,
      0xBF81DF673F038AB5uL,
      0x3F71C4B3C36B8A2BuL,
      0xBF583D44FA2FB1ACuL,
      0x3F52EE3E6107070CuL,
      },

     {
      0x3FE3A28C59D5433BuL,
      0xBC51B19140C0C0D5uL,
      0x3FF0000000000000uL,
      0xBFCADC8D51C0FA5BuL,
      0xBC54B350B5D39454uL,
      0x3FD0000000000000uL,
      0x3FBC2A04912319A8uL,
      0xBFA7A8A9A038608EuL,
      0x3FA00C4E5E972915uL,
      0xBF8155947D4C5C83uL,
      0x3F7154A7B149DA51uL,
      0xBF5757960EDFC478uL,
      0x3F3F895707140B54uL,
      },

     {
      0x3FE33E046C843287uL,
      0xBC8A7CCAC0E4698BuL,
      0x3FF0000000000000uL,
      0xBFCA4C01D0769648uL,
      0xBC4DDC96CAE4A560uL,
      0x3FD0000000000000uL,
      0x3FBBE09D8A670D72uL,
      0xBFA71267C4E29753uL,
      0x3F9FAD5AB78BB764uL,
      0xBF80CF21BC414F68uL,
      0x3F70E8AC1DCF4364uL,
      0xBF567A14C0530821uL,
      0x3F4F621D6DA2AD4CuL,
      },

     {
      0x3FE2D97C7F3321D2uL,
      0x3C7A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0xBFC9BBE82AEA0D12uL,
      0x3C62D116CA770BB7uL,
      0x3FD0000000000000uL,
      0x3FBB990B7DDE5BFCuL,
      0xBFA67E17A4317C6CuL,
      0x3F9F455B2F170454uL,
      0xBF804BEEF437A2B3uL,
      0x3F7080CEADF2974DuL,
      0xBF55A44E3A71E98CuL,
      0xBF039F9468E5AC7CuL,
      },

     {
      0x3FE274F491E2111EuL,
      0xBC7613F7E4FA18D6uL,
      0x3FF0000000000000uL,
      0xBFC92C3D852FEDF2uL,
      0xBC20F5E7403E63E0uL,
      0x3FD0000000000000uL,
      0x3FBB534867CEB1CBuL,
      0xBFA5EBAA113813D4uL,
      0x3F9EE08A1A202CC5uL,
      0xBF7F97BA7BA1301AuL,
      0x3F701CAD7F191E00uL,
      0xBF54D60D132212FEuL,
      0x3F45F5FE99746255uL,
      },

     {
      0x3FE2106CA4910069uL,
      0x3C8CAF6B74B6A225uL,
      0x3FF0000000000000uL,
      0xBFC89CFF0CAA3CB4uL,
      0x3C6A8D50D06FC30EuL,
      0x3FD0000000000000uL,
      0x3FBB0F4E73981D4BuL,
      0xBFA55B103BB2BD6DuL,
      0x3F9E7ED42D91EC8DuL,
      0xBF7E9D9D8AAE7B14uL,
      0x3F6F78B5039EFACAuL,
      0xBF540EDBA3A7865EuL,
      0x3F3AA2CB5E8CB7D1uL,
      },

     {
      0x3FE1ABE4B73FEFB5uL,
      0x3C61A34B6FA942D3uL,
      0x3FF0000000000000uL,
      0xBFC80E29F7BF5633uL,
      0xBC67F8F06ACC6DE1uL,
      0x3FD0000000000000uL,
      0x3FBACD17FA976786uL,
      0xBFA4CC3BAC93F075uL,
      0x3F9E2026D6967836uL,
      0xBF7DA94D7C694B78uL,
      0x3F6EBF4F14B98A4DuL,
      0xBF534E7211F8744BuL,
      0xBF2290D134413454uL,
      },

     {
      0x3FE1475CC9EEDF01uL,
      0xBC83DDC5BCE200BBuL,
      0x3FF0000000000000uL,
      0xBFC77FBB85928D2DuL,
      0x3C6121F4E1AC8205uL,
      0x3FD0000000000000uL,
      0x3FBA8C9F83131391uL,
      0xBFA43F1E42AF6970uL,
      0x3F9DC4703433CA75uL,
      0xBF7CBA92AE7FE396uL,
      0x3F6E0CB6D0475CBFuL,
      0xBF529491FB8790F1uL,
      0x3F37152AFD512A19uL,
      },

     {
      0x3FE0E2D4DC9DCE4CuL,
      0x3C83DBA1AA51ADD5uL,
      0x3FF0000000000000uL,
      0xBFC6F1B0FDBE6EDEuL,
      0xBC614F63025E350FuL,
      0x3FD0000000000000uL,
      0x3FBA4DDFBF32A727uL,
      0xBFA3B3AA2F826E47uL,
      0x3F9D6B9F112A3CA9uL,
      0xBF7BD1375F2B326EuL,
      0x3F6D60EF002A5944uL,
      0xBF51E0E0E3E64206uL,
      0x3F32BFA3B8DB7E72uL,
      },

     {
      0x3FE07E4CEF4CBD98uL,
      0xBC61ABDBB9EA8E6EuL,
      0x3FF0000000000000uL,
      0xBFC66407B0109FA6uL,
      0xBC55C3EC26D04386uL,
      0x3FD0000000000000uL,
      0x3FBA10D38BFFE319uL,
      0xBFA329D1F417DBD6uL,
      0x3F9D15A2DE544C7CuL,
      0xBF7AED07977D3236uL,
      0x3F6CBBAD3C53FDBFuL,
      0xBF513318B342B4E5uL,
      0x3F1AF93D1229A6F6uL,
      },

     {
      0x3FE019C501FBACE4uL,
      0xBC8CB18F8746F50CuL,
      0x3FF0000000000000uL,
      0xBFC5D6BCF447403EuL,
      0x3C6C6C662876B222uL,
      0x3FD0000000000000uL,
      0x3FB9D575F071964AuL,
      0xBFA2A1885E06BEACuL,
      0x3F9CC26BAD1B38B8uL,
      0xBF7A0DD116DA5229uL,
      0x3F6C1C921E809C9EuL,
      0xBF508B03CEF8B07AuL,
      0x3F4BCE57D03F879AuL,
      },

     {
      0x3FDF6A7A2955385EuL,
      0x3C760FAFBFD97309uL,
      0x3FF0000000000000uL,
      0xBFC549CE29CFCCBEuL,
      0x3C69881846E0C1CCuL,
      0x3FD0000000000000uL,
      0x3FB99BC21C7FB9B2uL,
      0xBFA21AC0848A46C5uL,
      0x3F9C71EA2A16819DuL,
      0xBF7933633F8F0072uL,
      0x3F6B83D1C55099C3uL,
      0xBF4FD088727B159EuL,
      0xBF2306C94816B8C4uL,
      },

     {
      0x3FDEA16A4EB316F6uL,
      0xBC7A7D8171BF2FD8uL,
      0x3FF0000000000000uL,
      0xBFC4BD38B7876716uL,
      0xBC5504069A91A9E0uL,
      0x3FD0000000000000uL,
      0x3FB963B368408780uL,
      0xBFA1956DC5B1F35AuL,
      0x3F9C240F984C07DCuL,
      0xBF785D8F0388F11CuL,
      0x3F6AF0B073DF1CCAuL,
      0xBF4E9580D70D34E0uL,
      0x3F4571315C44A425uL,
      },

     {
      0x3FDDD85A7410F58DuL,
      0xBC66156546AFA570uL,
      0x3FF0000000000000uL,
      0xBFC430FA0B7C7F15uL,
      0xBC63115D3C69C624uL,
      0x3FD0000000000000uL,
      0x3FB92D45530E4319uL,
      0xBFA11183C3A8DFF6uL,
      0x3F9BD8CDCC073185uL,
      0xBF778C26D2F52E9AuL,
      0x3F6A638650FB676DuL,
      0xBF4D6420527BDB5BuL,
      0xBF2DA5A645CA3434uL,
      },

     {
      0x3FDD0F4A996ED424uL,
      0x3C51A070AC3E29A0uL,
      0x3FF0000000000000uL,
      0xBFC3A50F9AB1CA91uL,
      0xBC50CA3B48D907FAuL,
      0x3FD0000000000000uL,
      0x3FB8F87382B56ACBuL,
      0xBFA08EF662132882uL,
      0x3F9B901726A3CD1CuL,
      0xBF76BEFE8A4461A2uL,
      0x3F69DBAE42D8A416uL,
      0xBF4C3C52357BF011uL,
      0x3F32456D9E7FA4E8uL,
      },

     {
      0x3FDC463ABECCB2BBuL,
      0x3C73DAEAF976E788uL,
      0x3FF0000000000000uL,
      0xBFC31976E0E280B3uL,
      0x3C667516EE4F26F2uL,
      0x3FD0000000000000uL,
      0x3FB8C539C2AB0F89uL,
      0xBFA00DB9C3806462uL,
      0x3F9B49DE91DB8E44uL,
      0xBF75F5EB6258C838uL,
      0x3F695952C6BEE603uL,
      0xBF4B1D691B1E9F12uL,
      0xBEFC715673917907uL,
      },

     {
      0x3FDB7D2AE42A9153uL,
      0xBC7CB2463821BB58uL,
      0x3FF0000000000000uL,
      0xBFC28E2D6047CBC8uL,
      0x3C0CEAB2537EA300uL,
      0x3FD0000000000000uL,
      0x3FB89394034B11CFuL,
      0xBF9F1B848DE48876uL,
      0x3F9B06177BDD3821uL,
      0xBF7530C3E0150AA0uL,
      0x3F68DBF62FBA70ECuL,
      0xBF4A0736C860B400uL,
      0x3F50A3F1D92A1F47uL,
      },

     {
      0x3FDAB41B09886FEAuL,
      0xBC6A7EEED374BC71uL,
      0x3FF0000000000000uL,
      0xBFC20330A15F6568uL,
      0xBC61BB4F210EA632uL,
      0x3FD0000000000000uL,
      0x3FB8637E591E05FEuL,
      0xBF9E1E090AECCE81uL,
      0x3F9AC4B5D3090946uL,
      0xBF746F5FC5C316BAuL,
      0x3F686400E51F5377uL,
      0xBF48F8EADC3DBAD1uL,
      0xBF320AB3DE6FDA08uL,
      },

     {
      0x3FD9EB0B2EE64E81uL,
      0x3C419ABB2567F739uL,
      0x3FF0000000000000uL,
      0xBFC1787E32B35112uL,
      0x3C5D2D85EBE7CEA8uL,
      0x3FD0000000000000uL,
      0x3FB834F4FC268515uL,
      0xBF9D22EA9FA50E7DuL,
      0x3F9A85AE02819BA3uL,
      0xBF73B19803AB2B21uL,
      0x3F67F0B8C64045E8uL,
      0xBF47F293167B415AuL,
      0xBF198BF45BBDE600uL,
      },

     {
      0x3FD921FB54442D18uL,
      0x3C71A62633145C07uL,
      0x3FF0000000000000uL,
      0xBFC0EE13A8A2A9C6uL,
      0x3C5830A63DDC3262uL,
      0x3FD0000000000000uL,
      0x3FB807F44735B1A4uL,
      0xBF9C2A135884458AuL,
      0x3F9A48F4EE376E9DuL,
      0xBF72F746AAC73A47uL,
      0x3F678215824701EAuL,
      0xBF46F3C719FB6619uL,
      0x3F4BA88D5E69B64EuL,
      },

     {
      0x3FD858EB79A20BB0uL,
      0xBC7EE70AFE8446D9uL,
      0x3FF0000000000000uL,
      0xBFC063EE9D2B777CuL,
      0xBC4E1787D8B78D9CuL,
      0x3FD0000000000000uL,
      0x3FB7DC78B746BB2FuL,
      0xBF9B336DA889AC7DuL,
      0x3F9A0E7FEF8737D6uL,
      0xBF724046DF328844uL,
      0x3F67185639AB9961uL,
      0xBF45FBD25ACB3AEDuL,
      0x3F0E765A16190A6DuL,
      },

     {
      0x3FD78FDB9EFFEA47uL,
      0xBC6EE8786039D373uL,
      0x3FF0000000000000uL,
      0xBFBFB4195F6B0333uL,
      0xBC47DB89E27050CEuL,
      0x3FD0000000000000uL,
      0x3FB7B27EEAE12CDBuL,
      0xBF9A3EE464F938D9uL,
      0x3F99D644D21E7AE8uL,
      0xBF718C74CAAA7BA1uL,
      0x3F66B2F778B94CFDuL,
      0xBF450AB96EF7378BuL,
      0x3F1412EF7D22C6CAuL,
      },

     {
      0x3FD6C6CBC45DC8DEuL,
      0xBBB6D61B58C99C43uL,
      0x3FF0000000000000uL,
      0xBFBEA0D709BC27CAuL,
      0xBC48928D103E7F70uL,
      0x3FD0000000000000uL,
      0x3FB78A03A181D6ACuL,
      0xBF994C62C1366C88uL,
      0x3F99A039D09A41ADuL,
      0xBF70DBAD90C6529AuL,
      0x3F66520A2F7F4662uL,
      0xBF441FF58F223C4FuL,
      0xBF357CCF18E00FA5uL,
      },

     {
      0x3FD5FDBBE9BBA775uL,
      0x3C6EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0xBFBD8E118C89577FuL,
      0xBC3344F06C36BFACuL,
      0x3FD0000000000000uL,
      0x3FB76303BB0A22C5uL,
      0xBF985BD44ABC0416uL,
      0x3F996C5591BA6DFAuL,
      0xBF702DCF4265B5B3uL,
      0x3F65F52766DBD146uL,
      0xBF433B879649EE5CuL,
      0x3F47C67A932EC95BuL,
      },

     {
      0x3FD534AC0F19860CuL,
      0x3C7EE4303B192DA6uL,
      0x3FF0000000000000uL,
      0xBFBC7BC444B10758uL,
      0x3C511540B2268E0EuL,
      0x3FD0000000000000uL,
      0x3FB73D7C3735AA80uL,
      0xBF976D24E52F1F79uL,
      0x3F993A8F25560FF4uL,
      0xBF6F0571A586F6F3uL,
      0x3F659C8E8181F3F0uL,
      0xBF425CCABE1033EAuL,
      0x3F4D59CA0EE986DFuL,
      },

     {
      0x3FD46B9C347764A4uL,
      0xBC71A900F67F753AuL,
      0x3FF0000000000000uL,
      0xBFBB69EA984DE6EFuL,
      0x3C573CB7437F1792uL,
      0x3FD0000000000000uL,
      0x3FB7196A3515E12EuL,
      0xBF968040C68C8FE8uL,
      0x3F990ADE01D185E6uL,
      0xBF6DB49417B3E65CuL,
      0x3F6548393E856BDBuL,
      0xBF418353F782833AuL,
      0xBF36489E03176323uL,
      },

     {
      0x3FD3A28C59D5433BuL,
      0xBC41B19140C0C0D5uL,
      0x3FF0000000000000uL,
      0xBFBA587FF6553726uL,
      0x3C5559CFE8366BA8uL,
      0x3FD0000000000000uL,
      0x3FB6F6CAF293AC7FuL,
      0xBF959514736F007FuL,
      0x3F98DD3A019E14EBuL,
      0xBF6C68C706B3D0FBuL,
      0x3F64F779DB6C50F9uL,
      0xBF40AF7CD7497BC1uL,
      0x3F4AD3B98213250EuL,
      },

     {
      0x3FD2D97C7F3321D2uL,
      0x3C6A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0xBFB9477FD636A4D8uL,
      0x3C5063C8B22C4842uL,
      0x3FD0000000000000uL,
      0x3FB6D59BCBF6C48BuL,
      0xBF94AB8CBB6CBB16uL,
      0x3F98B19B6070D56DuL,
      0xBF6B21CD22DB24B2uL,
      0x3F64AAE4575F07CBuL,
      0xBF3FC08B3806F47FuL,
      0xBF00E427650BA68AuL,
      },

     {
      0x3FD2106CA4910069uL,
      0x3C7CAF6B74B6A225uL,
      0x3FF0000000000000uL,
      0xBFB836E5B77D959AuL,
      0xBC51BDCEFF6925ECuL,
      0x3FD0000000000000uL,
      0x3FB6B5DA3B72B738uL,
      0xBF93C396B58BD74AuL,
      0x3F9887FAB9649830uL,
      0xBF69DF6A8A7C820CuL,
      0x3F6461D2011761C1uL,
      0xBF3E2C1220D97FBEuL,
      0x3F49F3B20EDA3AFFuL,
      },

     {
      0x3FD1475CC9EEDF01uL,
      0xBC73DDC5BCE200BBuL,
      0x3FF0000000000000uL,
      0xBFB726AD2173D50EuL,
      0xBC1FCEC90C8BEF70uL,
      0x3FD0000000000000uL,
      0x3FB69783D8B96CDFuL,
      0xBF92DD1FBCCBA937uL,
      0x3F986051045C3883uL,
      0xBF68A164B9409BD2uL,
      0x3F641CB77D330F8FuL,
      0xBF3C9FE910D9CBC2uL,
      0xBF302CCA98190297uL,
      },

     {
      0x3FD07E4CEF4CBD98uL,
      0xBC51ABDBB9EA8E6EuL,
      0x3FF0000000000000uL,
      0xBFB616D1A2C591A8uL,
      0x3C2EF832FD935ED0uL,
      0x3FD0000000000000uL,
      0x3FB67A9658930D84uL,
      0xBF91F8156CC25284uL,
      0x3F983A9794563574uL,
      0xBF67678272C8ECDDuL,
      0x3F63DAE696E3A38CuL,
      0xBF3B1CDBB342EE5DuL,
      0x3F49E00A3B463CAFuL,
      },

     {
      0x3FCF6A7A2955385EuL,
      0x3C660FAFBFD97309uL,
      0x3FF0000000000000uL,
      0xBFB5074ED126983EuL,
      0x3C516E0EB4132D8CuL,
      0x3FD0000000000000uL,
      0x3FB65F0F8C7B2809uL,
      0xBF9114659E4D5E41uL,
      0x3F9816C815084CDAuL,
      0xBF66318BB353364DuL,
      0x3F639CED9C49E6E4uL,
      0xBF39A0F6E494228EuL,
      0xBF2EBBDA5946D8F5uL,
      },

     {
      0x3FCDD85A7410F58DuL,
      0xBC56156546AFA570uL,
      0x3FF0000000000000uL,
      0xBFB3F82048F8BE00uL,
      0xBC4AFD1EBA1D1F08uL,
      0x3FD0000000000000uL,
      0x3FB644ED6242FE19uL,
      0xBF9031FE64545C32uL,
      0x3F97F4DC89754A8CuL,
      0xBF64FF499B056453uL,
      0x3F636226CB0F9286uL,
      0xBF382D35D5867708uL,
      0x3F3E29EBBEAD3F41uL,
      },

     {
      0x3FCC463ABECCB2BBuL,
      0x3C63DAEAF976E788uL,
      0x3FF0000000000000uL,
      0xBFB2E941ACF368E6uL,
      0x3C28FF4CA630E160uL,
      0x3FD0000000000000uL,
      0x3FB62C2DE3B8D982uL,
      0xBF8EA19C1138E963uL,
      0x3F97D4CF49C89DB5uL,
      0xBF63D0865FBE1BACuL,
      0x3F632AE80D59D97DuL,
      0xBF36C01A5963B74DuL,
      0x3F2F2207CBA79A42uL,
      },

     {
      0x3FCAB41B09886FEAuL,
      0xBC5A7EEED374BC71uL,
      0x3FF0000000000000uL,
      0xBFB1DAAEA5CC26DDuL,
      0x3C51577CBB7A4D94uL,
      0x3FD0000000000000uL,
      0x3FB614CF365450F4uL,
      0xBF8CE1861157F322uL,
      0x3F97B69B01FB3B26uL,
      0xBF62A50D3A3C528BuL,
      0x3F62F6E9071D40DBuL,
      0xBF3559C86E0B83FEuL,
      0x3F41AFC8FEE8B00AuL,
      },

     {
      0x3FC921FB54442D18uL,
      0x3C61A62633145C07uL,
      0x3FF0000000000000uL,
      0xBFB0CC62E1E04467uL,
      0xBC47805D7AE2B26CuL,
      0x3FD0000000000000uL,
      0x3FB5FECF9AE763EAuL,
      0xBF8B23982579F8E5uL,
      0x3F979A3AB01644F9uL,
      0xBF617CAA57838224uL,
      0x3F62C658DCA7F4ABuL,
      0xBF33F9251280A953uL,
      0xBF2D5C4E17766D5AuL,
      },

     {
      0x3FC78FDB9EFFEA47uL,
      0xBC5EE8786039D373uL,
      0x3FF0000000000000uL,
      0xBFAF7CB429BEA72CuL,
      0xBC3FFC35F2771324uL,
      0x3FD0000000000000uL,
      0x3FB5EA2D6D5456CAuL,
      0xBF8967B0057BF87EuL,
      0x3F977FA9A2ED4D75uL,
      0xBF60572AC7A74374uL,
      0x3F6298E78AA42A2CuL,
      0xBF329E8594822820uL,
      0xBF37DBAE80B80EC8uL,
      },

     {
      0x3FC5FDBBE9BBA775uL,
      0x3C5EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0xBFAD611FEEED2925uL,
      0xBC2C094544F37630uL,
      0x3FD0000000000000uL,
      0x3FB5D6E7244839E4uL,
      0xBF87ADABBEBF7F7FuL,
      0x3F9766E378A69DCAuL,
      0xBF5E68B8DEC46BCDuL,
      0x3F626E6BF47FF36DuL,
      0xBF3149F4C32A02B4uL,
      0x3F4B764BFF26FBAFuL,
      },

     {
      0x3FC46B9C347764A4uL,
      0xBC61A900F67F753AuL,
      0x3FF0000000000000uL,
      0xBFAB46008DFA625DuL,
      0x3C1CFC71261A7FB0uL,
      0x3FD0000000000000uL,
      0x3FB5C4FB50FA0748uL,
      0xBF85F569AE5EF4C9uL,
      0x3F974FE41D60092FuL,
      0xBF5C281BF4A7A8E8uL,
      0x3F62476FB6177831uL,
      0xBF2FF1DE9AA130D5uL,
      0xBF3D841C7D3057BCuL,
      },

     {
      0x3FC2D97C7F3321D2uL,
      0x3C5A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0xBFA92B4D8A427A5EuL,
      0xBC48D0F742399A2EuL,
      0x3FD0000000000000uL,
      0x3FB5B4689EEE44C8uL,
      0xBF843EC87B78BC83uL,
      0x3F973AA7CA62B764uL,
      0xBF59EC1D907A7E74uL,
      0x3F62232304CE0BCBuL,
      0xBF2D5C019E5C9327uL,
      0x3F4A5742B30D6EA4uL,
      },

     {
      0x3FC1475CC9EEDF01uL,
      0xBC63DDC5BCE200BBuL,
      0x3FF0000000000000uL,
      0xBFA710FE6F2ADA79uL,
      0x3C47FCD1AF1BC88CuL,
      0x3FD0000000000000uL,
      0x3FB5A52DD3BF1903uL,
      0xBF8289A7118F8015uL,
      0x3F97272B048B0CB6uL,
      0xBF57B45DC9402B07uL,
      0x3F620239A251E2D3uL,
      0xBF2ACB87C59ED9B1uL,
      0xBF314F7BD600B48CuL,
      },

     {
      0x3FBF6A7A2955385EuL,
      0x3C560FAFBFD97309uL,
      0x3FF0000000000000uL,
      0xBFA4F70ACF7EED25uL,
      0xBC36D383618823A2uL,
      0x3FD0000000000000uL,
      0x3FB59749CEE8C351uL,
      0xBF80D5E49AFDF8A4uL,
      0x3F97156A9BCB4ECEuL,
      0xBF55807DE55737F7uL,
      0x3F61E4232793575AuL,
      0xBF28440F1D68D5AEuL,
      0xBF29FA204333F00CuL,
      },

     {
      0x3FBC463ABECCB2BBuL,
      0x3C53DAEAF976E788uL,
      0x3FF0000000000000uL,
      0xBFA2DD6A44CE1394uL,
      0xBC4BFF776DACC8B5uL,
      0x3FD0000000000000uL,
      0x3FB58ABB899A6815uL,
      0xBF7E46C0F6F92ADFuL,
      0x3F970563A9ED840FuL,
      0xBF53502047076AB7uL,
      0x3F61C8E9B000D23FuL,
      0xBF25C4A8BD148199uL,
      0x3F4131449FFC5A0CuL,
      },

     {
      0x3FB921FB54442D18uL,
      0x3C51A62633145C07uL,
      0x3FF0000000000000uL,
      0xBFA0C4146ECAB658uL,
      0x3C0F927420EB8C00uL,
      0x3FD0000000000000uL,
      0x3FB57F82168B23ECuL,
      0xBF7AE3F4956ED507uL,
      0x3F96F71391CF9DFEuL,
      0xBF5122E851208A87uL,
      0x3F61B0E12D5FF408uL,
      0xBF23485E9450F437uL,
      0xBF3CE0F3BAD9A7CFuL,
      },

     {
      0x3FB5FDBBE9BBA775uL,
      0x3C4EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0xBF9D5601E554ACE4uL,
      0x3BF1725D940FAE40uL,
      0x3FD0000000000000uL,
      0x3FB5759CA1D35995uL,
      0xBF7783239DE5AD22uL,
      0x3F96EA77FED69EC2uL,
      0xBF4DF0F48A9F5DD6uL,
      0x3F619B9AD4B4F692uL,
      0xBF20D3375495B3AFuL,
      0xBF3C5F6BDA9649C1uL,
      },

     {
      0x3FB2D97C7F3321D2uL,
      0x3C4A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0xBF99244EF50D08B4uL,
      0xBBF5D43FBFA6A650uL,
      0x3FD0000000000000uL,
      0x3FB56D0A70CA2FAEuL,
      0xBF74240DEF7AA427uL,
      0x3F96DF8EE40AD931uL,
      0xBF49A0F663CD9CEDuL,
      0x3F61892DA49A01B1uL,
      0xBF1CC6A5F5CD8613uL,
      0xBF2979EF025F5A5DuL,
      },

     {
      0x3FAF6A7A2955385EuL,
      0x3C460FAFBFD97309uL,
      0x3FF0000000000000uL,
      0xBF94F2FF697D458FuL,
      0xBC2D47EE0D8639CCuL,
      0x3FD0000000000000uL,
      0x3FB565CAE1E73473uL,
      0xBF70C673B159CE1DuL,
      0x3F96D6567B9EC32EuL,
      0xBF455521A900DE57uL,
      0x3F6179A180C97DC6uL,
      0xBF17EE9A1A2093ECuL,
      0xBF0F289C23A5BE3DuL,
      },

     {
      0x3FA921FB54442D18uL,
      0x3C41A62633145C07uL,
      0x3FF0000000000000uL,
      0xBF90C202A6B4B69CuL,
      0x3C232719F8027342uL,
      0x3FD0000000000000uL,
      0x3FB55FDD6CA81EFBuL,
      0xBF6AD42A909B3D64uL,
      0x3F96CECD466E9161uL,
      0xBF410CC300A993C8uL,
      0x3F616CF28C1A20ADuL,
      0xBF131CA14234B209uL,
      0xBF0575725B2F6BD2uL,
      },

     {
      0x3FA2D97C7F3321D2uL,
      0x3C3A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0xBF8922902DB2AC11uL,
      0xBC23466BF961968DuL,
      0x3FD0000000000000uL,
      0x3FB55B41A17AA68CuL,
      0xBF641D6698BEFAD5uL,
      0x3F96C8F20B94D936uL,
      0xBF398E50110336DCuL,
      0x3F61630EF83C40BEuL,
      0xBF0CA4CD1D39A327uL,
      0x3F2D88AA4542B2A9uL,
      },

     {
      0x3F9921FB54442D18uL,
      0x3C31A62633145C07uL,
      0x3FF0000000000000uL,
      0xBF80C17E51DDB68FuL,
      0xBC2BCDF2CE757F58uL,
      0x3FD0000000000000uL,
      0x3FB557F729AA69CBuL,
      0xBF5AD039FA1B06A9uL,
      0x3F96C4C3D80DF7DBuL,
      0xBF31073E4843262FuL,
      0x3F615BF0FBDD75F6uL,
      0xBF032668F6EE96B2uL,
      0x3F4AB2BDCBD5B586uL,
      },

     {
      0x3F8921FB54442D18uL,
      0x3C21A62633145C07uL,
      0x3FF0000000000000uL,
      0xBF70C15D3E7A6D22uL,
      0xBC031AD41335B3D2uL,
      0x3FD0000000000000uL,
      0x3FB555FDC752E0B2uL,
      0xBF4ACF3DF3195D30uL,
      0x3F96C241FE6B7D5FuL,
      0xBF2105DD68706FD9uL,
      0x3F6157CCAEE0E30BuL,
      0xBEF320E95C86AAB5uL,
      0x3F36CC59FF7E57F3uL,
      },

     {
      0x0000000000000000uL,
      0x0000000000000000uL,
      0x3FF0000000000000uL,
      0x0000000000000000uL,
      0x0000000000000000uL,
      0x3FD0000000000000uL,
      0x3FB5555555555555uL,
      0x0000000000000000uL,
      0x3F96C16C16C4A87EuL,
      0x0000000000000000uL,
      0x3F615658C88FB22BuL,
      0x0000000000000000uL,
      0x3F45FEB9DABEDDC8uL,
      },

     {
      0xBF8921FB54442D18uL,
      0xBC21A62633145C07uL,
      0x3FF0000000000000uL,
      0x3F70C15D3E7A6D22uL,
      0x3C031AD4127D9F3EuL,
      0x3FD0000000000000uL,
      0x3FB555FDC752E0B2uL,
      0x3F4ACF3DF3195D30uL,
      0x3F96C241FE6B7D5FuL,
      0x3F2105DD68707011uL,
      0x3F6157CCAEE0E445uL,
      0x3EF320E95BE3603DuL,
      0x3F36CC59FB2A5B52uL,
      },

     {
      0xBF9921FB54442D18uL,
      0xBC31A62633145C07uL,
      0x3FF0000000000000uL,
      0x3F80C17E51DDB68FuL,
      0x3C2BCDF2CE751153uL,
      0x3FD0000000000000uL,
      0x3FB557F729AA69CBuL,
      0x3F5AD039FA1B06A9uL,
      0x3F96C4C3D80DF7DBuL,
      0x3F31073E4843262EuL,
      0x3F615BF0FBDD7613uL,
      0x3F032668F6F21096uL,
      0x3F4AB2BDCBA34188uL,
      },

     {
      0xBFA2D97C7F3321D2uL,
      0xBC3A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0x3F8922902DB2AC11uL,
      0x3C23466BF9645874uL,
      0x3FD0000000000000uL,
      0x3FB55B41A17AA68CuL,
      0x3F641D6698BEFAD5uL,
      0x3F96C8F20B94D936uL,
      0x3F398E50110336D4uL,
      0x3F61630EF83C4025uL,
      0x3F0CA4CD1D548C70uL,
      0x3F2D88AA497F5A74uL,
      },

     {
      0xBFA921FB54442D18uL,
      0xBC41A62633145C07uL,
      0x3FF0000000000000uL,
      0x3F90C202A6B4B69CuL,
      0xBC232719F82E8E78uL,
      0x3FD0000000000000uL,
      0x3FB55FDD6CA81EFBuL,
      0x3F6AD42A909B3D64uL,
      0x3F96CECD466E9161uL,
      0x3F410CC300A993FBuL,
      0x3F616CF28C1A27D9uL,
      0x3F131CA1418B03D0uL,
      0xBF0575732696DF46uL,
      },

     {
      0xBFAF6A7A2955385EuL,
      0xBC460FAFBFD97309uL,
      0x3FF0000000000000uL,
      0x3F94F2FF697D458FuL,
      0x3C2D47EE0D83F132uL,
      0x3FD0000000000000uL,
      0x3FB565CAE1E73473uL,
      0x3F70C673B159CE1DuL,
      0x3F96D6567B9EC32EuL,
      0x3F455521A900DE58uL,
      0x3F6179A180C97E50uL,
      0x3F17EE9A1A1D88C1uL,
      0xBF0F289C329281E6uL,
      },

     {
      0xBFB2D97C7F3321D2uL,
      0xBC4A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0x3F99244EF50D08B4uL,
      0x3BF5D43FBF890B40uL,
      0x3FD0000000000000uL,
      0x3FB56D0A70CA2FAEuL,
      0x3F74240DEF7AA427uL,
      0x3F96DF8EE40AD931uL,
      0x3F49A0F663CD9CEEuL,
      0x3F61892DA49A0241uL,
      0x3F1CC6A5F5CAD66BuL,
      0xBF2979EF063C00F3uL,
      },

     {
      0xBFB5FDBBE9BBA775uL,
      0xBC4EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0x3F9D5601E554ACE4uL,
      0xBBF1725D944B6FF0uL,
      0x3FD0000000000000uL,
      0x3FB5759CA1D35995uL,
      0x3F7783239DE5AD22uL,
      0x3F96EA77FED69EC2uL,
      0x3F4DF0F48A9F5DD8uL,
      0x3F619B9AD4B4F72FuL,
      0x3F20D33754930861uL,
      0xBF3C5F6BDCAA4F14uL,
      },

     {
      0xBFB921FB54442D18uL,
      0xBC51A62633145C07uL,
      0x3FF0000000000000uL,
      0x3FA0C4146ECAB658uL,
      0xBC0F9274210C3E30uL,
      0x3FD0000000000000uL,
      0x3FB57F82168B23ECuL,
      0x3F7AE3F4956ED507uL,
      0x3F96F71391CF9DFEuL,
      0x3F5122E851208A88uL,
      0x3F61B0E12D5FF46BuL,
      0x3F23485E944E645FuL,
      0xBF3CE0F3BC206D6AuL,
      },

     {
      0xBFBC463ABECCB2BBuL,
      0xBC53DAEAF976E788uL,
      0x3FF0000000000000uL,
      0x3FA2DD6A44CE1394uL,
      0x3C4BFF776DAE2ACCuL,
      0x3FD0000000000000uL,
      0x3FB58ABB899A6815uL,
      0x3F7E46C0F6F92ADFuL,
      0x3F970563A9ED840FuL,
      0x3F53502047076AB6uL,
      0x3F61C8E9B000D225uL,
      0x3F25C4A8BD17699AuL,
      0x3F413144A024F67FuL,
      },

     {
      0xBFBF6A7A2955385EuL,
      0xBC560FAFBFD97309uL,
      0x3FF0000000000000uL,
      0x3FA4F70ACF7EED25uL,
      0x3C36D38361835224uL,
      0x3FD0000000000000uL,
      0x3FB59749CEE8C351uL,
      0x3F80D5E49AFDF8A4uL,
      0x3F97156A9BCB4ECEuL,
      0x3F55807DE55737F9uL,
      0x3F61E42327935766uL,
      0x3F28440F1D62D6E1uL,
      0xBF29FA20436AFB73uL,
      },

     {
      0xBFC1475CC9EEDF01uL,
      0x3C63DDC5BCE200BBuL,
      0x3FF0000000000000uL,
      0x3FA710FE6F2ADA79uL,
      0xBC47FCD1AF1E5F81uL,
      0x3FD0000000000000uL,
      0x3FB5A52DD3BF1903uL,
      0x3F8289A7118F8015uL,
      0x3F97272B048B0CB6uL,
      0x3F57B45DC9402B09uL,
      0x3F620239A251E2C5uL,
      0x3F2ACB87C598F86BuL,
      0xBF314F7BD5BDC85CuL,
      },

     {
      0xBFC2D97C7F3321D2uL,
      0xBC5A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0x3FA92B4D8A427A5EuL,
      0x3C48D0F7423D245AuL,
      0x3FD0000000000000uL,
      0x3FB5B4689EEE44C8uL,
      0x3F843EC87B78BC83uL,
      0x3F973AA7CA62B764uL,
      0x3F59EC1D907A7E71uL,
      0x3F62232304CE0BF5uL,
      0x3F2D5C019E659382uL,
      0x3F4A5742B2B8EFA5uL,
      },

     {
      0xBFC46B9C347764A4uL,
      0x3C61A900F67F753AuL,
      0x3FF0000000000000uL,
      0x3FAB46008DFA625DuL,
      0xBC1CFC712619CB40uL,
      0x3FD0000000000000uL,
      0x3FB5C4FB50FA0748uL,
      0x3F85F569AE5EF4C9uL,
      0x3F974FE41D60092FuL,
      0x3F5C281BF4A7A8E8uL,
      0x3F62476FB617789EuL,
      0x3F2FF1DE9AA127B2uL,
      0xBF3D841C7EAC9D16uL,
      },

     {
      0xBFC5FDBBE9BBA775uL,
      0xBC5EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0x3FAD611FEEED2925uL,
      0x3C2C094544F32A78uL,
      0x3FD0000000000000uL,
      0x3FB5D6E7244839E4uL,
      0x3F87ADABBEBF7F7FuL,
      0x3F9766E378A69DCAuL,
      0x3F5E68B8DEC46BCDuL,
      0x3F626E6BF47FF315uL,
      0x3F3149F4C32A0685uL,
      0x3F4B764BFFC07D27uL,
      },

     {
      0xBFC78FDB9EFFEA47uL,
      0x3C5EE8786039D373uL,
      0x3FF0000000000000uL,
      0x3FAF7CB429BEA72CuL,
      0x3C3FFC35F277313AuL,
      0x3FD0000000000000uL,
      0x3FB5EA2D6D5456CAuL,
      0x3F8967B0057BF87EuL,
      0x3F977FA9A2ED4D75uL,
      0x3F60572AC7A74374uL,
      0x3F6298E78AA42A95uL,
      0x3F329E8594822508uL,
      0xBF37DBAE822657B7uL,
      },

     {
      0xBFC921FB54442D18uL,
      0xBC61A62633145C07uL,
      0x3FF0000000000000uL,
      0x3FB0CC62E1E04467uL,
      0x3C47805D7AE2BD94uL,
      0x3FD0000000000000uL,
      0x3FB5FECF9AE763EAuL,
      0x3F8B23982579F8E5uL,
      0x3F979A3AB01644F9uL,
      0x3F617CAA57838224uL,
      0x3F62C658DCA7F4F9uL,
      0x3F33F9251280A70AuL,
      0xBF2D5C4E19969DC6uL,
      },

     {
      0xBFCAB41B09886FEAuL,
      0x3C5A7EEED374BC71uL,
      0x3FF0000000000000uL,
      0x3FB1DAAEA5CC26DDuL,
      0xBC51577CBB7A50E2uL,
      0x3FD0000000000000uL,
      0x3FB614CF365450F4uL,
      0x3F8CE1861157F322uL,
      0x3F97B69B01FB3B26uL,
      0x3F62A50D3A3C528BuL,
      0x3F62F6E9071D40ACuL,
      0x3F3559C86E0B8558uL,
      0x3F41AFC8FF3AAA17uL,
      },

     {
      0xBFCC463ABECCB2BBuL,
      0xBC63DAEAF976E788uL,
      0x3FF0000000000000uL,
      0x3FB2E941ACF368E6uL,
      0xBC28FF4CA630E010uL,
      0x3FD0000000000000uL,
      0x3FB62C2DE3B8D982uL,
      0x3F8EA19C1138E963uL,
      0x3F97D4CF49C89DB5uL,
      0x3F63D0865FBE1BACuL,
      0x3F632AE80D59D97FuL,
      0x3F36C01A5963B73CuL,
      0x3F2F2207CB99A5D3uL,
      },

     {
      0xBFCDD85A7410F58DuL,
      0x3C56156546AFA570uL,
      0x3FF0000000000000uL,
      0x3FB3F82048F8BE00uL,
      0x3C4AFD1EBA1D1ABAuL,
      0x3FD0000000000000uL,
      0x3FB644ED6242FE19uL,
      0x3F9031FE64545C32uL,
      0x3F97F4DC89754A8CuL,
      0x3F64FF499B056453uL,
      0x3F636226CB0F9266uL,
      0x3F382D35D58677E8uL,
      0x3F3E29EBBF1CE01EuL,
      },

     {
      0xBFCF6A7A2955385EuL,
      0xBC660FAFBFD97309uL,
      0x3FF0000000000000uL,
      0x3FB5074ED126983EuL,
      0xBC516E0EB4132866uL,
      0x3FD0000000000000uL,
      0x3FB65F0F8C7B2809uL,
      0x3F9114659E4D5E41uL,
      0x3F9816C815084CDAuL,
      0x3F66318BB353364DuL,
      0x3F639CED9C49E72FuL,
      0x3F39A0F6E4942078uL,
      0xBF2EBBDA5B521AEEuL,
      },

     {
      0xBFD07E4CEF4CBD98uL,
      0x3C51ABDBB9EA8E6EuL,
      0x3FF0000000000000uL,
      0x3FB616D1A2C591A8uL,
      0xBC2EF832FD938898uL,
      0x3FD0000000000000uL,
      0x3FB67A9658930D84uL,
      0x3F91F8156CC25284uL,
      0x3F983A9794563574uL,
      0x3F67678272C8ECDDuL,
      0x3F63DAE696E3A33FuL,
      0x3F3B1CDBB342F07AuL,
      0x3F49E00A3BCC8A23uL,
      },

     {
      0xBFD1475CC9EEDF01uL,
      0x3C73DDC5BCE200BBuL,
      0x3FF0000000000000uL,
      0x3FB726AD2173D50EuL,
      0x3C1FCEC90C8C4150uL,
      0x3FD0000000000000uL,
      0x3FB69783D8B96CDFuL,
      0x3F92DD1FBCCBA937uL,
      0x3F986051045C3883uL,
      0x3F68A164B9409BD2uL,
      0x3F641CB77D330FDAuL,
      0x3F3C9FE910D9C9B2uL,
      0xBF302CCA991EA2A4uL,
      },

     {
      0xBFD2106CA4910069uL,
      0xBC7CAF6B74B6A225uL,
      0x3FF0000000000000uL,
      0x3FB836E5B77D959AuL,
      0x3C51BDCEFF692111uL,
      0x3FD0000000000000uL,
      0x3FB6B5DA3B72B738uL,
      0x3F93C396B58BD74AuL,
      0x3F9887FAB9649830uL,
      0x3F69DF6A8A7C820CuL,
      0x3F6461D201176179uL,
      0x3F3E2C1220D981B3uL,
      0x3F49F3B20F57CFA8uL,
      },

     {
      0xBFD2D97C7F3321D2uL,
      0xBC6A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0x3FB9477FD636A4D8uL,
      0xBC5063C8B22C4544uL,
      0x3FD0000000000000uL,
      0x3FB6D59BCBF6C48BuL,
      0x3F94AB8CBB6CBB16uL,
      0x3F98B19B6070D56DuL,
      0x3F6B21CD22DB24B2uL,
      0x3F64AAE4575F07F6uL,
      0x3F3FC08B3806F34CuL,
      0xBF00E42769BBA67AuL,
      },

     {
      0xBFD3A28C59D5433BuL,
      0x3C41B19140C0C0D5uL,
      0x3FF0000000000000uL,
      0x3FBA587FF6553726uL,
      0xBC5559CFE8367078uL,
      0x3FD0000000000000uL,
      0x3FB6F6CAF293AC7FuL,
      0x3F959514736F007FuL,
      0x3F98DD3A019E14EBuL,
      0x3F6C68C706B3D0FBuL,
      0x3F64F779DB6C50B2uL,
      0x3F40AF7CD7497CB8uL,
      0x3F4AD3B9828EFAF2uL,
      },

     {
      0xBFD46B9C347764A4uL,
      0x3C71A900F67F753AuL,
      0x3FF0000000000000uL,
      0x3FBB69EA984DE6EFuL,
      0xBC573CB7437F11CAuL,
      0x3FD0000000000000uL,
      0x3FB7196A3515E12EuL,
      0x3F968040C68C8FE8uL,
      0x3F990ADE01D185E6uL,
      0x3F6DB49417B3E65CuL,
      0x3F6548393E856C2FuL,
      0x3F418353F7828212uL,
      0xBF36489E043C6801uL,
      },

     {
      0xBFD534AC0F19860CuL,
      0xBC7EE4303B192DA6uL,
      0x3FF0000000000000uL,
      0x3FBC7BC444B10758uL,
      0xBC511540B2269343uL,
      0x3FD0000000000000uL,
      0x3FB73D7C3735AA80uL,
      0x3F976D24E52F1F79uL,
      0x3F993A8F25560FF4uL,
      0x3F6F0571A586F6F3uL,
      0x3F659C8E8181F3A3uL,
      0x3F425CCABE1034F4uL,
      0x3F4D59CA0F6FD35DuL,
      },

     {
      0xBFD5FDBBE9BBA775uL,
      0xBC6EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0x3FBD8E118C89577FuL,
      0x3C3344F06C36B16CuL,
      0x3FD0000000000000uL,
      0x3FB76303BB0A22C5uL,
      0x3F985BD44ABC0416uL,
      0x3F996C5591BA6DFAuL,
      0x3F702DCF4265B5B3uL,
      0x3F65F52766DBD111uL,
      0x3F433B879649EF12uL,
      0x3F47C67A938B39B9uL,
      },

     {
      0xBFD6C6CBC45DC8DEuL,
      0x3BB6D61B58C99C43uL,
      0x3FF0000000000000uL,
      0x3FBEA0D709BC27CAuL,
      0x3C48928D103E8AACuL,
      0x3FD0000000000000uL,
      0x3FB78A03A181D6ACuL,
      0x3F994C62C1366C88uL,
      0x3F99A039D09A41ADuL,
      0x3F70DBAD90C6529AuL,
      0x3F66520A2F7F46B3uL,
      0x3F441FF58F223B31uL,
      0xBF357CCF19FA9D15uL,
      },

     {
      0xBFD78FDB9EFFEA47uL,
      0x3C6EE8786039D373uL,
      0x3FF0000000000000uL,
      0x3FBFB4195F6B0333uL,
      0x3C47DB89E2705528uL,
      0x3FD0000000000000uL,
      0x3FB7B27EEAE12CDBuL,
      0x3F9A3EE464F938D9uL,
      0x3F99D644D21E7AE8uL,
      0x3F718C74CAAA7BA1uL,
      0x3F66B2F778B94D1CuL,
      0x3F450AB96EF7371CuL,
      0x3F1412EF7B7239D9uL,
      },

     {
      0xBFD858EB79A20BB0uL,
      0x3C7EE70AFE8446D9uL,
      0x3FF0000000000000uL,
      0x3FC063EE9D2B777CuL,
      0x3C4E1787D8B79264uL,
      0x3FD0000000000000uL,
      0x3FB7DC78B746BB2FuL,
      0x3F9B336DA889AC7DuL,
      0x3F9A0E7FEF8737D6uL,
      0x3F724046DF328844uL,
      0x3F67185639AB9983uL,
      0x3F45FBD25ACB3A74uL,
      0x3F0E765A126439F7uL,
      },

     {
      0xBFD921FB54442D18uL,
      0xBC71A62633145C07uL,
      0x3FF0000000000000uL,
      0x3FC0EE13A8A2A9C6uL,
      0xBC5830A63DDC366CuL,
      0x3FD0000000000000uL,
      0x3FB807F44735B1A4uL,
      0x3F9C2A135884458AuL,
      0x3F9A48F4EE376E9DuL,
      0x3F72F746AAC73A47uL,
      0x3F678215824701AFuL,
      0x3F46F3C719FB66E6uL,
      0x3F4BA88D5ED09DD1uL,
      },

     {
      0xBFD9EB0B2EE64E81uL,
      0xBC419ABB2567F739uL,
      0x3FF0000000000000uL,
      0x3FC1787E32B35112uL,
      0xBC5D2D85EBE7CAE6uL,
      0x3FD0000000000000uL,
      0x3FB834F4FC268515uL,
      0x3F9D22EA9FA50E7DuL,
      0x3F9A85AE02819BA3uL,
      0x3F73B19803AB2B21uL,
      0x3F67F0B8C640461DuL,
      0x3F47F293167B409BuL,
      0xBF198BF45EA16C3AuL,
      },

     {
      0xBFDAB41B09886FEAuL,
      0x3C6A7EEED374BC71uL,
      0x3FF0000000000000uL,
      0x3FC20330A15F6568uL,
      0x3C61BB4F210EA8D1uL,
      0x3FD0000000000000uL,
      0x3FB8637E591E05FEuL,
      0x3F9E1E090AECCE81uL,
      0x3F9AC4B5D3090946uL,
      0x3F746F5FC5C316BAuL,
      0x3F686400E51F53C2uL,
      0x3F48F8EADC3DB9C7uL,
      0xBF320AB3DF7578B7uL,
      },

     {
      0xBFDB7D2AE42A9153uL,
      0x3C7CB2463821BB58uL,
      0x3FF0000000000000uL,
      0x3FC28E2D6047CBC8uL,
      0xBC0CEAB2537F4380uL,
      0x3FD0000000000000uL,
      0x3FB89394034B11CFuL,
      0x3F9F1B848DE48876uL,
      0x3F9B06177BDD3821uL,
      0x3F7530C3E0150AA0uL,
      0x3F68DBF62FBA70A3uL,
      0x3F4A0736C860B4FEuL,
      0x3F50A3F1D969C867uL,
      },

     {
      0xBFDC463ABECCB2BBuL,
      0xBC73DAEAF976E788uL,
      0x3FF0000000000000uL,
      0x3FC31976E0E280B3uL,
      0xBC667516EE4F2544uL,
      0x3FD0000000000000uL,
      0x3FB8C539C2AB0F89uL,
      0x3FA00DB9C3806462uL,
      0x3F9B49DE91DB8E44uL,
      0x3F75F5EB6258C838uL,
      0x3F695952C6BEE632uL,
      0x3F4B1D691B1E9E68uL,
      0xBEFC71567DD0AC40uL,
      },

     {
      0xBFDD0F4A996ED424uL,
      0xBC51A070AC3E29A0uL,
      0x3FF0000000000000uL,
      0x3FC3A50F9AB1CA91uL,
      0x3C50CA3B48D90906uL,
      0x3FD0000000000000uL,
      0x3FB8F87382B56ACBuL,
      0x3FA08EF662132882uL,
      0x3F9B901726A3CD1CuL,
      0x3F76BEFE8A4461A2uL,
      0x3F69DBAE42D8A424uL,
      0x3F4C3C52357BEFDCuL,
      0x3F32456D9E4ECEE8uL,
      },

     {
      0xBFDDD85A7410F58DuL,
      0x3C66156546AFA570uL,
      0x3FF0000000000000uL,
      0x3FC430FA0B7C7F15uL,
      0x3C63115D3C69C8ABuL,
      0x3FD0000000000000uL,
      0x3FB92D45530E4319uL,
      0x3FA11183C3A8DFF6uL,
      0x3F9BD8CDCC073185uL,
      0x3F778C26D2F52E9AuL,
      0x3F6A638650FB67B4uL,
      0x3F4D6420527BDA5CuL,
      0xBF2DA5A647B98994uL,
      },

     {
      0xBFDEA16A4EB316F6uL,
      0x3C7A7D8171BF2FD8uL,
      0x3FF0000000000000uL,
      0x3FC4BD38B7876716uL,
      0x3C5504069A91A838uL,
      0x3FD0000000000000uL,
      0x3FB963B368408780uL,
      0x3FA1956DC5B1F35AuL,
      0x3F9C240F984C07DCuL,
      0x3F785D8F0388F11CuL,
      0x3F6AF0B073DF1CB2uL,
      0x3F4E9580D70D3533uL,
      0x3F4571315C6E8041uL,
      },

     {
      0xBFDF6A7A2955385EuL,
      0xBC760FAFBFD97309uL,
      0x3FF0000000000000uL,
      0x3FC549CE29CFCCBEuL,
      0xBC69881846E0BF86uL,
      0x3FD0000000000000uL,
      0x3FB99BC21C7FB9B2uL,
      0x3FA21AC0848A46C5uL,
      0x3F9C71EA2A16819DuL,
      0x3F7933633F8F0072uL,
      0x3F6B83D1C5509A03uL,
      0x3F4FD088727B14B9uL,
      0xBF2306C949D5376CuL,
      },

     {
      0xBFE019C501FBACE4uL,
      0x3C8CB18F8746F50CuL,
      0x3FF0000000000000uL,
      0x3FC5D6BCF447403EuL,
      0xBC6C6C662876B393uL,
      0x3FD0000000000000uL,
      0x3FB9D575F071964AuL,
      0x3FA2A1885E06BEACuL,
      0x3F9CC26BAD1B38B8uL,
      0x3F7A0DD116DA5229uL,
      0x3F6C1C921E809C74uL,
      0x3F508B03CEF8B0C3uL,
      0x3F4BCE57D088C848uL,
      },

     {
      0xBFE07E4CEF4CBD98uL,
      0x3C61ABDBB9EA8E6EuL,
      0x3FF0000000000000uL,
      0x3FC66407B0109FA6uL,
      0x3C55C3EC26D04666uL,
      0x3FD0000000000000uL,
      0x3FBA10D38BFFE319uL,
      0x3FA329D1F417DBD6uL,
      0x3F9D15A2DE544C7CuL,
      0x3F7AED07977D3236uL,
      0x3F6CBBAD3C53FDE7uL,
      0x3F513318B342B49DuL,
      0x3F1AF93D0FFB8A50uL,
      },

     {
      0xBFE0E2D4DC9DCE4CuL,
      0xBC83DBA1AA51ADD5uL,
      0x3FF0000000000000uL,
      0x3FC6F1B0FDBE6EDEuL,
      0x3C614F63025E35DCuL,
      0x3FD0000000000000uL,
      0x3FBA4DDFBF32A727uL,
      0x3FA3B3AA2F826E47uL,
      0x3F9D6B9F112A3CA9uL,
      0x3F7BD1375F2B326EuL,
      0x3F6D60EF002A5959uL,
      0x3F51E0E0E3E641DEuL,
      0x3F32BFA3B8923D31uL,
      },

     {
      0xBFE1475CC9EEDF01uL,
      0x3C83DDC5BCE200BBuL,
      0x3FF0000000000000uL,
      0x3FC77FBB85928D2DuL,
      0xBC6121F4E1AC8166uL,
      0x3FD0000000000000uL,
      0x3FBA8C9F83131391uL,
      0x3FA43F1E42AF6970uL,
      0x3F9DC4703433CA75uL,
      0x3F7CBA92AE7FE396uL,
      0x3F6E0CB6D0475CCFuL,
      0x3F529491FB8790D2uL,
      0x3F37152AFD195A10uL,
      },

     {
      0xBFE1ABE4B73FEFB5uL,
      0xBC61A34B6FA942D3uL,
      0x3FF0000000000000uL,
      0x3FC80E29F7BF5633uL,
      0x3C67F8F06ACC7061uL,
      0x3FD0000000000000uL,
      0x3FBACD17FA976786uL,
      0x3FA4CC3BAC93F075uL,
      0x3F9E2026D6967836uL,
      0x3F7DA94D7C694B78uL,
      0x3F6EBF4F14B98A92uL,
      0x3F534E7211F873CEuL,
      0xBF2290D13622948AuL,
      },

     {
      0xBFE2106CA4910069uL,
      0xBC8CAF6B74B6A225uL,
      0x3FF0000000000000uL,
      0x3FC89CFF0CAA3CB4uL,
      0xBC6A8D50D06FC283uL,
      0x3FD0000000000000uL,
      0x3FBB0F4E73981D4BuL,
      0x3FA55B103BB2BD6DuL,
      0x3F9E7ED42D91EC8DuL,
      0x3F7E9D9D8AAE7B14uL,
      0x3F6F78B5039EFAD8uL,
      0x3F540EDBA3A78643uL,
      0x3F3AA2CB5E5BE1EDuL,
      },

     {
      0xBFE274F491E2111EuL,
      0x3C7613F7E4FA18D6uL,
      0x3FF0000000000000uL,
      0x3FC92C3D852FEDF2uL,
      0x3C20F5E7403E5E20uL,
      0x3FD0000000000000uL,
      0x3FBB534867CEB1CBuL,
      0x3FA5EBAA113813D4uL,
      0x3F9EE08A1A202CC5uL,
      0x3F7F97BA7BA1301AuL,
      0x3F701CAD7F191DFAuL,
      0x3F54D60D13221310uL,
      0x3F45F5FE99894FC6uL,
      },

     {
      0xBFE2D97C7F3321D2uL,
      0xBC7A79394C9E8A0AuL,
      0x3FF0000000000000uL,
      0x3FC9BBE82AEA0D12uL,
      0xBC62D116CA77096BuL,
      0x3FD0000000000000uL,
      0x3FBB990B7DDE5BFCuL,
      0x3FA67E17A4317C6CuL,
      0x3F9F455B2F170454uL,
      0x3F804BEEF437A2B3uL,
      0x3F7080CEADF2976DuL,
      0x3F55A44E3A71E919uL,
      0xBF039F946FDF9BBBuL,
      },

     {
      0xBFE33E046C843287uL,
      0x3C8A7CCAC0E4698BuL,
      0x3FF0000000000000uL,
      0x3FCA4C01D0769648uL,
      0x3C4DDC96CAE4A06CuL,
      0x3FD0000000000000uL,
      0x3FBBE09D8A670D72uL,
      0x3FA71267C4E29753uL,
      0x3F9FAD5AB78BB764uL,
      0x3F80CF21BC414F68uL,
      0x3F70E8AC1DCF4352uL,
      0x3F567A14C053085FuL,
      0x3F4F621D6DE176C4uL,
      },

     {
      0xBFE3A28C59D5433BuL,
      0x3C51B19140C0C0D5uL,
      0x3FF0000000000000uL,
      0x3FCADC8D51C0FA5BuL,
      0x3C54B350B5D39570uL,
      0x3FD0000000000000uL,
      0x3FBC2A04912319A8uL,
      0x3FA7A8A9A038608EuL,
      0x3FA00C4E5E972915uL,
      0x3F8155947D4C5C83uL,
      0x3F7154A7B149DA58uL,
      0x3F5757960EDFC45CuL,
      0x3F3F895706E3352BuL,
      },

     {
      0xBFE40714472653EFuL,
      0xBC86106670B43955uL,
      0x3FF0000000000000uL,
      0x3FCB6D8D944D0371uL,
      0xBC6CDD9D6EA4BA41uL,
      0x3FD0000000000000uL,
      0x3FBC7546C60FE5C7uL,
      0x3FA840ECC35C53FDuL,
      0x3FA0439B07C380F3uL,
      0x3F81DF673F038AB5uL,
      0x3F71C4B3C36B8A12uL,
      0x3F583D44FA2FB203uL,
      0x3F52EE3E6132A151uL,
      },

     {
      0xBFE46B9C347764A4uL,
      0x3C81A900F67F753AuL,
      0x3FF0000000000000uL,
      0x3FCBFF05878394D3uL,
      0x3C486912F813E2ECuL,
      0x3FD0000000000000uL,
      0x3FBCC26A8EA2077FuL,
      0x3FA8DB411F68EE69uL,
      0x3FA07C9E25737218uL,
      0x3F826CBB3713A292uL,
      0x3F72392A32F26720uL,
      0x3F592B76EEB6E2FFuL,
      0x3F39BADB5780F9BEuL,
      },

     {
      0xBFE4D02421C87558uL,
      0xBC6A765E893370D7uL,
      0x3FF0000000000000uL,
      0x3FCC90F8250157F7uL,
      0x3C657D8312BFEA17uL,
      0x3FD0000000000000uL,
      0x3FBD117683053E13uL,
      0x3FA977B70D411C29uL,
      0x3FA0B762F022F359uL,
      0x3F82FDB2D7324A8FuL,
      0x3F72B2030A36AADFuL,
      0x3F5A22A22953FC15uL,
      0x3F473A2F09CE8F95uL,
      },

     {
      0xBFE534AC0F19860CuL,
      0xBC8EE4303B192DA6uL,
      0x3FF0000000000000uL,
      0x3FCD236870E769B5uL,
      0x3C523CE78218C6AAuL,
      0x3FD0000000000000uL,
      0x3FBD62716F68B5FEuL,
      0x3FAA165F518C38ABuL,
      0x3FA0F3F50E789484uL,
      0x3F839271DC18DB75uL,
      0x3F732F8BAC4C54A8uL,
      0x3F5B23248F865B74uL,
      0x3F36E307E2B0837CuL,
      },

     {
      0xBFE59933FC6A96C1uL,
      0x3C71AA6E583501D4uL,
      0x3FF0000000000000uL,
      0x3FCDB6597A2E1B61uL,
      0xBC6CB71A947AACF6uL,
      0x3FD0000000000000uL,
      0x3FBDB56255580CA4uL,
      0x3FAAB74B20D856E7uL,
      0x3FA1326099896038uL,
      0x3F842B1D5CF84F74uL,
      0x3F73B1CC2C4E32D2uL,
      0x3F5C2D7D75B7FC1BuL,
      0x3F53DB94CE2C2FD8uL,
      },

     {
      0xBFE5FDBBE9BBA775uL,
      0xBC7EE2C2D963A10CuL,
      0x3FF0000000000000uL,
      0x3FCE49CE5AF9DC29uL,
      0xBC382336F1C6BD90uL,
      0x3FD0000000000000uL,
      0x3FBE0A506D218F3CuL,
      0x3FAB5A8C23E49FEAuL,
      0x3FA172B22117D625uL,
      0x3F84C7DBDBF304B9uL,
      0x3F74391DF553E930uL,
      0x3F5D4211231EF24AuL,
      0x3F52AB1CCD8D3AA9uL,
      },

     {
      0xBFE66243D70CB82AuL,
      0x3C884805FA81DE0AuL,
      0x3FF0000000000000uL,
      0x3FCEDDCA38F25FECuL,
      0xBC65AACB9E8B4DF8uL,
      0x3FD0000000000000uL,
      0x3FBE6143274A35BFuL,
      0x3FAC00347C15ABB2uL,
      0x3FA1B4F6B03A62C8uL,
      0x3F8568D557225239uL,
      0x3F74C5A8346B0155uL,
      0x3F5E61680C7E386AuL,
      0x3F45A81E03899535uL,
      },

     {
      0xBFE6C6CBC45DC8DEuL,
      0x3BC6D61B58C99C43uL,
      0x3FF0000000000000uL,
      0x3FCF7250459C1976uL,
      0x3C40B5B081F06BA0uL,
      0x3FD0000000000000uL,
      0x3FBEBA422E0FE0E5uL,
      0x3FACA856C815D042uL,
      0x3FA1F93BD218DCE9uL,
      0x3F860E335AB42933uL,
      0x3F75578EEA5D18D8uL,
      0x3F5F8BFBAD564E86uL,
      0x3F434A80D1DA21D1uL,
      },

     {
      0xBFE72B53B1AED992uL,
      0xBC88452B3716C4D6uL,
      0x3FF0000000000000uL,
      0x3FD003B1DF5A0F86uL,
      0x3C716CEB71FB716BuL,
      0x3FD0000000000000uL,
      0x3FBF155566FA6884uL,
      0x3FAD530628A37C7AuL,
      0x3FA23F8F96E80A99uL,
      0x3F86B82113BDC04EuL,
      0x3F75EF0B9C9DF1C6uL,
      0x3F60613421CB6A80uL,
      0x3F48E48E906FE806uL,
      },

     {
      0xBFE78FDB9EFFEA47uL,
      0x3C7EE8786039D373uL,
      0x3FF0000000000000uL,
      0x3FD04E83F7474877uL,
      0x3C73B117AC20AC65uL,
      0x3FD0000000000000uL,
      0x3FBF7284F47C0E61uL,
      0x3FAE0056458FCED5uL,
      0x3FA28800992AEEE6uL,
      0x3F8766CB6439B11DuL,
      0x3F768C54DBB36839uL,
      0x3F610297B13942C6uL,
      0x3F5536BD1C4BF79EuL,
      },

     {
      0xBFE7F4638C50FAFBuL,
      0xBC71A4B8D15ECF6DuL,
      0x3FF0000000000000uL,
      0x3FD099A0163BCD3FuL,
      0x3C7A7F11D963D72EuL,
      0x3FD0000000000000uL,
      0x3FBFD1D937A1F094uL,
      0x3FAEB05B52EFB4C0uL,
      0x3FA2D29E032A57DBuL,
      0x3F881A60F7D38723uL,
      0x3F772FBBF1BFA28BuL,
      0x3F61AA745B27BB01uL,
      0x3F51CC19136F91C1uL,
      },

     {
      0xBFE858EB79A20BB0uL,
      0x3C8EE70AFE8446D9uL,
      0x3FF0000000000000uL,
      0x3FD0E507EE8B93D7uL,
      0x3C679F09CDD5D5B2uL,
      0x3FE0000000000000uL,
      0xBFBFCCA52E2AE201uL,
      0x3FAF632A1681FD0BuL,
      0x3FA31F7794BDF922uL,
      0x3F88D31259E30525uL,
      0x3F77D97B728544F5uL,
      0x3F62591A3A2B699FuL,
      0x3F3605B387A5D7A0uL,
      },

     {
      0xBFE8BD7366F31C64uL,
      0x3C6A81C996DFD5A5uL,
      0x3FF0000000000000uL,
      0x3FD130BD396BB4A9uL,
      0xBC657D8592EA09D4uL,
      0x3FE0000000000000uL,
      0xBFBF68ED595308D6uL,
      0x3FB00C6BF6A673E6uL,
      0x3FA36E9DA9556AA6uL,
      0x3F8991120C7D4BB9uL,
      0x3F7889ABD6008215uL,
      0x3F630EE404688883uL,
      0x3F52CAD75A2201AFuL,
      },

     {
      0xBFE921FB54442D18uL,
      0xBC81A62633145C07uL,
      0x0000000000000000uL,
      0xBFF0000000000000uL,
      0x3C0492B176DF0500uL,
      0x4000000000000000uL,
      0x0000000000000000uL,
      0xC00000000000010AuL,
      0x4005555555555614uL,
      0xC00AAAAAA890EF4DuL,
      0x4011111110018C73uL,
      0xC015B108FB920A0BuL,
      0x401BA285D6669571uL,
      },

     {
      0xBFE9868341953DCDuL,
      0x3C861341341F5289uL,
      0x0000000000000000uL,
      0xBFEF395D9F0E3C92uL,
      0x3C550BEC65726E28uL,
      0x4000000000000000uL,
      0xBFA8873C53BE0540uL,
      0xBFFE79E5C65202DEuL,
      0x400412FD76797C7DuL,
      0xC008AAB30DC82D37uL,
      0x400F1B6C68B4AEA4uL,
      0xC013758CE9BD9EFAuL,
      0x40186872A0685915uL,
      },

     {
      0xBFE9EB0B2EE64E81uL,
      0xBC519ABB2567F739uL,
      0x0000000000000000uL,
      0xBFEE776EAFC91706uL,
      0xBC890664EDC53F33uL,
      0x4000000000000000uL,
      0xBFB7F295AD658764uL,
      0xBFFD0AA1DB7F5E58uL,
      0x4002E8A6F9693556uL,
      0xC006D7CA16B298C6uL,
      0x400C63DFCAA3FB6CuL,
      0xC0117C3EE50D7742uL,
      0x401599932C96B9B6uL,
      },

     {
      0xBFEA4F931C375F35uL,
      0xBC8A79EFFD795057uL,
      0x0000000000000000uL,
      0xBFEDB9FA89953FCFuL,
      0xBC286C68F514A640uL,
      0x4000000000000000uL,
      0xBFC18AC418849A6EuL,
      0xBFFBB083E02786D7uL,
      0x4001D438F8A20402uL,
      0xC0052D5D6FF7A4BDuL,
      0x4009F262067BAA5AuL,
      0xC00F793DA8608BEDuL,
      0x401328BFC5F60A29uL,
      },

     {
      0xBFEAB41B09886FEAuL,
      0x3C7A7EEED374BC71uL,
      0x0000000000000000uL,
      0xBFED00CBC7384D2EuL,
      0xBC78C4FC635B4060uL,
      0x4000000000000000uL,
      0xBFC6DA3A87611EA6uL,
      0xBFFA6A00F50D3A6FuL,
      0x4000D3D0A6ABBD46uL,
      0xC003A760672280D0uL,
      0x4007BF026C103550uL,
      0xC00C5EBD23F4E2EDuL,
      0x4011024DB786758BuL,
      },

     {
      0xBFEB18A2F6D9809EuL,
      0xBC760E425E23E66FuL,
      0x0000000000000000uL,
      0xBFEC4BB009E77983uL,
      0x3C5346B6895BC358uL,
      0x4000000000000000uL,
      0xBFCBEB63A6D04570uL,
      0xBFF935AFFA8DCC1DuL,
      0x3FFFCB7657D15F0BuL,
      0xC002423AFCE75F54uL,
      0x4005C2CF61AD4B89uL,
      0xC0099C675A298F5CuL,
      0x400E49F38B657F96uL,
      },

     {
      0xBFEB7D2AE42A9153uL,
      0x3C8CB2463821BB58uL,
      0x0000000000000000uL,
      0xBFEB9A77C18C1AF2uL,
      0xBC76EA194A3A10DEuL,
      0x4000000000000000uL,
      0xBFD060D88DF903DFuL,
      0xBFF812463C417D93uL,
      0x3FFE10E093E6DE8DuL,
      0xC000FABB50DD022EuL,
      0x4003F7B45B053F77uL,
      0xC007275FB67DBBDDuL,
      0x400B02CB76CD2071uL,
      },

     {
      0xBFEBE1B2D17BA207uL,
      0x3C61AEB67D55A7A1uL,
      0x0000000000000000uL,
      0xBFEAECF5F9BA35A6uL,
      0xBC45350833FF1F00uL,
      0x4000000000000000uL,
      0xBFD2B02B2D565D55uL,
      0xBFF6FE947B408BACuL,
      0x3FFC751B52A83938uL,
      0xBFFF9C12181CFBBAuL,
      0x4002585B4421C074uL,
      0xC004F6412119DA02uL,
      0x400814BACED70A9AuL,
      },

     {
      0xBFEC463ABECCB2BBuL,
      0xBC83DAEAF976E788uL,
      0x0000000000000000uL,
      0xBFEA43002AE42850uL,
      0x3C7A7C0406DA50C8uL,
      0x4000000000000000uL,
      0xBFD4E526E33345B8uL,
      0xBFF5F9844B626284uL,
      0x3FFAF5A574C2F3BFuL,
      0xBFFD7334FD198D13uL,
      0x4000E01251879DC7uL,
      0xC00300E6F5213CD0uL,
      0x40058BA67D3A0565uL,
      },

     {
      0xBFECAAC2AC1DC370uL,
      0x3C83DE7C6DBCC708uL,
      0x0000000000000000uL,
      0xBFE99C6E0F634394uL,
      0xBC81A125C4B050B6uL,
      0x4000000000000000uL,
      0xBFD7012EAAC8A987uL,
      0xBFF50215B95FD940uL,
      0x3FF9903A2B193F49uL,
      0xBFFB7656607D37C1uL,
      0x3FFF156F461C0EDFuL,
      0xC001403E48F27428uL,
      0x40034ACD8D387876uL,
      },

     {
      0xBFED0F4A996ED424uL,
      0xBC61A070AC3E29A0uL,
      0x0000000000000000uL,
      0xBFE8F9197BF85EEBuL,
      0x3C77971D70636FACuL,
      0x4000000000000000uL,
      0xBFD9058D62BBB98DuL,
      0xBFF4175D31199B0CuL,
      0x3FF842CA948070CEuL,
      0xBFF9A1675E6F2233uL,
      0x3FFCA94A75D1DF36uL,
      0xBFFF5C3EE98CB792uL,
      0x4001549BBD776205uL,
      },

     {
      0xBFED73D286BFE4D8uL,
      0xBC8CAEB4C3DBDBD8uL,
      0x0000000000000000uL,
      0xBFE858DE3B716571uL,
      0xBC8C6340D74E9430uL,
      0x4000000000000000uL,
      0xBFDAF377B50F3DE8uL,
      0xBFF338819C6A585BuL,
      0x3FF70B781BB3F9F8uL,
      0xBFF7F0C4DC952BEEuL,
      0x3FFA75444794B0BEuL,
      0xBFFC8A58AEEA1540uL,
      0x3FFF1509C3EC4766uL,
      },

     {
      0xBFEDD85A7410F58DuL,
      0x3C76156546AFA570uL,
      0x0000000000000000uL,
      0xBFE7BB99ED2990CFuL,
      0x3C8AABB12893C19FuL,
      0x4000000000000000uL,
      0xBFDCCC0DD257FE9FuL,
      0xBFF264BAB3E8C3FCuL,
      0x3FF5E88F7CC1F7BCuL,
      0xBFF6612B1AE228E1uL,
      0x3FF873A64164BF01uL,
      0xBFFA016987C44E3BuL,
      0x3FFBFCA608E3ABD2uL,
      },

     {
      0xBFEE3CE261620641uL,
      0xBC7A77CBEAE8FD71uL,
      0x0000000000000000uL,
      0xBFE7212BE621BE6DuL,
      0xBC8AD14CAC5A8A36uL,
      0x4000000000000000uL,
      0xBFDE905D04D13F70uL,
      0xBFF19B4F7BD63206uL,
      0x3FF4D8845C8EEC38uL,
      0xBFF4EFAAD70924AAuL,
      0x3FF69F610EDFA787uL,
      0xBFF7B93C8525967BuL,
      0x3FF928F491396159uL,
      },

     {
      0xBFEEA16A4EB316F6uL,
      0x3C8A7D8171BF2FD8uL,
      0x0000000000000000uL,
      0xBFE6897514751DB6uL,
      0xBC7432E085692DD0uL,
      0x3FF0000000000000uL,
      0x3FDFBE9EE099229DuL,
      0xBFF0DB94E83152C9uL,
      0x3FF3D9ED602549D9uL,
      0xBFF3999FCB35B63CuL,
      0x3FF4F3F4BB18D34DuL,
      0xBFF5AA9FE2712A98uL,
      0x3FF6B61F156D15A2uL,
      },

     {
      0xBFEF05F23C0427AAuL,
      0x3C51B746C796F33CuL,
      0x0000000000000000uL,
      0xBFE5F457E4F4812EuL,
      0xBC8F6EE06A43AD15uL,
      0x3FF0000000000000uL,
      0x3FDE1FFA33ABCB2DuL,
      0xBFF024ECA3857FDFuL,
      0x3FF2EB80B3E2C969uL,
      0xBFF25CA858ECE33EuL,
      0x3FF36D6159DB2BC3uL,
      0xBFF3CF427530AFAEuL,
      0x3FF4914D16BF30E1uL,
      },

     {
      0xBFEF6A7A2955385EuL,
      0xBC860FAFBFD97309uL,
      0x0000000000000000uL,
      0xBFE561B82AB7F990uL,
      0xBC87A5FA3E37C2A5uL,
      0x3FF0000000000000uL,
      0x3FDC92D84170BCC6uL,
      0xBFEEED87E934644CuL,
      0x3FF20C10F4D7D072uL,
      0xBFF1369E37DA5741uL,
      0x3FF20816F61AB3EEuL,
      0xBFF221953D8712FAuL,
      0x3FF29CA76CD56201uL,
      },

     {
      0xBFEFCF0216A64913uL,
      0x3C81A9B7A75A3B87uL,
      0x0000000000000000uL,
      0xBFE4D17B087B265DuL,
      0x3C788AAC4AE25B54uL,
      0x3FF0000000000000uL,
      0x3FDB166A3723839CuL,
      0xBFEDA1257F3D5E87uL,
      0x3FF13A8A70704F6BuL,
      0xBFF025900612C493uL,
      0x3FF0C0E778680DE8uL,
      0xBFF09CB2B02DFCD5uL,
      0x3FF0D681147681E0uL,
      },

     {
      0xBFF019C501FBACE4uL,
      0x3C9CB18F8746F50CuL,
      0x0000000000000000uL,
      0xBFE44386DB9CE5DBuL,
      0x3C8A7F79AD345EDEuL,
      0x3FF0000000000000uL,
      0x3FD9A9EE22E82AF2uL,
      0xBFEC63B53FACFD1BuL,
      0x3FF075F0B010F1C9uL,
      0xBFEE4F7738A37AC1uL,
      0x3FEF29F7068A6E01uL,
      0xBFEE78912F3E48A3uL,
      0x3FEE7DE5AD1A6D54uL,
      },

     {
      0xBFF04C08F8A4353EuL,
      0x3C908E433AE0CC54uL,
      0x0000000000000000uL,
      0xBFE3B7C3289ED6F3uL,
      0x3C8C4CF3D3282C13uL,
      0x3FF0000000000000uL,
      0x3FD84CAE0A06DE7CuL,
      0xBFEB344C2E4C0F47uL,
      0x3FEF7AB88F5F820CuL,
      0xBFEC771219A99E98uL,
      0x3FED0390B144EACAuL,
      0xBFEBF90A32A17514uL,
      0x3FEBAC50A2919B8CuL,
      },

     {
      0xBFF07E4CEF4CBD98uL,
      0x3C71ABDBB9EA8E6EuL,
      0x0000000000000000uL,
      0xBFE32E1889047FFDuL,
      0x3C810D08F013759CuL,
      0x3FF0000000000000uL,
      0x3FD6FDFF12A4297BuL,
      0xBFEA120FA25B9D83uL,
      0x3FEE1FF1BF27E6ABuL,
      0xBFEABF0C6E045EA0uL,
      0x3FEB0A0E2CDCAB88uL,
      0xBFE9B40D41660E9DuL,
      0x3FE92FCC1848D94BuL,
      },

     {
      0xBFF0B090E5F545F2uL,
      0xBC7EE15577AE1472uL,
      0x0000000000000000uL,
      0xBFE2A6709A74F289uL,
      0xBC76E3B98C266662uL,
      0x3FF0000000000000uL,
      0x3FD5BD40BF249496uL,
      0xBFE8FC33EFCF6F3AuL,
      0x3FECDA06E4CFC822uL,
      0xBFE924C5BA1C7515uL,
      0x3FE9395A86CEDBCBuL,
      0xBFE7A39B6931C7D4uL,
      0x3FE6D875BED7A2F5uL,
      },

     {
      0xBFF0E2D4DC9DCE4CuL,
      0xBC93DBA1AA51ADD5uL,
      0x0000000000000000uL,
      0xBFE220B5EF047825uL,
      0xBC5AE1F6C712B338uL,
      0x3FF0000000000000uL,
      0x3FD489DC399ADDECuL,
      0xBFE7F1FB2FEBE8C6uL,
      0x3FEBA791734D6CCEuL,
      0xBFE7A5DA56BAB9DAuL,
      0x3FE78DC9A17C17D7uL,
      0xBFE5C262725357AEuL,
      0x3FE4D1FE58052A5FuL,
      },

     {
      0xBFF11518D34656A6uL,
      0xBC9FFEEDF6B7D68DuL,
      0x0000000000000000uL,
      0xBFE19CD3FE8E405DuL,
      0x3C84E5C1D4831B21uL,
      0x3FF0000000000000uL,
      0x3FD36343ADCAF866uL,
      0xBFE6F2B4260FF6A8uL,
      0x3FEA8747864942E1uL,
      0xBFE6401D47362936uL,
      0x3FE6040F50A52FBEuL,
      0xBFE40BA6192CC675uL,
      0x3FE302E7DABA2D8EuL,
      },

     {
      0xBFF1475CC9EEDF01uL,
      0x3C93DDC5BCE200BBuL,
      0x0000000000000000uL,
      0xBFE11AB7190834ECuL,
      0x3C8E577A07DB8B3EuL,
      0x3FF0000000000000uL,
      0x3FD248F1B07217E3uL,
      0xBFE5FDB93DD01D06uL,
      0x3FE977F956462152uL,
      0xBFE4F192BE91E40AuL,
      0x3FE49932EEB2A51CuL,
      0xBFE27B305435DE25uL,
      0x3FE176C2BDD3411EuL,
      },

     {
      0xBFF179A0C097675BuL,
      0x3C7EE9E5C1EF600DuL,
      0x0000000000000000uL,
      0xBFE09A4C59BD0D4DuL,
      0x3C451D94A7B87B10uL,
      0x3FF0000000000000uL,
      0x3FD13A68B2A5E855uL,
      0xBFE5126F9FD8D89FuL,
      0x3FE8788EEDC53F19uL,
      0xBFE3B86B3E883B76uL,
      0x3FE34A881E7F09CAuL,
      0xBFE10D3EF07D1073uL,
      0x3FDFEBFE6A9FE5DDuL,
      },

     {
      0xBFF1ABE4B73FEFB5uL,
      0xBC71A34B6FA942D3uL,
      0x0000000000000000uL,
      0xBFE01B819B5A7CF7uL,
      0xBC80BED996FB9ED6uL,
      0x3FF0000000000000uL,
      0x3FD03732803B2A4CuL,
      0xBFE430465B55C6C0uL,
      0x3FE78806185ACF72uL,
      0xBFE292FF3DF61A34uL,
      0x3FE215A449967BC2uL,
      0xBFDF7CEF2946D3BAuL,
      0x3FDD0F4FF3CD4465uL,
      },

     {
      0xBFF1DE28ADE8780FuL,
      0xBC908C1F2850796DuL,
      0x0000000000000000uL,
      0xBFDF3C8AD985D9EEuL,
      0xBC455C31F533FF68uL,
      0x3FF0000000000000uL,
      0x3FCE7DBF907D8618uL,
      0xBFE356B5A1D9CA5AuL,
      0x3FE6A57085697F99uL,
      0xBFE17FCB46BE280BuL,
      0x3FE0F858275BAA48uL,
      0xBFDD17B47CA8A84BuL,
      0x3FDA9B369A707A6BuL,
      },

     {
      0xBFF2106CA4910069uL,
      0xBC9CAF6B74B6A225uL,
      0x0000000000000000uL,
      0xBFDE450E0D273E7AuL,
      0xBC74138BBC4225C5uL,
      0x3FF0000000000000uL,
      0x3FCCA20F5D4879EAuL,
      0xBFE2853E13FBB7C7uL,
      0x3FE5CFF21905E477uL,
      0xBFE07D6C7D0DAC66uL,
      0x3FDFE1550F550217uL,
      0xBFDAE570CE7F6BE5uL,
      0x3FD89328A3AB7677uL,
      },

     {
      0xBFF242B09B3988C4uL,
      0x3C972D483EE33523uL,
      0x0000000000000000uL,
      0xBFDD506C82A2C800uL,
      0xBC6E169413DFE956uL,
      0x3FF0000000000000uL,
      0x3FCADA8ECCC42C48uL,
      0xBFE1BB681D0BE8A7uL,
      0x3FE506BF662527D3uL,
      0xBFDF153B07CB2306uL,
      0x3FDDF9A636394DCAuL,
      0xBFD8E153A4A7867FuL,
      0x3FD6937B37976C23uL,
      },

     {
      0xBFF274F491E2111EuL,
      0x3C8613F7E4FA18D6uL,
      0x0000000000000000uL,
      0xBFDC5E87185E67B6uL,
      0xBC4FEBA1F148ADA8uL,
      0x3FF0000000000000uL,
      0x3FC92683A68EB5D0uL,
      0xBFE0F8C35C7247C7uL,
      0x3FE4491C4DCA262EuL,
      0xBFDD4C67683395D6uL,
      0x3FDC3667C15EBF92uL,
      0xBFD7070B7FE443D3uL,
      0x3FD4805841790B6EuL,
      },

     {
      0xBFF2A738888A9978uL,
      0xBC5195059E91C4D2uL,
      0x0000000000000000uL,
      0xBFDB6F3FC8C61E5BuL,
      0x3C6A1CC48268287AuL,
      0x3FF0000000000000uL,
      0x3FC7853E65CE5524uL,
      0xBFE03CE61B6A9E63uL,
      0x3FE3965ABF5C8FABuL,
      0xBFDB9E3938F261E9uL,
      0x3FDA94A771ED6FE5uL,
      0xBFD552B7D4636646uL,
      0x3FD2F58F20A0FA49uL,
      },

     {
      0xBFF2D97C7F3321D2uL,
      0xBC8A79394C9E8A0AuL,
      0x0000000000000000uL,
      0xBFDA827999FCEF32uL,
      0xBC708A11019E41CEuL,
      0x3FF0000000000000uL,
      0x3FC5F619980C4336uL,
      0xBFDF0ED99BED9B65uL,
      0x3FE2EDD996C1BBEBuL,
      0xBFDA08B785C6EA59uL,
      0x3FD911BC7B12902FuL,
      0xBFD3C0DA5B1130C3uL,
      0x3FD1B590151D6334uL,
      },

     {
      0xBFF30BC075DBAA2CuL,
      0xBC995FE8F2B56DBDuL,
      0x0000000000000000uL,
      0xBFD998188E816BF0uL,
      0xBC73DB2BD13E0A0CuL,
      0x3FF0000000000000uL,
      0x3FC478794806DE66uL,
      0xBFDDAFF33BF96274uL,
      0x3FE24F039543C659uL,
      0xBFD88A113E071D2DuL,
      0x3FD7AB3E661E65F9uL,
      0xBFD24E4E1B8DC6CDuL,
      0x3FD01ED5FCAC7FDDuL,
      },

     {
      0xBFF33E046C843287uL,
      0x3C9A7CCAC0E4698BuL,
      0x0000000000000000uL,
      0xBFD8B00196B3D022uL,
      0x3C67341EE30455A6uL,
      0x3FF0000000000000uL,
      0x3FC30BCA73878656uL,
      0xBFDC5C67FF403B73uL,
      0x3FE1B94E72981059uL,
      0xBFD7209990BAE1F6uL,
      0x3FD65EF72AC3A4F8uL,
      0xBFD0F83D8377C34BuL,
      0x3FCD97555AF6144CuL,
      },

     {
      0xBFF37048632CBAE1uL,
      0x3C8CB2FCE8FC81A5uL,
      0x0000000000000000uL,
      0xBFD7CA1A832D0F84uL,
      0x3C7EE5A712091434uL,
      0x3FF0000000000000uL,
      0x3FC1AF828B5ED674uL,
      0xBFDB13909C0269A2uL,
      0x3FE12C3A0394B7FAuL,
      0xBFD5CAC4A421216CuL,
      0x3FD52AE625505252uL,
      0xBFCF7831018A616AuL,
      0x3FCB98AB42F62940uL,
      },

     {
      0xBFF3A28C59D5433BuL,
      0x3C61B19140C0C0D5uL,
      0x0000000000000000uL,
      0xBFD6E649F7D78649uL,
      0xBC678D2AC0322984uL,
      0x3FF0000000000000uL,
      0x3FC0631EFCBE0D16uL,
      0xBFD9D4CEDF38DFCDuL,
      0x3FE0A74F7488C3A6uL,
      0xBFD487249EA3BD6CuL,
      0x3FD40D3A9BDEFA27uL,
      0xBFCD2F1CBD1B58CDuL,
      0x3FC98CBDCEBDAD19uL,
      },

     {
      0xBFF3D4D0507DCB95uL,
      0xBC83DA34489C213BuL,
      0x0000000000000000uL,
      0xBFD604775FBB27DFuL,
      0xBC6AC647C9CF0A4CuL,
      0x3FF0000000000000uL,
      0x3FBE4C49866D2D78uL,
      0xBFD89F8D033946D5uL,
      0x3FE02A20954EE23AuL,
      0xBFD35466F88C5ABCuL,
      0x3FD3044BAC5DC8C6uL,
      0xBFCB110C3D6FEB70uL,
      0x3FC7761A8DC12688uL,
      },

     {
      0xBFF40714472653EFuL,
      0xBC96106670B43955uL,
      0x0000000000000000uL,
      0xBFD5248AE1701B17uL,
      0xBC7BE8CC944DAFEAuL,
      0x3FF0000000000000uL,
      0x3FBBF04005723CCCuL,
      0xBFD7733D1300258AuL,
      0x3FDF688E6ACC7DF5uL,
      0xBFD231520EA793C8uL,
      0x3FD20E93C5183A34uL,
      0xBFC91A331D55B3F7uL,
      0x3FC651721E1371DDuL,
      },

     {
      0xBFF439583DCEDC4AuL,
      0x3C9DCC4D42E59DF2uL,
      0x0000000000000000uL,
      0xBFD4466D542BAC92uL,
      0x3C705073A04E444AuL,
      0x3FF0000000000000uL,
      0x3FB9B14751F8BA20uL,
      0xBFD64F58590170A2uL,
      0x3FDE8AC91D15CFCFuL,
      0xBFD11CC2EF09C664uL,
      0x3FD12AB5AB65B965uL,
      0xBFC7471C9AC81567uL,
      0x3FC4826BA97C3E69uL,
      },

     {
      0xBFF46B9C347764A4uL,
      0x3C91A900F67F753AuL,
      0x0000000000000000uL,
      0xBFD36A08355C63DCuL,
      0x3C6D7145B6A10D86uL,
      0x3FF0000000000000uL,
      0x3FB78E922B82AB64uL,
      0xBFD5335ED87AB0D5uL,
      0x3FDDBA417913D89CuL,
      0xBFD015AB59BD876BuL,
      0x3FD0576D1EF5DB85uL,
      0xBFC594A6DD2CA17DuL,
      0x3FC2F51FBC1DE653uL,
      },

     {
      0xBFF49DE02B1FECFEuL,
      0x3C7616D2A8653209uL,
      0x0000000000000000uL,
      0xBFD28F459ECAD74DuL,
      0xBC302C86D50E46C0uL,
      0x3FF0000000000000uL,
      0x3FB5875F92EDBDF4uL,
      0xBFD41ED6D05A0010uL,
      0x3FDCF65481FC5BEBuL,
      0xBFCE361FE028368DuL,
      0x3FCF2728B941710BuL,
      0xBFC3FFF674960878uL,
      0x3FC1A12109F12125uL,
      },

     {
      0xBFF4D02421C87558uL,
      0xBC7A765E893370D7uL,
      0x0000000000000000uL,
      0xBFD1B6103D3597E9uL,
      0xBC6CBCB5FED7AC2CuL,
      0x3FF0000000000000uL,
      0x3FB39AFA3392E164uL,
      0xBFD3114C46E2AEF3uL,
      0x3FDC3E6B23EF73B5uL,
      0xBFCC580D1B42EE7FuL,
      0x3FCDBC3D6E14D202uL,
      0xBFC28671B66B7EC4uL,
      0x3FC0BFBCFE62E275uL,
      },

     {
      0xBFF502681870FDB2uL,
      0xBC92C0E3EEB304EEuL,
      0x0000000000000000uL,
      0xBFD0DE53475F3B3CuL,
      0xBC67B2CC0A839654uL,
      0x3FF0000000000000uL,
      0x3FB1C8B7D76C7EE0uL,
      0xBFD20A509D4BB6C1uL,
      0x3FDB91F96510DF38uL,
      0xBFCA8F698D62832EuL,
      0x3FCC6C3408291325uL,
      0xBFC125B6D8F69817uL,
      0x3FBE80E8F3B35090uL,
      },

     {
      0xBFF534AC0F19860CuL,
      0xBC9EE4303B192DA6uL,
      0x0000000000000000uL,
      0xBFD007FA758626AEuL,
      0xBC65A5EB9CA4F97AuL,
      0x3FF0000000000000uL,
      0x3FB00FF8E583BEBCuL,
      0xBFD1097A2AA570F5uL,
      0x3FDAF07DA8CAEBA7uL,
      0xBFC8DA9D107525ADuL,
      0x3FCB3545F2ADC1DBuL,
      0xBFBFB739DB46589AuL,
      0x3FBDA2C2374E7733uL,
      },

     {
      0xBFF566F005C20E67uL,
      0x3C94F8837880A9A2uL,
      0x0000000000000000uL,
      0xBFCE65E3F27C9F2AuL,
      0xBC6F62A8B8B3F2A2uL,
      0x3FF0000000000000uL,
      0x3FACE04FD3EC1C90uL,
      0xBFD00E63DD639A45uL,
      0x3FDA598003751442uL,
      0xBFC73829AC409F93uL,
      0x3FCA15E3A26F9D69uL,
      0xBFBD4C4574E0CB3EuL,
      0x3FBB9C588182E205uL,
      },

     {
      0xBFF59933FC6A96C1uL,
      0x3C81AA6E583501D4uL,
      0x0000000000000000uL,
      0xBFCCBE4CEB4B4CF2uL,
      0xBC64A514F790D588uL,
      0x3FF0000000000000uL,
      0x3FA9D1724DE6C940uL,
      0xBFCE3159C5ED3A4EuL,
      0x3FD9CC919D4271B2uL,
      0xBFC5A6A9489AA7F4uL,
      0x3FC90C961E2B49F9uL,
      0xBFBB06EE7CFA369EuL,
      0x3FB9E9447AAF378DuL,
      },

     {
      0xBFF5CB77F3131F1BuL,
      0xBC6A70A9025D3E70uL,
      0x0000000000000000uL,
      0xBFCB1909EFD8B762uL,
      0xBC5843049E1318BCuL,
      0x3FF0000000000000uL,
      0x3FA6F2545C478E00uL,
      0xBFCC4FF0A9D74F70uL,
      0x3FD9494C22EF2A54uL,
      0xBFC424CB909A6722uL,
      0x3FC8180A481D593BuL,
      0xBFB8E3D90C36FA86uL,
      0x3FB8D27EAFEAC4D3uL,
      },

     {
      0xBFF5FDBBE9BBA775uL,
      0xBC8EE2C2D963A10CuL,
      0x0000000000000000uL,
      0xBFC975F5E0553158uL,
      0xBC2EEEA31AB9D050uL,
      0x3FF0000000000000uL,
      0x3FA4420303DEC550uL,
      0xBFCA77D9D62CA610uL,
      0x3FD8CF5143323608uL,
      0xBFC2B15401455507uL,
      0x3FC7370FF096556FuL,
      0xBFB6DFEACA56EADAuL,
      0x3FB6B75DF89EC13CuL,
      },

     {
      0xBFF62FFFE0642FCFuL,
      0xBC9B94ADB917F93EuL,
      0x0000000000000000uL,
      0xBFC7D4EC54FB5968uL,
      0xBC4FB65648F8A4A0uL,
      0x3FF0000000000000uL,
      0x3FA1BF9C7C60B940uL,
      0xBFC8A86964A1796BuL,
      0x3FD85E4A37F23352uL,
      0xBFC14B181F5BF6AEuL,
      0x3FC66888E3A5D3BAuL,
      0xBFB4F84D7AC0F5DBuL,
      0x3FB62BA6F07C5587uL,
      },

     {
      0xBFF66243D70CB82AuL,
      0x3C984805FA81DE0AuL,
      0x0000000000000000uL,
      0xBFC635C990CE0D36uL,
      0x3C59DFC0C48C2B20uL,
      0x3FF0000000000000uL,
      0x3F9ED49F1F8144C0uL,
      0xBFC6E0F98ED00C32uL,
      0x3FD7F5E75A2DD66EuL,
      0xBFBFE1FBA10F6B0EuL,
      0x3FC5AB7CD1905EBBuL,
      0xBFB32A57A4FAE3FFuL,
      0x3FB4BA60BA62CA68uL,
      },

     {
      0xBFF69487CDB54084uL,
      0x3C8849735C376AA4uL,
      0x0000000000000000uL,
      0xBFC4986A74CF4E57uL,
      0xBC69AB0A243914D0uL,
      0x3FF0000000000000uL,
      0x3F9A82B60D75F5C0uL,
      0xBFC520EA2BA6A0AEuL,
      0x3FD795DFBFFEE39EuL,
      0xBFBD43F3A7862CC7uL,
      0x3FC4FF04247D7006uL,
      0xBFB1739726786F64uL,
      0x3FB2FAC67536C2B7uL,
      },

     {
      0xBFF6C6CBC45DC8DEuL,
      0x3BD6D61B58C99C43uL,
      0x0000000000000000uL,
      0xBFC2FCAC73A60640uL,
      0xBC52CF95F70D438CuL,
      0x3FF0000000000000uL,
      0x3F96881A43B33590uL,
      0xBFC367A033B52F5EuL,
      0x3FD73DF0E3CC557AuL,
      0xBFBABA1CAC4F18CDuL,
      0x3FC4624C36BE941DuL,
      0xBFAFA38B2F88747DuL,
      0x3FB215B1F402C9E1uL,
      },

     {
      0xBFF6F90FBB065138uL,
      0xBC8843BDD561383DuL,
      0x0000000000000000uL,
      0xBFC1626D85A91E70uL,
      0x3C50084844291A00uL,
      0x3FF0000000000000uL,
      0x3F92E3863C9A69E0uL,
      0xBFC1B4854BB2B147uL,
      0x3FD6EDDE5416DFFBuL,
      0xBFB8429341CCA17AuL,
      0x3FC3D49AC2C9F46EuL,
      0xBFAC85843914CF63uL,
      0x3FB1B1DC3FA41043uL,
      },

     {
      0xBFF72B53B1AED992uL,
      0xBC98452B3716C4D6uL,
      0x0000000000000000uL,
      0xBFBF93183A8DB9E9uL,
      0x3C4124AC452DA622uL,
      0x3FF0000000000000uL,
      0x3F8F27A3181EE680uL,
      0xBFC00707549D7ECCuL,
      0x3FD6A5716B500730uL,
      0xBFB5DB89BB6B245FuL,
      0x3FC3554867F59647uL,
      0xBFA98919BF6D1AC0uL,
      0x3FB1AF9A18244AC2uL,
      },

     {
      0xBFF75D97A85761EDuL,
      0x3C9B97887C831272uL,
      0x0000000000000000uL,
      0xBFBC63CE377FC802uL,
      0x3C543F7D42D9FFC4uL,
      0x3FF0000000000000uL,
      0x3F892FE02A47EFA0uL,
      0xBFBCBD3001C956C5uL,
      0x3FD664790F293C47uL,
      0xBFB38345DE7C4B0BuL,
      0x3FC2E3C4C02FFDF9uL,
      0xBFA6AA7F0C135018uL,
      0x3FAFE3C754ACF687uL,
      },

     {
      0xBFF78FDB9EFFEA47uL,
      0x3C8EE8786039D373uL,
      0x0000000000000000uL,
      0xBFB936BB8C5B2DA2uL,
      0xBC587D23392D360CuL,
      0x3FF0000000000000uL,
      0x3F83DDE2A8935DE0uL,
      0xBFB97558DC230BA8uL,
      0x3FD62AC976FBC1B8uL,
      0xBFB1381EB60159F6uL,
      0x3FC27F84438D5027uL,
      0xBFA3E63B3A462D11uL,
      0x3FAF0AE614B60705uL,
      },

     {
      0xBFF7C21F95A872A1uL,
      0x3C6A877F1DB6080CuL,
      0x0000000000000000uL,
      0xBFB60B9F7597FDECuL,
      0xBC3D1E3FBF349CC0uL,
      0x3FF0000000000000uL,
      0x3F7E5FFEF4D8DFC0uL,
      0xBFB6357984E124B6uL,
      0x3FD5F83BF8B56900uL,
      0xBFADF0F50CAA06C2uL,
      0x3FC228147690425DuL,
      0xBFA138F0F640FF12uL,
      0x3FAF8D1BCDD067BDuL,
      },

     {
      0xBFF7F4638C50FAFBuL,
      0xBC81A4B8D15ECF6DuL,
      0x0000000000000000uL,
      0xBFB2E239CCFF3831uL,
      0xBC5879ED3FF4D06CuL,
      0x3FF0000000000000uL,
      0x3F764980AEEE3740uL,
      0xBFB2FC879C81123CuL,
      0x3FD5CCAEDC1DC96EuL,
      0xBFA98599B71D86B1uL,
      0x3FC1DD150D55E5CEuL,
      0xBF9D3EB9450DBD20uL,
      0x3FADD6CFBE9A9DDEuL,
      },

     {
      0xBFF826A782F98355uL,
      0xBC94F5A8B515906FuL,
      0x0000000000000000uL,
      0xBFAF7495EA3F3783uL,
      0x3C407F10D50F8AC9uL,
      0x3FF0000000000000uL,
      0x3F6EEB8B377B1A00uL,
      0xBFAF92FABFD0B7B3uL,
      0x3FD5A805341437FFuL,
      0xBFA52B295E2DCF92uL,
      0x3FC19E2C59B8C033uL,
      0xBF982CF88466F013uL,
      0x3FAD27509D6C3D7CuL,
      },

     {
      0xBFF858EB79A20BB0uL,
      0x3C9EE70AFE8446D9uL,
      0x0000000000000000uL,
      0xBFA927278A3B1162uL,
      0xBBFB01BD7F1D4620uL,
      0x3FF0000000000000uL,
      0x3F63C55DB08E1680uL,
      0xBFA936B1EC652161uL,
      0x3FD58A26BD6CCCCDuL,
      0xBFA0DEB5445B4095uL,
      0x3FC16B146127E0E0uL,
      0xBF9336A9836851D5uL,
      0x3FAC19302F7F3ACCuL,
      },

     {
      0xBFF88B2F704A940AuL,
      0x3C92C3BEB21E1E21uL,
      0x0000000000000000uL,
      0xBFA2DBAAE9A05DB0uL,
      0x3C4371F88E195029uL,
      0x3FF0000000000000uL,
      0x3F563A086B860B00uL,
      0xBFA2E23785EEB488uL,
      0x3FD572FFC353B741uL,
      0xBF993ABD2276BF58uL,
      0x3FC143926088643DuL,
      0xBF8CAC359DDE7BCEuL,
      0x3FAB56F9A2A6CD28uL,
      },

     {
      0xBFF8BD7366F31C64uL,
      0x3C7A81C996DFD5A5uL,
      0x0000000000000000uL,
      0xBF992346247A91F0uL,
      0x3BF126D920C63160uL,
      0x3FF0000000000000uL,
      0x3F43BF447B091000uL,
      0xBF992726F0F98D7FuL,
      0x3FD5628108EFA55CuL,
      0xBF90C8A60639C114uL,
      0x3FC127789EC0BD38uL,
      0xBF830BA6F46C58D9uL,
      0x3FABBEE2C1E62B03uL,
      },

     {
      0xBFF8EFB75D9BA4BEuL,
      0xBC760B679AB8CD3BuL,
      0x0000000000000000uL,
      0xBF89224E047E368EuL,
      0x3C1A268EB3BB9B7AuL,
      0x3FF0000000000000uL,
      0x3F23BDBEAD8CF800uL,
      0xBF8923461AE96D62uL,
      0x3FD5589FB822D5EEuL,
      0xBF80C326DCDCFCD2uL,
      0x3FC116A999125B8AuL,
      0xBF7300CC26580304uL,
      0x3FAB7B6F1DCF22D1uL,
      },
     },
    0x7FFFFFFFFFFFFFFFuL,
    0x4420000000000000uL,
    0x7FF0000000000000uL,
    0x40545F306DC9C883uL,
    0x4338000000000000uL,
    0x00000000000001FFuL,
    0x3F8921FB54400000uL,
    0x3D60B4611A600000uL,
    0x3B33198A2E037073uL,

    0x4328000000000000uL,
    0x4300000000000000uL,
    0x400921fb54442d18uL,

    0xbfabb103d68ee571uL,
    0x3ff0c8580fa6b9b9uL,
    0xc0108bb113b2d25auL,

    0x3f73727e6e36b82fuL,
    0xbfd336a7eaff7f8euL,
    0x400401cce5f3a97buL,
    0xc0126d1667518600uL,
    0x3ff0000000000000uL,
};

static __constant _iml_v2_dp_union_t __dtanpi_la_CoutTab[13] = {

    0x00000000, 0x3FF00000,
    0x00000000, 0x00000000,
    0x00000000, 0x7FF00000,
    0x00000000, 0x3CA00000,
    0x02000000, 0x41A00000,
    0x50000000, 0x400921fb,
    0x611a6263, 0x3e6110b4,

    0x00000000, 0x45100000,
    0x00000000, 0x3AD00000,
    0x00000000, 0x00300000,
    0x00000000, 0x43300000,
    0x00000000, 0x43400000,
    0x00000000, 0x80000000,
};

__attribute__((always_inline))
inline int __internal_dtanpi_la_cout (double *a, double *r)
{
    double absx, dbVTmp1, dbVTmp2, dbRes, dbResHi, dbResMid, dbResLo, dbTmp1, dbTmp2;
    int nRet = 0;
    int iSign, iParity;

    absx = (*a);
    (((_iml_v2_dp_union_t *) & absx)->dwords.hi_dword = (((_iml_v2_dp_union_t *) & absx)->dwords.hi_dword & 0x7FFFFFFF) | ((_iml_uint32_t) (0) << 31));
    if ((((((_iml_v2_dp_union_t *) & (*a))->dwords.hi_dword >> 20) & 0x7FF) != 0x7FF))
    {

        iSign = (((_iml_v2_dp_union_t *) & (*a))->dwords.hi_dword >> 31);

        if (absx < ((__constant double *) __dtanpi_la_CoutTab)[3])
        {

            dbVTmp1 = ((__constant double *) __dtanpi_la_CoutTab)[0] + absx;

            dbRes = dbVTmp1 * absx;
            dbRes *= ((__constant double *) __dtanpi_la_CoutTab)[7];
            dbVTmp1 = ((dbRes) * (((__constant double *) __dtanpi_la_CoutTab)[4]));
            dbVTmp2 = (dbVTmp1 - (dbRes));
            dbVTmp1 = (dbVTmp1 - dbVTmp2);
            dbVTmp2 = ((dbRes) - dbVTmp1);
            dbResHi = dbVTmp1;
            dbResLo = dbVTmp2;;
            dbTmp1 = ((dbResHi) * (((__constant double *) __dtanpi_la_CoutTab)[5]));
            dbTmp2 = ((dbResLo) * (((__constant double *) __dtanpi_la_CoutTab)[6]));
            dbTmp2 = (dbTmp2 + (dbResHi) * (((__constant double *) __dtanpi_la_CoutTab)[6]));
            dbVTmp1 = (dbTmp2 + (dbResLo) * (((__constant double *) __dtanpi_la_CoutTab)[5]));
            dbResHi = dbTmp1;
            dbResLo = dbVTmp1;;

            dbRes = dbResHi + dbResLo;
            if (dbRes < ((__constant double *) __dtanpi_la_CoutTab)[9])
            {

                dbVTmp1 = ((dbResHi) * (((__constant double *) __dtanpi_la_CoutTab)[4]));
                dbVTmp2 = (dbVTmp1 - (dbResHi));
                dbVTmp1 = (dbVTmp1 - dbVTmp2);
                dbVTmp2 = ((dbResHi) - dbVTmp1);
                dbResHi = dbVTmp1;
                dbResMid = dbVTmp2;;
                dbResLo += dbResMid;

                dbVTmp1 = (dbResHi * ((__constant double *) __dtanpi_la_CoutTab)[8]);
                dbVTmp2 = (dbResLo * ((__constant double *) __dtanpi_la_CoutTab)[8]);
                dbRes = dbVTmp1 + (dbVTmp2);
            }
            else
            {
                dbRes *= ((__constant double *) __dtanpi_la_CoutTab)[8];
            }

            (((_iml_v2_dp_union_t *) & dbRes)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *) & dbRes)->dwords.hi_dword & 0x7FFFFFFF) | ((_iml_uint32_t) (iSign) << 31));
            (*r) = dbRes;
        }
        else if (absx > ((__constant double *) __dtanpi_la_CoutTab)[10])
        {

            if (absx > ((__constant double *) __dtanpi_la_CoutTab)[11])
            {

                iParity = 0;
            }
            else
            {

                iParity = ((_iml_v2_dp_union_t *) & (absx))->hex[0] & 1;
            }
            if (iParity ^ iSign)
            {
                dbRes = ((__constant double *) __dtanpi_la_CoutTab)[12];
            }
            else
            {
                dbRes = ((__constant double *) __dtanpi_la_CoutTab)[1];
            }
            (*r) = dbRes;
        }
        return nRet;
    }
    else
    {
        if ((((_iml_v2_dp_union_t *) & (absx))->hex[0] == ((__constant _iml_v2_dp_union_t *) & (((__constant double *) __dtanpi_la_CoutTab)[2]))->hex[0])
            && (((_iml_v2_dp_union_t *) & (absx))->hex[1] ==
                ((__constant _iml_v2_dp_union_t *) & (((__constant double *) __dtanpi_la_CoutTab)[2]))->hex[1]))
        {

            (*r) = (*a) * ((__constant double *) __dtanpi_la_CoutTab)[1];

            nRet = 1;
            return nRet;
        }
        else
        {

            (*r) = (*a) * (*a);
            return nRet;
        }
    }

    return nRet;
}

double __ocl_svml_tanpi (double a)
{

    double va1;
    double vr1;
    unsigned int vm;

    double r;

    va1 = a;;

    {

        double dAbsMask;
        double dAbsX;
        double dReductionRangeVal;
        unsigned long lReductionRangeMask;
        double dReductionRangeMask;
        unsigned int mReductionRangeMask;

        double dX;
        double dZ;
        double dRangeVal;
        double dRangeMask;
        unsigned long lRangeMask;
        unsigned int iRound;
        unsigned long lRound;
        unsigned int iSign;
        unsigned long lSign;
        double dExp;

        double dInvPI;
        double dRShifter;
        double dY;
        double dYLarge;
        double dN;
        double dPI1;
        double dPI2;
        double dPI3;
        double dR;
        double dRLarge;
        double dRh;
        double dRm;
        double dRl;
        double dRlLarge;
        double dRl3;
        double dNP2;
        double dNP3;

        unsigned int iIndex;
        unsigned long lIndex;
        double dTLh;
        double dTLl;
        double dTh;
        double dTl;
        double dPC[5];
        double dR2;
        double dPoly;
        double dP;
        double dPlow;
        double dOne;
        double dNumerator;
        double dNlow;
        double dDenominator;
        double dDlow;
        double dRcp;
        double dE;
        double dQuotient;
        double dQlow;
        double dAE;

        double dShifter;
        double dShiftedN;
        double dSignX;
        double dSpecMask;
        double dModifier;
        double dZero;
        double dSignBit;
        double dInvBit;
        double dInvMask;

        double dP3;
        double dP2;
        double dP1;
        double dP0;
        double dQ;
        double dQ4;
        double dQ3;
        double dQ2;
        double dQ1;
        double dQ0;
        double dNum;
        double dDen;
        double dRes;

        double dSpecRes;

        vm = 0;
        dAbsMask = as_double (__internal_dtanpi_la_data._dAbsMask);
        dAbsX = as_double ((as_ulong (va1) & as_ulong (dAbsMask)));
        dSignX = as_double ((as_ulong (dAbsX) ^ as_ulong (va1)));

        dReductionRangeVal = as_double (__internal_dtanpi_la_data._dReductionRangeVal_new);
        dReductionRangeMask = as_double ((unsigned long) (((!(dAbsX <= dReductionRangeVal)) ? 0xffffffffffffffff : 0x0)));
        lReductionRangeMask = as_ulong (dReductionRangeMask);

        mReductionRangeMask = 0;
        mReductionRangeMask = lReductionRangeMask;
        if ((mReductionRangeMask) != 0)
        {

            dRangeVal = as_double (__internal_dtanpi_la_data._dRangeVal);
            dExp = as_double ((as_ulong (dRangeVal) & as_ulong (dAbsX)));
            dRangeMask = as_double ((unsigned long) ((dExp == dRangeVal) ? 0xffffffffffffffff : 0x0));
            lRangeMask = as_ulong (dRangeMask);
            vm = 0;
            vm = lRangeMask;

            {

                double dX;
                double dShifterMod;
                double dShifterThreshold;
                double dShifterMask;
                double dShifterPos;
                double dShifter;
                double dDirect;
                double dInverse;
                double dShiftedN;
                double dN;
                double dZero;
                dX = dAbsX;
                dShifterThreshold = as_double (0x43A0000000000000uL);
                dShifterMask = as_double ((unsigned long) ((dX < dShifterThreshold) ? 0xffffffffffffffff : 0x0));

                dShifterPos = as_double (0x43B8000000000000uL);
                dZero = as_double (0x0000000000000000uL);
                dShifter = as_double ((((~as_ulong (dShifterMask)) & as_ulong (dZero)) | (as_ulong (dShifterMask) & as_ulong (dShifterPos))));

                dShiftedN = (dShifter + dAbsX);
                dN = (dShiftedN - dShifter);
                dZ = (dAbsX - dN);

            }

            dAbsX = as_double ((((~as_ulong (dReductionRangeMask)) & as_ulong (dAbsX)) | (as_ulong (dReductionRangeMask) & as_ulong (dZ))));
        }

        dShifter = as_double (__internal_dtanpi_la_data._dRShift_new);
        dN = (dShifter + dAbsX);
        dY = (dN - dShifter);

        dR = (dAbsX - dY);

        dR2 = (dR * dR);

        dSignBit = as_double (((unsigned long) as_ulong (dN) << (63)));

        dInvBit = as_double (((unsigned long) as_ulong (dN) << (62)));
        dZero = as_double (0L);
        dInvMask = as_double ((unsigned long) (((!(dInvBit == dZero)) ? 0xffffffffffffffff : 0x0)));

        dP3 = as_double (__internal_dtanpi_la_data._dP3);
        dP2 = as_double (__internal_dtanpi_la_data._dP2);
        dP1 = as_double (__internal_dtanpi_la_data._dP1);
        dPI1 = as_double (__internal_dtanpi_la_data._dPI1);

        dP = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dP3, dR2, dP2);
        dP = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dP, dR2, dP1);
        dP = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dP, dR2, dPI1);
        dQ4 = as_double (__internal_dtanpi_la_data._dQ4);
        dQ3 = as_double (__internal_dtanpi_la_data._dQ3);
        dQ2 = as_double (__internal_dtanpi_la_data._dQ2);
        dQ1 = as_double (__internal_dtanpi_la_data._dQ1);
        dQ = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dQ4, dR2, dQ3);
        dQ = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dQ, dR2, dQ2);
        dQ = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dQ, dR2, dQ1);
        dP = (dP * dR);
        dQ0 = as_double (__internal_dtanpi_la_data._dQ0);
        dQ = SPIRV_OCL_BUILTIN(fma, _f64_f64_f64, ) (dQ, dR2, dQ0);
        dNum = as_double ((((~as_ulong (dInvMask)) & as_ulong (dP)) | (as_ulong (dInvMask) & as_ulong (dQ))));
        dDen = as_double ((((~as_ulong (dInvMask)) & as_ulong (dQ)) | (as_ulong (dInvMask) & as_ulong (dP))));

        dRes = (dNum / dDen);

        dSpecRes = as_double ((as_ulong (dRes) | as_ulong (dInvBit)));
        dSpecMask = as_double ((unsigned long) ((dR == dZero) ? 0xffffffffffffffff : 0x0));
        vr1 = as_double ((as_ulong (dRes) ^ as_ulong (dSignBit)));
        vr1 = as_double ((((~as_ulong (dSpecMask)) & as_ulong (vr1)) | (as_ulong (dSpecMask) & as_ulong (dSpecRes))));
        vr1 = as_double ((as_ulong (vr1) ^ as_ulong (dSignX)));
    }

    if ((vm) != 0)
    {
        double _vapi_arg1[1];
        double _vapi_res1[1];
        ((double *) _vapi_arg1)[0] = va1;
        ((double *) _vapi_res1)[0] = vr1;
        __internal_dtanpi_la_cout (_vapi_arg1, _vapi_res1);
        vr1 = ((double *) _vapi_res1)[0];
    };
    r = vr1;;

    return r;

}
