## RabbitMQ 4.0.8

RabbitMQ `4.0.8` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `27.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).

### Core Broker

#### Bug Fixes

 * Fixes a number of rare replication safety issues for quorum queues and Khepri.

   GitHub issue: [#13530](https://github.com/rabbitmq/rabbitmq-server/pull/13530)

 * Peer discovery retry limit supports the value of `infinity`
   but the `cluster_formation.discovery_retry_limit` key in `rabbitmq.conf` only accepted positive integers.

   Contributed by @SimonUnge.

   GitHub issue: [#13676](https://github.com/rabbitmq/rabbitmq-server/pull/13676)

#### Enhancements

 * Quorum queue checkpoint algorithm was tweaked to take checkpoints more frequently, thus
   clearing older segment files more aggressively.

   Workloads that use larger messages should continue following [the documented recommendations](https://www.rabbitmq.com/docs/quorum-queues#performance-tuning-large-messages) to
   avoid large disk space footprint of segment files.

   GitHub issue: [#13622](https://github.com/rabbitmq/rabbitmq-server/pull/13622)

 * Previously a node that was a cluster member but then was [reset](https://www.rabbitmq.com/docs/clustering#restarting-with-hostname-changes) could not
   rejoin the cluster if the [schema data store](https://www.rabbitmq.com/docs/metadata-store) was Mnesia.

   Now the reset node will try to leave the cluster and retry rejoining again.
   This was already the case for Khepri.

   Contributed by @SimonUnge.

   GitHub issue: [#13669](https://github.com/rabbitmq/rabbitmq-server/pull/13669)


### CLI Tools

#### Enhancements

 * [`rabbitmqadmin`](https://www.rabbitmq.com/docs/management-cli) 2.0.0 GA is now available as a standalone binary.

   Learn more: [`rabbitmq/rabbitmqadmin-ng`](https://github.com/rabbitmq/rabbitmqadmin-ng)

  * New health check commands help detect quorum queues without an elected leader.

    ```shell
    # Verifies that all quorum queues in virtual host "vh-1" match the naming pattern "^naming-pattern"
    # have an elected leader
    rabbitmq-diagnostics check_for_quorum_queues_without_an_elected_leader --vhost "vh-1" "^naming-pattern"

    # Verifies that all quorum queues in the cluster have an elected leader. This can be an expensive
    # operation if there are many quorum queues in the cluster, consider providing a more specific pattern
    rabbitmq-diagnostics check_for_quorum_queues_without_an_elected_leader --across-all-vhosts ".*"
    ```

    Contributed by @Ayanda-D.

    GitHub issue: [#13489](https://github.com/rabbitmq/rabbitmq-server/pull/13489/)


### Stream Plugin

#### Bug Fixes

 * When a connection of one or more consumers in a [Single Active Consumer]() group failed, the group
   could try to activate (promote) one of the consumers are are no longer online. In practical terms
   this means that other consumers were not getting any deliveries.

   GitHub issue: [#13660](https://github.com/rabbitmq/rabbitmq-server/pull/13660)

 * TCP load balancer health checks (TCP connections that do not proceed to complete the RabbitMQ Stream Protocol handshake)
   previously resulted in an exception in the log.

   GitHub issue: [#13678](https://github.com/rabbitmq/rabbitmq-server/pull/13678)

#### Enhancements

 * Stream replication connections now can be configured to use IPv6 using `advanced.config`:

   ```erl
   [
     {osiris, [
        {replica_ip_address_family, inet6}
     ]}
   ].
   ```


### Management Plugin

#### Bug Fixes

 * If HTTP API was configured to use a custom prefix, OAuth 2-based authentication would fail
   because one of the cookies used by the workflow was using an absolute path.

   GitHub issue: [#13668](https://github.com/rabbitmq/rabbitmq-server/pull/13668)

 * Several endpoints could produce an exception when the requested resource (queue or exchange) did not exist.

   GitHub issue: [#13619](https://github.com/rabbitmq/rabbitmq-server/pull/13619)

 * When [OAuth 2 was enabled](https://www.rabbitmq.com/docs/oauth2) with an IDP-initiated login,
   the UI displayed a confusing warning.

   GitHub issue: [#13507](https://github.com/rabbitmq/rabbitmq-server/pull/13507)

#### Enhancements

 * Historically, HTTP API access was controlled by exactly the same [authentication and authorization backend chain]()
   that were configured for the messaging protocol connections.

   Now it is possible to use a separate chain, that is, a separate set of backends, specifically for the HTTP API access:

   ```ini
   # Messaging protocol access
   auth_backends.1 = ldap
   auth_backends.2 = internal

   # HTTP API access
   http_dispatch.auth_backends.1 = http
   ```

   Contributed by @aaron-seo.

   GitHub issue: [#13467](https://github.com/rabbitmq/rabbitmq-server/pull/13467)

 * A new `rabbitmq.conf` setting, `management.delegate_count`, controls the size of the pool of processes
   that aggregate data to respond to HTTP API client requests.

   The default value is `5`. Nodes that have access to a double digit numbers of CPU cores (say, 32)
   could benefit from using a higher number, e.g. `10` or `16`.

   Contributed by @Ayanda-D.

   GitHub issue: [#13462](https://github.com/rabbitmq/rabbitmq-server/pull/13462)


### Shovel Plugin

#### Bug Fixes

 * AMQP 1.0 shovels could stop consuming after `2^16 - 1` messages.

   GitHub issue: [#13578](https://github.com/rabbitmq/rabbitmq-server/pull/13578)


### LDAP Plugin

#### Enhancements

 * The `in_group_nested` query now uses case-insensitive matching, which is more typical of the LDAP tooling.

   GitHub issue: [#13633](https://github.com/rabbitmq/rabbitmq-server/pull/13633)


### Dependency Changes

 * `ra` was upgraded to [`2.15.3`](https://github.com/rabbitmq/ra/releases)
 * `osiris` was updated to [`1.8.6`](https://github.com/rabbitmq/osiris/releases)
 * `credentials_obfuscation` was upgraded to [`3.5.0`](https://github.com/rabbitmq/credentials-obfuscation/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.8.tar.xz`
instead of the source tarball produced by GitHub.
