RabbitMQ `3.9.13` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * Disk space monitor now correctly parses output on (at least some) systems where non-ASCII characters are used in paths.

   GitHub issue: [#3970](https://github.com/rabbitmq/rabbitmq-server/pull/3970)

 * Stream leader election is now deterministic when cluster is undergoing a rolling upgrade.

   GitHub issue: [#3967](https://github.com/rabbitmq/rabbitmq-server/pull/3967)

#### Enhancements

 * Queue and binding [definition import](https://rabbitmq.com/definitions.html) can be delayed until a moment
   when at least N nodes (e.g. three) have joined the cluster. This way imported quorum queues will have a desired
   number of replicas from the start.

   GitHub issue: [#3986](https://github.com/rabbitmq/rabbitmq-server/pull/3986)


## Dependency Upgrades

* Osiris was [upgraded to `1.2.4`](https://github.com/rabbitmq/osiris/compare/v1.2.3...v1.2.4)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.13.tar.xz`
instead of the source tarball produced by GitHub.
