## RabbitMQ 3.8.15

RabbitMQ `3.8.15` is a maintenance release that includes two security patches.

All users are advised to consult the set of changes in this release but then
**upgrade straight to `3.8.16` or a newer version if available** and skip this release.

### Security Patches

This release addresses two CVEs:

 * [CVE-2021-22117](https://tanzu.vmware.com/security/cve-2021-22117)
 * [CVE-2021-22116](https://tanzu.vmware.com/security/cve-2021-22116)

Our team would like to thank

 * Jonathan Knudsen from the Synopsys Cybersecurity Research Center (CyRC)
 * Robert Chen from DeepSurface Security

for responsibly disclosing the vulnerabilities and helping assess and test
the patches.

### Obtaining Packages

This is the first release in the [post-Bintray era](https://blog.rabbitmq.com/posts/2021/03/migrate-off-of-bintray/).
Because Bintray shut down on May 1st, 2021, this version is not distributed via Bintray.
From now on, releases are distributed via GitHub, [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release is the [last release to support Erlang 22.3](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).
[Erlang 23](http://blog.erlang.org/OTP-23-Highlights/) is highly recommended
for best forward compatibility with future RabbitMQ versions.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision a recent version of Erlang `23.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * Quorum queues did not take snapshots as frequently as they are expected to with some configurations.
   This resulted in much higher peak disk space usage for queues that did not have a meaningful backlog.

   GitHub issue: [#2974](https://github.com/rabbitmq/rabbitmq-server/issues/2974)

 * Quorum queue name was unintentionally limited: the length of virtual host and actual queue name
   was limited to 254 characters. Quorum queues that had longer names failed to be declared.

 * Deleting a quorum queue would leave some of its internal metrics data around.

   GitHub issue: [#2846](https://github.com/rabbitmq/rabbitmq-server/pull/2846)

 * Client destination address is now obtained w.r.t. the [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol) settings.

   Contributed by @carlhoerberg (CloudAMQP).

   GitHub issue: [#2942](https://github.com/rabbitmq/rabbitmq-server/pull/2942)

#### Enhancements

 * Consumers that consume messages and do not acknowledge them will now have a 15 minute
   acknowledgement timeout applied to them by default. Operators can increase the timeout if necessary.

   Such consumers delay or even prevent on disk data compaction, which can run a node out of disk
   space much earlier than anticipated.

   GitHub issue: [#2990](https://github.com/rabbitmq/rabbitmq-server/pull/2990)

 * Channel interceptors now can return channel-level exceptions.

   Contributed by Ayanda @Ayanda-D Dube.

   GitHub issue: [#2989](https://github.com/rabbitmq/rabbitmq-server/pull/2989)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics status` could run into an exception when formatting responses
   from nodes where high VM memory watermark was configured using `advanced.config`.

   GitHub issue: [#2964](https://github.com/rabbitmq/rabbitmq-server/issues/2964)

 * `rabbitmq-queues rebalance` will no longer pick nodes [under maintenance](https://www.rabbitmq.com/upgrade.html#maintenance-mode)
   as new queue leader placement candidates.

   GitHub issue: [#2993](https://github.com/rabbitmq/rabbitmq-server/pull/2993)

#### Enhancements

 * `rabbitmq-diagnostics remote_shell` is a new command that opens a remote Erlang shell
   to the target node. This simplifies troubleshooting of a running node.

   GitHub issue: [#2860](https://github.com/rabbitmq/rabbitmq-server/pull/2860)

 * `rabbitmq-queues await_online_quorum_plus_one` is now a no-op in a single node cluster
   since the command does not make sense when there is only one node.

   GitHub issue: [#2890](https://github.com/rabbitmq/rabbitmq-server/pull/2890)


### Management Plugin

#### Bug Fixes

 * When a virtual host was created with tags via the HTTP API, the tags were unintentionally
   concatenated together.

   GitHub issue: [#2982](https://github.com/rabbitmq/rabbitmq-server/pull/2982)

 * More precise UI description for message consumption mode that is destructive (consumes in automatic acknowledgement mode).

   GitHub issue: [#3011](https://github.com/rabbitmq/rabbitmq-server/pull/3011)


### AWS Peer Discovery Plugin

#### Enhancements

 * [AWS peer discovery mechanism](https://www.rabbitmq.com/cluster-formation.html#peer-discovery-aws) now supports
   [Instance Metadata Service v2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html).
   In case it is not available, requests will fall back to the original metadata service endpoint.

   The v2 endpoint offers substantial security improvements and is one of
   the [AWS best practices](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-fsbp-controls.html#ec2-8-remediation).

   Contributed by @thuandb (AWS).

   GitHub issue: [#2952](https://github.com/rabbitmq/rabbitmq-server/pull/2952)


### Auth Mechanism TLS Plugin

#### Enhancements

 * The plugin now has limited support for username extraction from SAN of type "other name".
   Note that the type by definition supports arbitrary values, so supporting all possible
   inputs is not realistic.

   Contributed by @Thibi2000.

   GitHub issue: [#2983](https://github.com/rabbitmq/rabbitmq-server/issues/2983), [#2985](https://github.com/rabbitmq/rabbitmq-server/issues/2985)

## Dependency Upgrades

 There were no dependency changes.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.15.tar.xz`
instead of the source tarball produced by GitHub.
