## RabbitMQ 3.8.10

**Important**: this release has been [superseded by `3.8.11`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.11)
which addresses a couple of bugs specific to this release (`3.8.10`)

All users are advised to consult the set of changes in this release but then **upgrade straight
to `3.8.11` or a newer version if available** and skip this release.


RabbitMQ `3.8.10` is a maintenance release.
Besides containing several bug fixes, it introduces a couple new features for quorum queues.

This release [**no longer supports** Erlang 21.3](https://groups.google.com/forum/#!topic/rabbitmq-users/v3K5nZNsfwM).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 22](https://www.rabbitmq.com/which-erlang.html) or
[Erlang 23](http://blog.erlang.org/OTP-23-Highlights/).

Erlang 21.3 [**is no longer supported**](https://groups.google.com/forum/#!topic/rabbitmq-users/v3K5nZNsfwM).
`22.3` or `23.1` releases are recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Deprecations

This release deprecates [boot time definition import](https://www.rabbitmq.com/definitions.html#import-on-boot) build into the management plugin.
The feature still exists but is no longer documented or tested. Please switch to
the built-in definition import mechanism:

``` ini
# DEPRECATED, requires management plugin to be enabled,
# does not support import of definitions that depend on plugins
# (e.g. Shovels or custom exchanges)
management.load_definitions = /path/to/definitions/file.json
```

to

``` ini
# built-in feature, supports import of definitions
# that depend on plugins (e.g. Shovels or custom exchanges)
load_definitions = /path/to/definitions/file.json
```

Definition import in the management plugin (`management.load_definitions`) will be **removed** in
a future RabbitMQ release.

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 22.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 22.x or 23.x, then RabbitMQ to the most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * Starting with `3.8.0`, an unintentionally introduced assertion could prevent classic mirrored queue
   mirrors from starting successfully in case the primary replica changed concurrently with their startup.

   GitHub issue: [rabbitmq/rabbitmq-server#2449](https://github.com/rabbitmq/rabbitmq-server/pull/2449)

 * Repeated polling of a quorum queue with `basic.get` that yielded an empty response could
   result in an unbounded growth of log segment files on on disk.

   GitHub issue: [rabbitmq/rabbitmq-server#2651](https://github.com/rabbitmq/rabbitmq-server/pull/2651)

 * RabbitMQ core plugin activation was revisited to be closer to that of `3.7.x`. This does not any
   related improvements w.r.t. definition import, e.g. those introudced in [RabbitMQ `3.8.6`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.6).

   GitHub issue: [rabbitmq/rabbitmq-server#2656](https://github.com/rabbitmq/rabbitmq-server/pull/2656)

 * Syslog dependency was not started correctly. This meant no log messages were sent to Syslog.

   GitHub issue: [rabbitmq/rabbitmq-server#2456](https://github.com/rabbitmq/rabbitmq-server/pull/2456)

 * `rabbitmq-diagnostics check_if_node_is_quorum_critical` returned a false positive for a node [marked for maintenance](https://www.rabbitmq.com/upgrade.html#maintenance-mode).
   Given the refinement to the `rabbitmq-upgrade drain` command in [rabbitmq/rabbitmq-server#2474](https://github.com/rabbitmq/rabbitmq-server/issues/2474),
   `rabbitmq-diagnostics check_if_node_is_quorum_critical` now will unconditionally return a success
   if target node is under maintenance.

   GitHub issue: [rabbitmq/rabbitmq-server#2469](https://github.com/rabbitmq/rabbitmq-server/issues/2469)

 * Queues could update their internal bookkeeping state incorrectly in some cases, leading to a `file_handle_cache`
   operation exception.

   GitHub issue: [rabbitmq/rabbitmq-server#2488](https://github.com/rabbitmq/rabbitmq-server/issues/2488)

#### Enhancements

 * [Quorum queues](https://www.rabbitmq.com/quorum-queues.html) now can use the [`reject-publish`](https://www.rabbitmq.com/maxlength.html#overflow-behaviour)
   max length overflow strategy.

   GitHub issue: [rabbitmq/rabbitmq-server#2407](https://github.com/rabbitmq/rabbitmq-server/pull/2407)

 * [Quorum queues](https://www.rabbitmq.com/quorum-queues.html) now support [consumer priority](https://www.rabbitmq.com/consumers.html#priority).

   GitHub issue: [rabbitmq/rabbitmq-server#2451](https://github.com/rabbitmq/rabbitmq-server/pull/2451)

 * Per-user connection and queue limits. This is similar to [per-vhost limits](https://www.rabbitmq.com/vhosts.html#limits) but,
   as the name suggests, these limits are associated for a given user.

   The limits are controlled using CLI tools or the HTTP API:

   ``` sh
   # limits user "user-e8d3f85c" to up to five connections and ten channels
   rabbitmqctl set_user_limits "user-e8d3f85c" '{"max-connections": 5, "max-channels": 10}'

   # clears the maximum number of connections limit for the user
   rabbitmqctl clear_user_limits "user-e8d3f85c" "max-connections"

   # clears all limits for the user
   rabbitmqctl clear_user_limits "user-e8d3f85c" "all"
   ```

   Contributed by Erlang Solutions, sponsored by [CloudAMQP](https://cloudamqp.com).

   GitHub issue: [rabbitmq/rabbitmq-server#607](https://github.com/rabbitmq/rabbitmq-server/issues/607), [rabbitmq/rabbitmq-server#2380](https://github.com/rabbitmq/rabbitmq-server/pull/2380)

 * TLSv1.3 is no longer considered experimental (on Erlang 23) and excluded from TLS listener configuration.

   GitHub issue: [rabbitmq/rabbitmq-common#415](https://github.com/rabbitmq/rabbitmq-common/issues/415)

 * When a node is put under maintenance, it will now stop all local quorum queue replicas after completing
   leadership transfer. This means that no quorum queue replicas on the node will be considered for
   leader elections.

   GitHub issue: [rabbitmq/rabbitmq-server#2474](https://github.com/rabbitmq/rabbitmq-server/issues/2474)

 * Nodes now keep track of failed client authentication attempts and expose it as a metric via both the [Prometheus endpoint](https://www.rabbitmq.com/prometheus.html)
   and the HTTP API at `GET /api/auth/attempts/{node}`.

   The tracking is done for every cluster node individually. The protocols that support authentication attempt tracking
   right now are AMQP 0-9-1, AMQP 1.0 and MQTT.

   GitHub issue: [rabbitmq/rabbitmq-server#2436](https://github.com/rabbitmq/rabbitmq-server/pull/2436)

 * `bypass_pem_cache` is a new configuration key that makes it possible to disable the cache of PEM files
   [used by the Erlang TLS implementation](https://blog.heroku.com/how-we-sped-up-sni-tls-handshakes-by-5x).
   This rotated certificates quicker to detect for nodes but can also increase latency for inbound
   TLS connections, e.g. under [high connection churn scenarios](https://www.rabbitmq.com/connections.html#high-connection-churn).

   GitHub issue: [rabbitmq/rabbitmq-server#2686](https://github.com/rabbitmq/rabbitmq-server/pull/2686)

 * Definition import now safely handles some missing queue object arguments.

   GitHub issue: [rabbitmq/rabbitmq-server#2668](https://github.com/rabbitmq/rabbitmq-server/issues/2668)

 * `rabbitmq.conf` schema now allows for [peer certificate chain verification depth](https://www.rabbitmq.com/ssl.html#peer-verification) to be set to zero.
   When this value is used, peer certificate must be [signed by a trusted CA certificate directly](https://erlang.org/doc/man/ssl.html#type-allowed_cert_chain_length) in order
   for the verification to pass.

   GitHub issue: [rabbitmq/rabbitmq-server#2493](https://github.com/rabbitmq/rabbitmq-server/issues/2493)

 * `RABBITMQ_IO_THREAD_POOL_SIZE` will no longer be respected by RabbitMQ nodes. It [is no longer relevant](http://blog.erlang.org/IO-Polling/)
   with supported Erlang versions and will simplify [`rabbitmq-diagnostics runtime_thread_stats`](https://www.rabbitmq.com/runtime.html#thread-stats) output.

   GitHub issue: [rabbitmq/rabbitmq-server#2473](https://github.com/rabbitmq/rabbitmq-server/issues/2473)

 * The `+K` [runtime parameter](https://www.rabbitmq.com/runtime.html) is no longer used by RabbitMQ nodes as it has [no effect](http://blog.erlang.org/IO-Polling/)
   with supported Erlang versions.

   Contributed by Ayanda Dube (Erlang Solutions).

   GitHub issue: [rabbitmq/rabbitmq-server#2470](https://github.com/rabbitmq/rabbitmq-server/pull/2470)


### CLI

#### Enhancements

 * It is now possible to enable all feature flags in a single command:

   ``` sh
   rabbitmqctl enable_feature_flag all
   ```

   Note that this will only enable the flags supported by all cluster members.

   GitHub issue: [rabbitmq/rabbitmq-cli#455](https://github.com/rabbitmq/rabbitmq-cli/issues/455)

 * `rabbitmq-queues peek` is a new command that allows for peeking at a queue position. It is only
   supported by quorum queues (and not classic queues):

   ``` sh
   # peeks at the head of queue "qq.1" in virtual host "staging"
   rabbitmq-queues peek --vhost "staging" "qq.1 1"
   ```

   GitHub issue: [rabbitmq/rabbitmq-cli#452](https://github.com/rabbitmq/rabbitmq-cli/pull/452/)

 * `rabbitmq-queues reclaim_quorum_memory` is a new command that forces Raft WAL compaction which in most cases should reduce memory footprint of a quorum queue:

   ``` sh
   rabbitmq-queues reclaim_quorum_memory --vhost "staging" "qq.1"
   ```

   GitHub issue: [rabbitmq/rabbitmq-cli#453](https://github.com/rabbitmq/rabbitmq-cli/pull/453)

#### Bug Fixes

 * `rabbitmqctl rename_cluster_node` failed with an error about a missing directory.

   GitHub issue: [rabbitmq/rabbitmq-cli#457](https://github.com/rabbitmq/rabbitmq-cli/issues/457)

 * `rabbitmqctl export_definitions` exported optional binding arguments as blank.

   GitHub issue: [rabbitmq/rabbitmq-server#2500](https://github.com/rabbitmq/rabbitmq-server/issues/2500)

 * Force removal of a node did not remove it from quorum queue member lists.

   GitHub issue: [rabbitmq/rabbitmq-server#2414](https://github.com/rabbitmq/rabbitmq-server/issues/2414)

 * CLI tools now pick a unique identifier from a pool. Previously the pool of possible values was theoretically
   unbounded, which could result in an atom table exhaustion condition on long running nodes that
   had a lot of CLI tool invocations (e.g. CLI tools were used to collect monitoring data frequently).

   Such use of CLI tools for [monitoring](https://www.rabbitmq.com/monitoring.html) is not recommended:
   there are better options such as [Prometheus and Grafana](https://www.rabbitmq.com/prometheus.html).

   GitHub issue: [rabbitmq/rabbitmq-cli#461](https://github.com/rabbitmq/rabbitmq-cli/pull/461)


### MQTT Plugin

#### Bug Fixes

 * Raft-based client ID tracker is now significantly more efficient in handling failing
   or closed connections. This prevents potential [high memory usage of tracking tables](https://github.com/rabbitmq/rabbitmq-server/discussions/2688)
   on the node.

   GitHub issue: [rabbitmq/rabbitmq-server#2692](https://github.com/rabbitmq/rabbitmq-server/pull/2692)

### Federation Plugin

#### Bug Fixes

 * Federation links that failed to connect due to a TCP connection timeout [leaked resources](https://www.rabbitmq.com/connections.html#monitoring).
   Other connection failure scenarios did not result in a leak.

   GitHub issue: [rabbitmq/rabbitmq-federation#119](https://github.com/rabbitmq/rabbitmq-federation/pull/119)


### Shovel Plugin

#### Bug Fixes

 * An autodeleted Shovel would re-appear on other cluster nodes after the node that hosted it originally was restarted.

   GitHub issue: [rabbitmq/rabbitmq-server#2655](https://github.com/rabbitmq/rabbitmq-server/issues/2655)

### Prometheus Plugin

#### Enhancements

 * `GET /metrics/per-object` is a new endpoint that always returns [individual entity metrics](https://www.rabbitmq.com/prometheus.html#metric-aggregation), even if
   `GET /metrics` is configured to return aggregated results.

   GitHub issue: [rabbitmq/rabbitmq-server#2659](https://github.com/rabbitmq/rabbitmq-server/pull/2659)

### Management Plugin

#### Enhancements

 * [Individual health checks](https://www.rabbitmq.com/monitoring.html#health-checks) are now available through the HTTP API.

   GitHub issue: [rabbitmq/rabbitmq-management#844](https://github.com/rabbitmq/rabbitmq-management/issues/844)

#### Bug Fixes

 * Quorum queue consumer counter on on the queue list page was not updated when consumers were cancelled or failed.

   GitHub issue: [rabbitmq/rabbitmq-server#2421](https://github.com/rabbitmq/rabbitmq-server/issues/2421)

 * The aliveness check endpoint now responds with a `503 Service Unavailable` instead of a 500 when
   it cannot publish a test message, e.g. because a policy with zero message TTL was applied to all queues.

   GitHub issue: [rabbitmq/rabbitmq-management#855](https://github.com/rabbitmq/rabbitmq-management/issues/855)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * AWS API request errors are now propagated. This means that should an AWS API request fail,
   the peer discovery subsystem will retry it a limited number of times.

   Contributed by Stefan @stefanmoser Moser.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-aws#40](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/pull/40)


### RabbitMQ Erlang Client

#### Bug Fixes

 * `amqp_channel:call/4` timeouts are now safly reconciled with connection-level timeouts.

   Contributed by Ayanda Dube.

   GitHub issue: [rabbitmq/rabbitmq-server#2660](https://github.com/rabbitmq/rabbitmq-server/pull/2660)

### Windows Installer

#### Bug Fixes

 * Windows installer is now signed by a new (rolled) key.

   GitHub issue: [rabbitmq/rabbitmq-server#2666](https://github.com/rabbitmq/rabbitmq-server/issues/2666)

 * The installer now correctly creates directories when RabbitMQ is installed to
   a different drive from the shell (`cmd.exe`).

   Contributed by Jiahao @Y2Nk4 Guo.

   GitHub issue: [rabbitmq/rabbitmq-server#2682](https://github.com/rabbitmq/rabbitmq-server/pull/2682)

## Dependency Upgrades

 * `credentials_obfuscation` was upgraded [from 2.2.3 to 2.3.0](https://github.com/rabbitmq/credentials-obfuscation/blob/master/ChangeLog.md)
 * `ranch` is [no longer a dependency](https://github.com/rabbitmq/rabbitmq-server/pull/2707) of `rabbit_common`

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.10.tar.xz`.
