## RabbitMQ 3.7.22

RabbitMQ `3.7.22` is a maintenance release that focuses on bug fixes.
RabbitMQ `3.7.x` series is supported [through March 2020](https://www.rabbitmq.com/versions.html).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * One-off Erlang VM starts used by startup scripts now do as little work as possible
   in order to avoid starting subcomponents, loading configuration and so on.

   GitHub issue: [rabbitmq/rabbitmq-common#340](https://github.com/rabbitmq/rabbitmq-common/pull/340)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl await_startup` failed with an exception when RabbitMQ application was stopped but the
    runtime (Erlang VM) was running.

   GitHub issue: [rabbitmq/rabbitmq-server#2158](https://github.com/rabbitmq/rabbitmq-server/issues/2158)


### Management Plugin

#### Bug Fixes

 * Definition import via HTTP API could fail in if performed via HTTP API (but not management UI)
   and contained operator policies.

   GitHub issue: [rabbitmq/rabbitmq-management#751](https://github.com/rabbitmq/rabbitmq-management/issues/751)

 * When a node cannot compute the number of file descriptors it uses, it will be more resilient and will
   log warnings (e.g. about missing `handle.exe` in `PATH` on Windows) much more proactively.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#86](https://github.com/rabbitmq/rabbitmq-management-agent/issues/86)

#### Enhancements

 * Metric aggregation optimizations.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#84](https://github.com/rabbitmq/rabbitmq-management-agent/pull/84)


### MQTT Plugin

#### Enhancements

 * Throughput improvements and reduced CPU usage but slightly higher per connection RAM footprint.

   Contributed by Grigory Starinkin (Erlang Solutions).

   GitHub issues: [rabbitmq/rabbitmq-mqtt#216](https://github.com/rabbitmq/rabbitmq-mqtt/pull/216), [rabbitmq/rabbitmq-mqtt#217](https://github.com/rabbitmq/rabbitmq-mqtt/pull/217)

#### Bug Fixes

 * Last Will messages that use QoS 2 will now be downgraded to QoS 1 just like with "regular" published messages.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#214](https://github.com/rabbitmq/rabbitmq-mqtt/issues/214)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.22.tar.xz`.
