RabbitMQ `3.11.3` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Server

#### Bug Fixes

 * Stream unsubscription leaked metric counters.

   GitHub issue: [#6325](https://github.com/rabbitmq/rabbitmq-server/pull/6325)

 * Stream could become unavailable in certain node or network failure scenarios.

   GitHub issue: [#6179](https://github.com/rabbitmq/rabbitmq-server/issues/6179)

#### Enhancements

 * It is now possible to pre-configure virtual host limits for groups of virtual hosts.
   This is done using a set of new keys supported by `rabbitmq.conf`:

   ``` ini
   default_limits.vhosts.1.pattern = ^device
   default_limits.vhosts.1.max_connections = 10
   default_limits.vhosts.1.max_queues = 10

   default_limits.vhosts.2.pattern = ^system
   default_limits.vhosts.2.max_connections = 100
   default_limits.vhosts.2.max_queues = -1

   default_limits.vhosts.3.pattern = .*
   default_limits.vhosts.3.max_connections = 20
   default_limits.vhosts.3.max_queues = 20
   ```

   Contributed by @illotum (AWS).

   GitHub issue: [#4999](https://github.com/rabbitmq/rabbitmq-server/issues/4999)

 * Quorum queue replicas no longer try to contact their unreachable peers for metrics.
   Previously this could result in a 30-40s delay for certain HTTP API requests that list queue metrics
   if one or more cluster members were down or stopped.

   GitHub issues: [#6282](https://github.com/rabbitmq/rabbitmq-server/pull/6282), [#6285](https://github.com/rabbitmq/rabbitmq-server/pull/6285)


### CLI Tools

#### Bug Fixes

  * `rabbitmq-diagnostics status` now handles server responses where free disk space
    is not yet computed. This is the case with nodes early in the boot process.

    GitHub issue: [#6303](https://github.com/rabbitmq/rabbitmq-server/pull/6303)

  * When a plugin was enabled as a dependency (e.g. `rabbitmq_shovel` as a dependency of `rabbitmq_shovel_management`),
    CLI tools previously did not discover commands in such plugins. Only explicitly enabled or [pre-configured](https://www.rabbitmq.com/plugins.html#enabled-plugins-file)
    plugins were scanned for commands.

    This behavior was confusing. Now all enabled (explicitly or as a dependency) plugins are scanned.

    Contributed by @SimonUnge (AWS).

    GitHub issue: [#6020](https://github.com/rabbitmq/rabbitmq-server/issues/6020)

  * `rabbitmq-diagnostics memory_breakdown` now returns results much faster in environments with a large number
    of quorum queues (say, tens or hundreds of thousands).

    GitHub issue: [#6390](https://github.com/rabbitmq/rabbitmq-server/pull/6390)


### Stream Plugin

#### Bug Fixes

  * Addition of a stream member could fail if the node being added was very early in its boot process
    (and doesn't have a certain stream-related components started).

    GitHub issue: [#6182](https://github.com/rabbitmq/rabbitmq-server/pull/6182)


### AMQP 1.0 Plugin

#### Enhancements

  * Support for "modified" disposition outcome used by some client libraries (such as QPid).

    GitHub issue: [#6243](https://github.com/rabbitmq/rabbitmq-server/pull/6243)


### Prometheus Plugin

#### Bug Fixes

  * Abruptly closed client connections resulted in incorrect updates of certain global
    metric counters.

    GitHub issue: [#5462](https://github.com/rabbitmq/rabbitmq-server/issues/5462)


### Management Plugin

#### Bug Fixes

  * Management UI links now include "noopener" and "noreferrer" attributes to protect
    them against [reverse tabnabbing](https://owasp.org/www-community/attacks/Reverse_Tabnabbing).
    Note that since management UI only includes a small number of external links to trusted resources,
    reverse tabnabbing is unlikely to affect most users. However, it can show up in security scanner results
    and become an issue in environments where a modified version of RabbitMQ is offered as a service.

    Contributed by @illotum (AWS).

    GitHub issue: [#6211](https://github.com/rabbitmq/rabbitmq-server/pull/6211)


### Shovel Plugin

#### Bug Fixes

  * Plugin could stop in environments where no static Shovels were defined and a specific
    sequence of events happens at the same time.

    Contributed by @gomoripeti (CloudAMQP).

    GitHub issue: [#6286](https://github.com/rabbitmq/rabbitmq-server/pull/6286)

#### Enhancements

  * Shovel now handles `connection.blocked` and `connection.unblocked` notifications
    from remote destination nodes. This means fewer messages are kept in Shovel buffers when
    a resource alarm goes into affect on the destination node.

    Contributed by @gomoripeti (CloudAMQP).

    GitHub issue: [#6224](https://github.com/rabbitmq/rabbitmq-server/pull/6224)

### Windows Installer

#### Bug Fixes

 * When installation directory was overridden,
   the plugins directory did not respect the updated
   base installation path.

   GitHub issue: [rabbitmq/rabbitmq-packaging#29](https://github.com/rabbitmq/rabbitmq-packaging/pull/29)

## Dependency Upgrades

 * `ra` was upgraded [from `2.3.0` to `2.4.1`](https://github.com/rabbitmq/ra/releases)
 * `osiris` was upgraded [from `1.3.1` to `1.3.3`](https://github.com/rabbitmq/osiris/tags)
 * `seshat` was upgraded [from `0.3.2` to `0.4.0`](https://github.com/rabbitmq/seshat/tags)
 * `credentials_obfuscation` was upgraded [from `3.0.0` to `3.2.0`](https://github.com/rabbitmq/credentials-obfuscation/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.3.tar.xz`
instead of the source tarball produced by GitHub.
