RabbitMQ `3.10.13` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires Erlang 24.2 and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ requires Erlang 24.2 or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * Backported a number of free disk space monitor resiliency improvements.

   GitHub issue: [#5831](https://github.com/rabbitmq/rabbitmq-server/pull/5831)

 * If `handle.exe` is not available, free disk space monitor will now shell out to PowerShell
   to retrieve the number of open file handles used by the node.

   GitHub issue: [#6613](https://github.com/rabbitmq/rabbitmq-server/issues/6613)

 * `raft.adaptive_failure_detector.poll_interval` exposes [`aten`]()'s `poll_interval` setting to
   RabbitMQ users. Increasing it can reduce the probability of false positives in clusters where
   inter-node communication links are used at close to maximum capacity.
   The default is `5000` (5 seconds).

   GitHub issue: [#6632](https://github.com/rabbitmq/rabbitmq-server/pull/6632)

 * When both `disk_free_limit.relative` and `disk_free_limit.absolute`,
   or both `vm_memory_high_watermark.relative` and `vm_memory_high_watermark.absolute` are set,
   the absolute settings will now take precedence.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#4980](https://github.com/rabbitmq/rabbitmq-server/issues/4980)

 * Closing channels will now log a warning if they had any messages pending a [confirmation from the server](https://www.rabbitmq.com/publishers.html#data-safety).

   Contributed by @Kiruamvp.

   GitHub issue: [#6526](https://github.com/rabbitmq/rabbitmq-server/pull/6526)

#### Bug Fixes

 * Classic queues with [Single Active Consumer](https://www.rabbitmq.com/consumers.html#single-active-consumer) enabled could run into an exception.

   GitHub issue: [#6513](https://github.com/rabbitmq/rabbitmq-server/pull/6513)

 * When a [global parameter](https://www.rabbitmq.com/parameters.html#parameter-management) was cleared,
   nodes emitted an [internal event](https://www.rabbitmq.com/logging.html#internal-events) of the wrong type.

   GitHub issue: [#6540](https://github.com/rabbitmq/rabbitmq-server/pull/6540)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-queues grow` and `rabbitmq-queues shrink` misformatted the errors
   they could encounter.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#6601](https://github.com/rabbitmq/rabbitmq-server/pull/6601)

#### Enhancements

 * New key supported by `rabbitmqctl list_queues`: `effective_policy_definition` that returns
   merged definitions of regular and [operator policies](https://www.rabbitmq.com/parameters.html#operator-policies) effective for the queue.

   GitHub issue: [#6556](https://github.com/rabbitmq/rabbitmq-server/pull/6556)

### Management Plugin

#### Enhancements

 * New HTTP API endpoint, `GET /api/config/effective`, returns effective node configuration.
   This is an HTTP API counterpart of `rabbitmq-diagnostics environment`.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#6016](https://github.com/rabbitmq/rabbitmq-server/issues/6016)

### Sharding Plugin

#### Bug Fixes

 * Plugin could fail to boot and halt node boot due to incorrect boot step
   metadata.

   GitHub issue: [#6583](https://github.com/rabbitmq/rabbitmq-server/pull/6583)

## Dependency Upgrades

 * `ra` was upgraded [from `2.4.1` to `2.4.5`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.13.tar.xz`
instead of the source tarball produced by GitHub.
