/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// EndpointsLister helps list Endpoints.
// All objects returned here must be treated as read-only.
type EndpointsLister interface {
	// List lists all Endpoints in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1.Endpoints, err error)
	// Endpoints returns an object that can list and get Endpoints.
	Endpoints(namespace string) EndpointsNamespaceLister
	EndpointsListerExpansion
}

// endpointsLister implements the EndpointsLister interface.
type endpointsLister struct {
	listers.ResourceIndexer[*corev1.Endpoints]
}

// NewEndpointsLister returns a new EndpointsLister.
func NewEndpointsLister(indexer cache.Indexer) EndpointsLister {
	return &endpointsLister{listers.New[*corev1.Endpoints](indexer, corev1.Resource("endpoints"))}
}

// Endpoints returns an object that can list and get Endpoints.
func (s *endpointsLister) Endpoints(namespace string) EndpointsNamespaceLister {
	return endpointsNamespaceLister{listers.NewNamespaced[*corev1.Endpoints](s.ResourceIndexer, namespace)}
}

// EndpointsNamespaceLister helps list and get Endpoints.
// All objects returned here must be treated as read-only.
type EndpointsNamespaceLister interface {
	// List lists all Endpoints in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1.Endpoints, err error)
	// Get retrieves the Endpoints from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*corev1.Endpoints, error)
	EndpointsNamespaceListerExpansion
}

// endpointsNamespaceLister implements the EndpointsNamespaceLister
// interface.
type endpointsNamespaceLister struct {
	listers.ResourceIndexer[*corev1.Endpoints]
}
