/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.palette;

import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.XWTDesignerPlugin;
import org.eclipse.xwt.tools.ui.designer.dialogs.PropertyValueDialog;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.xwt.tools.ui.xaml.tools.AnnotationTools;

public class InitializeHelper {
    public static boolean checkValue(XamlNode node) {
        XamlAttribute a;
        IProperty property;
        if (!XWTDesignerPlugin.getDefault().getPreferenceStore().getBoolean("Prompt for widget name during creation.")) {
            return true;
        }
        if (node == null) {
            return false;
        }
        XamlNode cursorNode = InitializeHelper.getCursorNode(node);
        if (cursorNode != null && cursorNode instanceof XamlAttribute && (property = XWTUtility.getProperty(a = (XamlAttribute)cursorNode)) != null) {
            PropertyValueDialog dialog;
            Object init = "";
            if ("text".equals(property.getName())) {
                String name = node.getName();
                init = "New" + name;
            }
            if ((dialog = new PropertyValueDialog(new Shell(), property, (String)init)).open() == 0) {
                a.setValue(dialog.getResult());
            } else {
                return false;
            }
        }
        return true;
    }

    private static XamlNode getCursorNode(XamlNode parent) {
        if (parent == null) {
            return null;
        }
        boolean isAnnotated = AnnotationTools.isAnnotated((XamlNode)parent, (String)"CURSOR_DATA_ANN");
        if (isAnnotated) {
            return parent;
        }
        EList attributes = parent.getAttributes();
        for (XamlAttribute a : attributes) {
            XamlNode node = InitializeHelper.getCursorNode((XamlNode)a);
            if (node == null) continue;
            return node;
        }
        EList childNodes = parent.getChildNodes();
        for (XamlElement c : childNodes) {
            XamlNode node = InitializeHelper.getCursorNode((XamlNode)c);
            if (node == null) continue;
            return node;
        }
        return null;
    }
}

