/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.PropertyUtil;

public class Property {
    private IObservable parent;
    private Property parentProperty;
    private String name;
    private Class<?> type;
    private List<Property> properties;

    Property(Property parentProperty, String name, Class<?> type) {
        this((IObservable)null, name, type);
        this.parentProperty = parentProperty;
    }

    Property(IObservable parent, String name, Class<?> type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public Property[] getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
            if (!this.isPrimitive()) {
                if (this.type.isArray()) {
                    System.out.println("Array");
                } else if (Collection.class.isAssignableFrom(this.type)) {
                    System.out.println("Collection");
                } else {
                    Map<String, Class<?>> propertiesMap = PropertyUtil.getProperties(this.type);
                    Set<Map.Entry<String, Class<?>>> entrySet = propertiesMap.entrySet();
                    for (Map.Entry<String, Class<?>> entry : entrySet) {
                        this.properties.add(new Property(this, entry.getKey(), entry.getValue()));
                    }
                }
            }
        }
        return this.properties.toArray(new Property[0]);
    }

    private boolean isPrimitive() {
        return this.type.isPrimitive() || String.class == this.type || Image.class == this.type || Color.class == this.type || Point.class == this.type || Rectangle.class == this.type || Font.class == this.type;
    }

    public String getName() {
        return this.name;
    }

    public IObservable getParent() {
        if (this.parent == null && this.parentProperty != null) {
            this.parent = this.parentProperty.getParent();
        }
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getProperties().length > 0;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String thisName;
        String string = thisName = this.name == null ? "" : this.name;
        if (this.parentProperty != null && this.parentProperty.name != null) {
            return this.parentProperty.name + "." + thisName;
        }
        return thisName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * this.toString().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return this.toString().equalsIgnoreCase(other.toString());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Property getProperty(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        if (propertyName.startsWith("(") && propertyName.endsWith(")")) {
            return this.getDetailProperty(propertyName);
        }
        int index = propertyName.indexOf(".");
        if (index != -1) {
            String parentName = propertyName.substring(0, index);
            propertyName = propertyName.substring(index + 1);
            Property parent = this.getProperty(parentName);
            return parent.getProperty(propertyName);
        }
        Property[] children = this.getProperties();
        if (children == null) {
            return null;
        }
        Property[] propertyArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Property p = propertyArray[n2];
            if (propertyName.equalsIgnoreCase(p.getName())) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    private Property getDetailProperty(String propertyName) {
        return this;
    }
}

