/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xwt.vex.problems.IProblemChecker;
import org.eclipse.xwt.vex.problems.Problem;
import org.w3c.dom.Node;

public abstract class AbstractProblemChecker
implements IProblemChecker {
    protected IJavaProject getJavaProject(StructuredTextEditor fTextEditor) {
        return JavaCore.create((IProject)this.getFile(fTextEditor).getProject());
    }

    protected IFile getFile(StructuredTextEditor fTextEditor) {
        return (IFile)fTextEditor.getEditorInput().getAdapter(IFile.class);
    }

    protected Node getRoot(StructuredTextEditor fTextEditor) {
        StructuredTextViewer textViewer = fTextEditor.getTextViewer();
        if (textViewer == null) {
            return null;
        }
        IndexedRegion root = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)0);
        if (root instanceof Node) {
            return (Node)root;
        }
        return null;
    }

    protected Node getNode(StructuredTextEditor textEditor) {
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        if (textViewer == null) {
            return null;
        }
        StyledText textWidget = textViewer.getTextWidget();
        if (textWidget == null || textWidget.isDisposed()) {
            return null;
        }
        int offset = 0;
        try {
            offset = textWidget.getCaretOffset();
        }
        catch (Exception e) {
            return null;
        }
        if (offset == 0) {
            return null;
        }
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        if (treeNode instanceof Node) {
            return (Node)treeNode;
        }
        return null;
    }

    protected Problem createProblem(StructuredTextEditor fTextEditor, Node node, String msg, int type) {
        int startOffset = 0;
        if (node instanceof IDOMNode) {
            startOffset = ((IDOMNode)node).getStartOffset();
        }
        int endOffset = 0;
        if (node instanceof IDOMNode) {
            endOffset = ((IDOMNode)node).getEndOffset();
        }
        int line = 0;
        try {
            StructuredTextViewer textViewer = fTextEditor.getTextViewer();
            if (textViewer != null) {
                line = textViewer.getDocument().getLineOfOffset(startOffset) + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.createProblem(msg, type, node, startOffset, endOffset, line);
    }

    protected Problem createProblem(String message, int type, Object source, int start, int end, int line) {
        Problem problem = new Problem(message, type);
        problem.setSource(source);
        problem.start = start;
        problem.end = end;
        problem.line = line;
        return problem;
    }

    protected boolean isValid(Node node) {
        if (node == null) {
            return false;
        }
        String nodeName = node.getNodeName();
        return nodeName != null && !nodeName.equals("") && !nodeName.equals("#text");
    }

    protected String getTagName(Node node) {
        if (!this.isValid(node)) {
            return null;
        }
        return node.getNodeName();
    }

    public List<Problem> checkProblems(StructuredTextEditor textEditor, String javaName) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Node root = this.getRoot(textEditor);
        this.checkProblems(textEditor, javaName, root, problems, true);
        return problems;
    }

    protected abstract void checkProblems(StructuredTextEditor var1, String var2, Node var3, List<Problem> var4, boolean var5);

    public boolean canChecked(StructuredTextEditor textEditor, String javaName) {
        return this.getRoot(textEditor) != null;
    }
}

