/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.xwt.ui.utils.ProjectContext;
import org.eclipse.xwt.vex.VEXFileChecker;
import org.eclipse.xwt.vex.problems.IProblemChecker;
import org.eclipse.xwt.vex.problems.Problem;
import org.eclipse.xwt.vex.problems.ProblemCheckerRegistry;

public class XWTFileChecker
implements VEXFileChecker {
    public static final String EXTENSION_ID = "org.eclipse.xwt.tools.ui.editor.problemchecker";
    private final String MARKER_ID = "org.eclipse.xwt.tools.ui.editor.XAMLEditorMaker";
    private StructuredTextEditor fTextEditor = null;

    public XWTFileChecker(StructuredTextEditor fTextEditor) {
        this.fTextEditor = fTextEditor;
    }

    public void doCheck(String javaName) {
        ProjectContext.stop();
        this.deleteMarkers();
        List allCheckers = ProblemCheckerRegistry.INSTANCE.getCheckers(EXTENSION_ID);
        if (allCheckers.isEmpty()) {
            return;
        }
        ArrayList problems = new ArrayList();
        for (IProblemChecker checker : allCheckers) {
            List subs;
            if (!checker.canChecked(this.fTextEditor, javaName) || (subs = checker.checkProblems(this.fTextEditor, javaName)) == null) continue;
            problems.addAll(subs);
        }
        if (problems.isEmpty()) {
            return;
        }
        IFile file = (IFile)this.fTextEditor.getEditorInput().getAdapter(IFile.class);
        for (Problem problem : problems) {
            this.makeMaker(file, problem);
        }
        ProjectContext.start();
    }

    private void makeMaker(IFile file, Problem problem) {
        try {
            IMarker marker = file.createMarker("org.eclipse.xwt.tools.ui.editor.XAMLEditorMaker");
            marker.setAttribute("transient", true);
            marker.setAttribute("message", (Object)problem.getMessage());
            marker.setAttribute("charStart", problem.start);
            marker.setAttribute("charEnd", problem.end);
            int type = problem.getType();
            switch (type) {
                case 3: {
                    marker.setAttribute("severity", 2);
                    break;
                }
                case 2: {
                    marker.setAttribute("severity", 0);
                    break;
                }
                case 1: {
                    marker.setAttribute("severity", 1);
                }
            }
            marker.setAttribute("lineNumber", problem.line);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void deleteMarkers() {
        IFile file = (IFile)this.fTextEditor.getEditorInput().getAdapter(IFile.class);
        try {
            file.deleteMarkers(null, true, 2);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

