/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.emf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.emf.EMFHelper;

public class EMFDataModelService
implements IDataProvider.DataModelService {
    private static Map<Object, EClassifier> lookupTable = Collections.synchronizedMap(new HashMap());

    public Object toModelType(Object data) {
        return EMFHelper.toType(data);
    }

    public Object loadModelType(String className) {
        return EMFDataModelService.determineModelType(className);
    }

    public static Object determineModelType(String className) {
        EClassifier ret = lookupTable.get(className);
        if (ret != null) {
            return ret;
        }
        EPackage.Registry reg = EPackage.Registry.INSTANCE;
        ArrayList paks = new ArrayList(reg.keySet());
        for (String uri : paks) {
            EPackage pak = reg.getEPackage(uri);
            for (EClassifier ec : pak.getEClassifiers()) {
                boolean found = ec.getInstanceClass().getName().equals(className);
                if (!found) continue;
                lookupTable.put(className, ec);
                return ec;
            }
        }
        return null;
    }

    public static Object determineModelType(Class<?> clazz) {
        EClassifier ret = lookupTable.get(clazz);
        if (ret != null) {
            return ret;
        }
        EPackage.Registry reg = EPackage.Registry.INSTANCE;
        ArrayList paks = new ArrayList(reg.keySet());
        for (String uri : paks) {
            EPackage pak = reg.getEPackage(uri);
            for (EClassifier ec : pak.getEClassifiers()) {
                boolean found;
                boolean bl = found = ec.getInstanceClass() == clazz;
                if (!found) continue;
                lookupTable.put(clazz, ec);
                return ec;
            }
        }
        return null;
    }

    public Object toModelPropertyType(Object object, String propertyName) {
        EClass type = null;
        if (object instanceof EClass) {
            type = (EClass)object;
        } else if (object instanceof EObject) {
            type = ((EObject)object).eClass();
        } else if (object instanceof Class) {
            type = (EClass)EMFDataModelService.determineModelType((Class)object);
        }
        if (type == null) {
            throw new XWTException(" Type for\"" + propertyName + "\" is not found ");
        }
        EStructuralFeature structuralFeature = type.getEStructuralFeature(propertyName);
        if (structuralFeature == null) {
            throw new XWTException(" Property \"" + propertyName + "\" is not found in the class " + type.getName());
        }
        return structuralFeature.getEType();
    }
}

