/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.jface.resource.ColorRegistryInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.color.ColorPropertyEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.swt.model.property.ColorPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.junit.jupiter.api.Test;

public class ColorPropertyEditorTestRegistry
extends ColorPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_info() throws Exception {
        this.createASTCompilationUnit("test", "MyRegistry.java", this.getTestSource("public class MyRegistry extends ColorRegistry {", "  public static final String R_KEY = '_r_key_';", "  public MyRegistry() {", "    put(R_KEY, new RGB(10, 10, 10));", "  }", "}"));
        ColorPropertyEditorTestRegistry.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "  }", "}");
        shell.refresh();
        List children = shell.getChildren(RegistryContainerInfo.class);
        ColorPropertyEditorTestRegistry.assertEquals((int)1, (int)children.size());
        RegistryContainerInfo containerInfo = (RegistryContainerInfo)children.get(0);
        ColorPropertyEditorTestRegistry.assertSame((Object)containerInfo, (Object)RegistryContainerInfo.get((JavaInfo)shell));
        List colors = containerInfo.getChildren(ColorRegistryInfo.class);
        ColorPropertyEditorTestRegistry.assertEquals((int)1, (int)colors.size());
        ColorRegistryInfo colorRegistryInfo = (ColorRegistryInfo)colors.get(0);
        List keyFields = colorRegistryInfo.getKeyFields();
        ColorPropertyEditorTestRegistry.assertEquals((int)1, (int)keyFields.size());
        KeyFieldInfo keyFieldInfo = (KeyFieldInfo)keyFields.get(0);
        ColorPropertyEditorTestRegistry.assertEquals((Object)"R_KEY", (Object)keyFieldInfo.keyName);
        ColorPropertyEditorTestRegistry.assertEquals((Object)"_r_key_", (Object)keyFieldInfo.keyValue);
        ColorPropertyEditorTestRegistry.assertNull((Object)keyFieldInfo.value);
    }

    @Test
    public void test_value() throws Exception {
        this.createASTCompilationUnit("test", "MyRegistry.java", this.getTestSource("public class MyRegistry extends ColorRegistry {", "  public static final String R_KEY = '_r_key_';", "  public MyRegistry() {", "    put(R_KEY, new RGB(10, 10, 10));", "  }", "}"));
        ColorPropertyEditorTestRegistry.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "    setBackground(registry.get(MyRegistry.R_KEY));", "  }", "}");
        shell.refresh();
        Property property = shell.getPropertyByTitle("background");
        ColorPropertyEditorTestRegistry.assertEquals((Object)"registry - R_KEY", (Object)PropertyEditorTestUtils.getText(property));
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
        ColorPropertyEditorTestRegistry.assertEquals((Object)"new org.eclipse.swt.graphics.Color(null, 10, 10, 10)", (Object)PropertyEditorTestUtils.getClipboardSource(property));
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
        ColorPropertyEditorTestRegistry.assertEquals((Object)ColorPropertyEditor.getInvocationSource((JavaInfo)shell, (int)10, (int)10, (int)10), (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }
}

