/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridColumnInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.swt.model.jface.ViewerTest;
import org.junit.jupiter.api.Test;

public class GridLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parseEmpty() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        shell.refresh();
    }

    @Test
    public void test_doubleConvertTo_GridData2() throws Exception {
        this.parseComposite("class Test extends Composite {", "  Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    new Button(this, SWT.NONE);", "  }", "  public Point computeSize(int wHint, int hHint, boolean changed) {", "    return super.computeSize(600, 490, false);", "  }", "}");
        this.refresh();
        GridLayoutTest.assertNoErrors(this.m_lastParseInfo);
    }

    @Test
    public void test_excludeFillersFromPresentationChildren_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo filler = (ControlInfo)shell.getChildrenControls().get(1);
        IObjectPresentation presentation = shell.getPresentation();
        List presentationChildren = presentation.getChildrenTree();
        ((ListAssert)Assertions.assertThat((List)presentationChildren).contains((Object[])new ObjectInfo[]{button})).doesNotContain((Object[])new ObjectInfo[]{filler});
        presentationChildren = presentation.getChildrenGraphical();
        ((ListAssert)Assertions.assertThat((List)presentationChildren).contains((Object[])new ObjectInfo[]{button})).doesNotContain((Object[])new ObjectInfo[]{filler});
    }

    @Test
    public void test_excludeFillersFromPresentationChildren_2() throws Exception {
        GridLayoutTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public Label createLabel(Composite parent) {", "    return new Label(parent, SWT.NONE);", "  }", "}"));
        GridLayoutTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  private final MyFactory factory = new MyFactory();", "  Test() {", "    setLayout(new GridLayout());", "    factory.createLabel(this);", "  }", "}");
        shell.refresh();
        GridLayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /factory.createLabel(this)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {instance factory: {field-initializer: factory} createLabel(org.eclipse.swt.widgets.Composite)} {empty} {/factory.createLabel(this)/}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "  {instance factory container}", "    {new: test.MyFactory} {field-initializer: factory} {/new MyFactory()/ /factory.createLabel(this)/}");
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        IObjectPresentation presentation = shell.getPresentation();
        List presentationChildren = presentation.getChildrenTree();
        Assertions.assertThat((List)presentationChildren).contains((Object[])new ObjectInfo[]{label});
    }

    @Test
    public void test_fillersWith_setText() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    new Label(this, SWT.NONE).setText('txt');", "  }", "}");
        shell.refresh();
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        IObjectPresentation presentation = shell.getPresentation();
        List presentationChildren = presentation.getChildrenTree();
        Assertions.assertThat((List)presentationChildren).contains((Object[])new ObjectInfo[]{label});
        presentationChildren = presentation.getChildrenGraphical();
        Assertions.assertThat((List)presentationChildren).contains((Object[])new ObjectInfo[]{label});
    }

    @Test
    public void test_fillersWithout_setText() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    new Label(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        IObjectPresentation presentation = shell.getPresentation();
        List presentationChildren = presentation.getChildrenTree();
        Assertions.assertThat((List)presentationChildren).doesNotContain((Object[])new ObjectInfo[]{label});
        presentationChildren = presentation.getChildrenGraphical();
        Assertions.assertThat((List)presentationChildren).doesNotContain((Object[])new ObjectInfo[]{label});
    }

    @Test
    public void test_fixGrid_noControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ReflectionUtils.invokeMethod((Object)layout, (String)"fixGrid()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "  }", "}");
    }

    @Test
    public void test_fixGrid_leadingImplicitControls() throws Exception {
        GridLayoutTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  public MyShell() {", "    setLayout(new GridLayout());", "    new Text(this, SWT.NONE);", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends MyShell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ReflectionUtils.invokeMethod((Object)layout, (String)"fixGrid()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends MyShell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_gridInfo() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('222');", "    }", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button_0 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(3);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(4);
        IGridInfo gridInfo = layout.getGridInfo();
        GridLayoutTest.assertNotNull((Object)gridInfo);
        GridLayoutTest.assertEquals((int)2, (int)gridInfo.getColumnCount());
        GridLayoutTest.assertEquals((int)3, (int)gridInfo.getRowCount());
        int[] columnOrigins = layout.getColumnOrigins();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        GridLayoutTest.assertEquals((int)columnOrigins.length, (int)columnIntervals.length);
        int i = 0;
        while (i < columnOrigins.length) {
            int origin = columnOrigins[i];
            Interval interval = columnIntervals[i];
            GridLayoutTest.assertEquals((int)origin, (int)interval.begin());
            ++i;
        }
        int[] rowOrigins = layout.getRowOrigins();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        GridLayoutTest.assertEquals((int)rowOrigins.length, (int)rowIntervals.length);
        GridLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_0));
        GridLayoutTest.assertEquals((Object)new Rectangle(1, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_1));
        GridLayoutTest.assertEquals((Object)new Rectangle(0, 2, 2, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_2));
        Rectangle rectangle = gridInfo.getCellsRectangle(new Rectangle(0, 0, 1, 1));
        GridLayoutTest.assertEquals((int)5, (int)rectangle.x);
        GridLayoutTest.assertEquals((int)5, (int)rectangle.y);
        GridLayoutTest.assertFalse((boolean)gridInfo.isRTL());
        GridLayoutTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)gridInfo.getInsets());
        GridLayoutTest.assertTrue((boolean)gridInfo.hasVirtualColumns());
        GridLayoutTest.assertTrue((boolean)gridInfo.hasVirtualRows());
        GridLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualColumnSize());
        GridLayoutTest.assertEquals((int)5, (int)gridInfo.getVirtualColumnGap());
        GridLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualRowSize());
        GridLayoutTest.assertEquals((int)5, (int)gridInfo.getVirtualRowGap());
        GridLayoutTest.assertSame((Object)button_0, (Object)gridInfo.getOccupied(0, 0));
        GridLayoutTest.assertSame((Object)button_1, (Object)gridInfo.getOccupied(1, 1));
        GridLayoutTest.assertSame((Object)button_2, (Object)gridInfo.getOccupied(0, 2));
        GridLayoutTest.assertSame((Object)button_2, (Object)gridInfo.getOccupied(1, 2));
        GridLayoutTest.assertNull((Object)gridInfo.getOccupied(1, 0));
        GridLayoutTest.assertNull((Object)gridInfo.getOccupied(0, 1));
    }

    @Test
    public void test_gridInfo2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setSize(300, 200);", "    setLayout(new GridLayout());", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button_0 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(1);
        shell.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        GridLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_0));
        GridLayoutTest.assertEquals((Object)new Rectangle(0, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_1));
    }

    @Test
    public void test_gridInfo_empty() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        GridLayoutTest.assertEquals((int)0, (int)gridInfo.getRowIntervals().length);
        GridLayoutTest.assertEquals((int)0, (int)gridInfo.getColumnIntervals().length);
    }

    @Test
    public void test_gridInfo_tooBigHorizontalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 10;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        IGridInfo gridInfo = layout.getGridInfo();
        GridLayoutTest.assertEquals((int)1, (int)gridInfo.getColumnCount());
        GridLayoutTest.assertEquals((int)1, (int)gridInfo.getRowCount());
        GridLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button));
    }

    @Test
    public void test_gridInfo_implicitControls() throws Exception {
        this.prepareShell_withImplicit();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)GridLayoutTest.getJavaInfoByName("button");
        IGridInfo gridInfo = layout.getGridInfo();
        GridLayoutTest.assertEquals((int)2, (int)gridInfo.getColumnCount());
        GridLayoutTest.assertEquals((int)2, (int)gridInfo.getRowCount());
        GridLayoutTest.assertSame((Object)shell, (Object)gridInfo.getOccupied(0, 0));
        GridLayoutTest.assertSame((Object)shell, (Object)gridInfo.getOccupied(1, 0));
        GridLayoutTest.assertSame((Object)button, (Object)gridInfo.getOccupied(0, 1));
        GridLayoutTest.assertSame(null, (Object)gridInfo.getOccupied(1, 1));
    }

    @Test
    public void test_canChangeDimensions_explicit() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridLayoutTest.assertTrue((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_canChangeDimensions_implicit() throws Exception {
        this.prepareShell_withImplicit();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridLayoutTest.assertFalse((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_canChangeDimensions_implicit_withoutControls() throws Exception {
        this.prepareShell_withImplicitEmpty();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridLayoutTest.assertTrue((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_setCells_horizontalSpan_inc() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "x"));
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "y"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "width"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "height"));
        layout.command_setCells(button, new Rectangle(0, 0, 2, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));", "      button.setText('000');", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "x"));
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "y"));
        GridLayoutTest.assertEquals((int)2, (int)GridLayoutTest.getInt(gridData, "width"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "height"));
    }

    @Test
    public void test_setCells_horizontalSpan_dec() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        layout.command_setCells(button, new Rectangle(0, 0, 1, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_setCells_horizontalSpan_incToEmptyColumns() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(5, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "    {", "      Button toResize = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 3;", "        toResize.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo toResize = (ControlInfo)GridLayoutTest.getJavaInfoByName("toResize");
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(5, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button toResize = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 3;", "        toResize.setLayoutData(gridData);", "      }", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
        GridLayoutTest.assertEquals((int)5, (int)layout.getColumns().size());
        GridLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.command_setCells(toResize, new Rectangle(0, 1, 5, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(5, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button toResize = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 5;", "        toResize.setLayoutData(gridData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setCells_verticalSpan_inc() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "x"));
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "y"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "width"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "height"));
        layout.command_setCells(button, new Rectangle(0, 0, 1, 2), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 2));", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "x"));
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "y"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "width"));
        GridLayoutTest.assertEquals((int)2, (int)GridLayoutTest.getInt(gridData, "height"));
    }

    @Test
    public void test_setCells_verticalSpan_dec() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.verticalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('111');", "    }", "    new Label(this, SWT.RIGHT);", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        layout.command_setCells(button, new Rectangle(1, 1, 1, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_setCells_move() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "    Button button_11 = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button_01 = (ControlInfo)shell.getChildrenControls().get(2);
        layout.command_setCells(button_01, new Rectangle(1, 0, 1, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button_11 = new Button(this, SWT.NONE);", "  }", "}");
        ControlInfo filler = (ControlInfo)shell.getChildrenControls().get(2);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)filler);
        GridLayoutTest.assertEquals((int)0, (int)GridLayoutTest.getInt(gridData, "x"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "y"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "width"));
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "height"));
    }

    @Test
    public void test_setSizeHint_width() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        layout.command_setSizeHint(button, true, new Dimension(200, -1));
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gridData.widthHint = 200;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setSizeHint_height() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        layout.command_setSizeHint(button, false, new Dimension(-1, 50));
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gridData.heightHint = 50;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_delete_replaceWithFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_10 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "    Button button_11 = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button_01 = (ControlInfo)shell.getChildrenControls().get(2);
        button_01.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_10 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button_11 = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_delete_keepOneColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
    }

    @Test
    public void test_delete_removeEmptyDimensions() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(5);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutTest.assertEquals((int)1, (int)GridLayoutTest.getInt(gridData, "x"));
        GridLayoutTest.assertEquals((int)2, (int)GridLayoutTest.getInt(gridData, "y"));
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inEmptyCell() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 1, true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, true, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumnRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 0, true, 0, true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        newButton.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 0, false, 2, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 2, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendColumnRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 1, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumnHorizontalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, true, 1, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 3;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertRowVerticalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.verticalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 1, true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.verticalSpan = 3;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_notBalanced() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 1, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Shell_open() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new GridLayout(1, false));", "    shell.open();", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 0, false);
        this.assertEditor("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new GridLayout(2, false));", "    new Label(shell, SWT.NONE);", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    shell.open();", "  }", "}");
    }

    @Test
    public void test_CREATE_Shell_layout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new GridLayout(1, false));", "    shell.layout();", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 0, false);
        this.assertEditor("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new GridLayout(2, false));", "    new Label(shell, SWT.NONE);", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    shell.layout();", "  }", "}");
    }

    @Test
    public void test_implicitLayout_isExplicitRow() throws Exception {
        this.prepareShell_withImplicit();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        GridLayoutTest.assertFalse((boolean)layout.isExplicitRow(0));
        GridLayoutTest.assertTrue((boolean)layout.isExplicitRow(1));
    }

    @Test
    public void test_implicitLayout_CREATE() throws Exception {
        this.prepareShell_withImplicit();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridLayoutTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 1, false, 1, false);
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_implicitLayout_MOVE() throws Exception {
        this.prepareShell_withImplicit();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        this.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)GridLayoutTest.getJavaInfoByName("button");
        layout.command_MOVE(button, 1, false, 1, false);
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    private void prepareShell_withImplicit() throws Exception {
        GridLayoutTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  public MyShell() {", "    setLayout(new GridLayout(2, false));", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutTest.waitForAutoBuild();
    }

    private void prepareShell_withImplicitEmpty() throws Exception {
        GridLayoutTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  public MyShell() {", "    setLayout(new GridLayout(1, false));", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutTest.waitForAutoBuild();
    }

    @Test
    public void test_columnAccess() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        final GridColumnInfo column = (GridColumnInfo)layout.getColumns().get(0);
        GridLayoutTest.assertEquals((int)0, (int)column.getIndex());
        GridLayoutTest.assertEquals((Object)"left", (Object)column.getTitle());
        GridLayoutTest.assertFalse((boolean)column.getGrab());
        GridLayoutTest.assertEquals((int)16384, (int)column.getAlignment());
        column.flipGrab();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        GridLayoutTest.assertEquals((Object)"left, grab", (Object)column.getTitle());
        column.setAlignment(4);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        GridLayoutTest.assertEquals((Object)"fill, grab", (Object)column.getTitle());
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        GridLayoutInfo.getGridData((ControlInfo)button).setHorizontalAlignment(131072);
        GridLayoutTest.assertNull((Object)column.getAlignment());
        column.setAlignment(0x1000000);
        GridLayoutTest.assertEquals((Object)"center, grab", (Object)column.getTitle());
        column.setAlignment(131072);
        GridLayoutTest.assertEquals((Object)"right, grab", (Object)column.getTitle());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                column.delete();
            }
        });
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
    }

    @Test
    public void test_rowAccess() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridRowInfo row = (GridRowInfo)layout.getRows().get(1);
        GridLayoutTest.assertEquals((int)1, (int)row.getIndex());
        GridLayoutTest.assertEquals((Object)"center", (Object)row.getTitle());
        GridLayoutTest.assertFalse((boolean)row.getGrab());
        GridLayoutTest.assertEquals((int)0x1000000, (int)row.getAlignment());
        row.flipGrab();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));", "      button.setText('1 x 1');", "    }", "  }", "}");
        GridLayoutTest.assertEquals((Object)"center, grab", (Object)row.getTitle());
        row.setAlignment(4);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, true, 1, 1));", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, true, 1, 1));", "      button.setText('1 x 1');", "    }", "  }", "}");
        GridLayoutTest.assertEquals((Object)"fill, grab", (Object)row.getTitle());
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        GridLayoutInfo.getGridData((ControlInfo)button).setVerticalAlignment(1024);
        GridLayoutTest.assertNull((Object)row.getAlignment());
        row.setAlignment(128);
        GridLayoutTest.assertEquals((Object)"top, grab", (Object)row.getTitle());
        row.setAlignment(1024);
        GridLayoutTest.assertEquals((Object)"bottom, grab", (Object)row.getTitle());
        row.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "  }", "}");
    }

    @Test
    public void test_deleteColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 3;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            shell.startEdit();
            layout.command_deleteColumn(1, true);
        }
        finally {
            shell.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
    }

    @Test
    public void test_deleteColumn_deleteAlsoEmptyRows() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            shell.startEdit();
            layout.command_deleteColumn(1, true);
        }
        finally {
            shell.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
    }

    @Test
    public void test_delete_missingFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_10 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_10 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
        List controls = shell.getChildrenControls();
        Assertions.assertThat((List)controls).hasSize(4);
        ControlInfo button_01 = (ControlInfo)controls.get(2);
        button_01.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_10 = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_deleteRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.verticalSpan = 3;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            shell.startEdit();
            layout.command_deleteRow(1, true);
        }
        finally {
            shell.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.verticalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
    }

    @Test
    public void test_deleteRow_deleteAlsoEmptyColumns() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            shell.startEdit();
            layout.command_deleteRow(1, true);
        }
        finally {
            shell.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_COLUMN_before() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            layout.startEdit();
            layout.command_MOVE_COLUMN(1, 0);
        }
        finally {
            layout.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_MOVE_COLUMN_after() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            layout.startEdit();
            layout.command_MOVE_COLUMN(0, 2);
        }
        finally {
            layout.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_MOVE_ROW_before() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            layout.startEdit();
            layout.command_MOVE_ROW(1, 0);
        }
        finally {
            layout.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_MOVE_ROW_after() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        try {
            layout.startEdit();
            layout.command_MOVE_ROW(0, 2);
        }
        finally {
            layout.endEdit();
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        layout.command_normalizeSpanning();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.verticalSpan = 2;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        layout.command_normalizeSpanning();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_3() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button_1.setLayoutData(gridData);", "      }", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        layout.command_normalizeSpanning();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button_1.setLayoutData(gridData);", "      }", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_4() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.horizontalSpan = 2;", "        button_1.setLayoutData(gridData);", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        layout.command_normalizeSpanning();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        layout.command_MOVE(button, 1, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_out() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        RowLayoutInfo layout = (RowLayoutInfo)composite.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        layout.command_MOVE(button, null);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_error_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(4, false));", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutInfo gridLayout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(7);
        gridLayout.command_MOVE(button, 1, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_MOVE_error_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutInfo gridLayout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(5);
        gridLayout.command_MOVE(button, 0, false, 0, false);
        gridLayout.getGridInfo();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        layout.command_ADD(button, 0, false, 1, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_noReference() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_viewer() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ViewerInfo viewer = ViewerTest.createTableViewer(this.m_lastEditor);
        TableInfo table = (TableInfo)JavaInfoUtils.getWrapped((JavaInfo)viewer);
        layout.command_CREATE((ControlInfo)table, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "      table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_numColumns_inc() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
        GridLayoutTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getPropertyByTitle("numColumns").setValue((Object)3);
        GridLayoutTest.assertEquals((int)3, (int)layout.getColumns().size());
        GridLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_numColumns_dec() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(3, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        GridLayoutTest.assertEquals((int)3, (int)layout.getColumns().size());
        GridLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        layout.getPropertyByTitle("numColumns").setValue((Object)2);
        GridLayoutTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    Button button_3 = new Button(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_excludeFlag() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Assertions.assertThat((List)layout.getControls()).containsOnly((Object[])new ControlInfo[]{button});
        GridLayoutInfo.getGridData((ControlInfo)button).getPropertyByTitle("exclude").setValue((Object)true);
        Assertions.assertThat((List)layout.getControls()).isEmpty();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gridData.exclude = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_excludeFlag_forImplicit() throws Exception {
        GridLayoutTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("class MyComposite extends Composite {", "  MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.exclude = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}"));
        GridLayoutTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_DELETE_removeFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    new Label(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        shell.refresh();
        GridLayoutTest.assertEquals((int)2, (int)shell.getChildrenControls().size());
        layout.delete();
        GridLayoutTest.assertEquals((int)1, (int)shell.getChildrenControls().size());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_clipboard() throws Exception {
        final CompositeInfo shell = (CompositeInfo)this.parseJavaInfo("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "        GridData gridData = new GridData();", "        gridData.horizontalAlignment = GridData.FILL;", "        button.setLayoutData(gridData);", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "    }", "  }", "}");
        this.refresh();
        ControlInfo composite = (ControlInfo)GridLayoutTest.getJavaInfoByName("composite");
        GridLayoutTest.doCopyPaste(composite, new AbstractJavaInfoTest.PasteProcedure<ControlInfo>(){

            @Override
            public void run(ControlInfo copy) throws Exception {
                shell.getLayout().command_CREATE(copy, null);
            }
        });
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "        GridData gridData = new GridData();", "        gridData.horizontalAlignment = GridData.FILL;", "        button.setLayoutData(gridData);", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "    }", "  }", "}");
    }

    private static int getInt(GridDataInfo gridData, String fieldName) throws Exception {
        return ReflectionUtils.getFieldInt((Object)gridData, (String)fieldName);
    }
}

