/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class AbsoluteLayoutOrderingTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_enablement() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Button button = new Button(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(2);
        IMenuManager orderManager = AbsoluteLayoutOrderingTest.createOrderManager(button);
        AbsoluteLayoutOrderingTest.assertNotNull((Object)orderManager);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Bring to Front", false);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Send to Back", true);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Bring Forward", false);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Send Backward", true);
        orderManager = AbsoluteLayoutOrderingTest.createOrderManager(text);
        AbsoluteLayoutOrderingTest.assertNotNull((Object)orderManager);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Bring to Front", true);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Send to Back", true);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Bring Forward", true);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Send Backward", true);
        orderManager = AbsoluteLayoutOrderingTest.createOrderManager(table);
        AbsoluteLayoutOrderingTest.assertNotNull((Object)orderManager);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Bring to Front", true);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Send to Back", false);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Bring Forward", true);
        AbsoluteLayoutOrderingTest.checkOrderAction(orderManager, "Send Backward", false);
    }

    @Test
    public void test_bringToFront() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Button button = new Button(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(2);
        AbsoluteLayoutOrderingTest.getOrderAction(AbsoluteLayoutOrderingTest.createOrderManager(table), "Bring to Front").run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Table table = new Table(this, SWT.NONE);", "      Button button = new Button(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "  }", "}");
        Assertions.assertThat((List)shell.getChildrenControls()).containsExactly((Object[])new ControlInfo[]{table, button, text});
    }

    @Test
    public void test_bringForward() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Button button = new Button(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(2);
        AbsoluteLayoutOrderingTest.getOrderAction(AbsoluteLayoutOrderingTest.createOrderManager(table), "Bring Forward").run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Button button = new Button(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "  }", "}");
        Assertions.assertThat((List)shell.getChildrenControls()).containsExactly((Object[])new ControlInfo[]{button, table, text});
    }

    @Test
    public void test_sendToBack() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Button button = new Button(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(2);
        AbsoluteLayoutOrderingTest.getOrderAction(AbsoluteLayoutOrderingTest.createOrderManager(button), "Send to Back").run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Text text = new Text(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "      Button button = new Button(this, SWT.NONE);", "  }", "}");
        Assertions.assertThat((List)shell.getChildrenControls()).containsExactly((Object[])new ControlInfo[]{text, table, button});
    }

    @Test
    public void test_sendBackward() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Button button = new Button(this, SWT.NONE);", "      Text text = new Text(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(2);
        AbsoluteLayoutOrderingTest.getOrderAction(AbsoluteLayoutOrderingTest.createOrderManager(button), "Send Backward").run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "      Text text = new Text(this, SWT.NONE);", "      Button button = new Button(this, SWT.NONE);", "      Table table = new Table(this, SWT.NONE);", "  }", "}");
        Assertions.assertThat((List)shell.getChildrenControls()).containsExactly((Object[])new ControlInfo[]{text, button, table});
    }

    private static IMenuManager createOrderManager(ControlInfo control) throws Exception {
        MenuManager manager = AbsoluteLayoutOrderingTest.getDesignerMenuManager();
        control.getBroadcastObject().addContextMenu(Collections.singletonList(control), (ObjectInfo)control, (IMenuManager)manager);
        return AbsoluteLayoutOrderingTest.findChildMenuManager((IContributionManager)manager, "Order");
    }

    private static IAction getOrderAction(IMenuManager orderManager, String text) {
        return AbsoluteLayoutOrderingTest.findChildAction((IContributionManager)orderManager, text);
    }

    private static void checkOrderAction(IMenuManager orderManager, String text, boolean enabled) {
        IAction action = AbsoluteLayoutOrderingTest.getOrderAction(orderManager, text);
        AbsoluteLayoutOrderingTest.assertNotNull((Object)action, (String)("Can not find action: " + text));
        AbsoluteLayoutOrderingTest.assertEquals((Object)enabled, (Object)action.isEnabled());
    }
}

