/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.FlowLayout;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class FlowLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        FlowLayoutTest.setLayout(panel, FlowLayout.class);
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t}\n}");
    }

    @Test
    public void test_setLayout2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        FlowLayoutTest.setLayout(panel, FlowLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_add_last() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout());\n\t}\n}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FlowLayoutTest.createJButton();
        layout.add(newComponent, null);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_add_before() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = FlowLayoutTest.createJButton();
        layout.add(newComponent, existingButton);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"111\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_move_before() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2);\n\t\t}\n\t}\n}";
        String expectedLines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}";
        this.check_move_before(lines, expectedLines);
    }

    @Test
    public void test_moveComplex() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel complexPanel = new JPanel();\n\t\t\tadd(complexPanel);\n\t\t\t{\n\t\t\t\tJButton button2 = new JButton();\n\t\t\t\tcomplexPanel.add(button2);\n\t\t\t}\n\t\t}\n\t}\n}";
        String expectedLines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel complexPanel = new JPanel();\n\t\t\tadd(complexPanel);\n\t\t\t{\n\t\t\t\tJButton button2 = new JButton();\n\t\t\t\tcomplexPanel.add(button2);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        this.check_move_before(lines, expectedLines);
    }

    @Test
    public void test_move_before_lazy() throws Exception {
        String lines = "public class Test extends JPanel {\n\tprivate JButton button_1;\n\tprivate JButton button_2;\n\tpublic Test() {\n\t\tadd(getButton_1());\n\t\tadd(getButton_2());\n\t}\n\tprivate JButton getButton_1() {\n\t\tif (button_1 == null) {\n\t\t\tbutton_1 = new JButton(\"Button 1\");\n\t\t}\n\t\treturn button_1;\n\t}\n\tprivate JButton getButton_2() {\n\t\tif (button_2 == null) {\n\t\t\tbutton_2 = new JButton(\"button 2\");\n\t\t}\n\t\treturn button_2;\n\t}\n}";
        String expectedLines = "public class Test extends JPanel {\n\tprivate JButton button_1;\n\tprivate JButton button_2;\n\tpublic Test() {\n\t\tadd(getButton_2());\n\t\tadd(getButton_1());\n\t}\n\tprivate JButton getButton_1() {\n\t\tif (button_1 == null) {\n\t\t\tbutton_1 = new JButton(\"Button 1\");\n\t\t}\n\t\treturn button_1;\n\t}\n\tprivate JButton getButton_2() {\n\t\tif (button_2 == null) {\n\t\t\tbutton_2 = new JButton(\"button 2\");\n\t\t}\n\t\treturn button_2;\n\t}\n}";
        this.check_move_before(lines, expectedLines);
    }

    private void check_move_before(String lines, String expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.move(button_2, button_1);
        this.assertEditor(expectedLines);
    }

    @Test
    public void test_move_last() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2);\n\t\t}\n\t}\n}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.move(button_1, null);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_reparentingVariable() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setLayout(new BorderLayout());\n\t\t\tpanel.setPreferredSize(new Dimension(150, 150));\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel.add(button, BorderLayout.NORTH);\n\t\t\t}\n\t\t}\n\t}\n}";
        String expectedLines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setLayout(new BorderLayout());\n\t\t\tpanel.setPreferredSize(new Dimension(150, 150));\n\t\t\tadd(panel);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        this.check_reparenting(lines, expectedLines);
    }

    private void check_reparenting(String lines, String expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        layout.move(button, null);
        this.assertEditor(expectedLines);
    }

    @Test
    public void test_clipboard() throws Exception {
        String lines1 = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"A\");\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"B\");\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}";
        ContainerInfo panel = this.parseContainer(lines1);
        panel.refresh();
        ComponentInfo inner = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ContainerInfo copy = (ContainerInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)copy, null);
        memento.apply();
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"A\");\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"B\");\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"A\");\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"B\");\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}";
        this.assertEditor(lines);
    }
}

