/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.jupiter.api.Test;

public class FormLayoutTest
extends AbstractFormLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_Activator() throws Exception {
        FormLayoutTest.assertNotNull((Object)Activator.getDefault());
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        ColumnSpec.decode('70dlu'),", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        FormLayoutTest.assertEquals((int)3, (int)columns.size());
        List rows = layout.getRows();
        FormLayoutTest.assertEquals((int)1, (int)rows.size());
        IGridInfo gridInfo = layout.getGridInfo();
        FormLayoutTest.assertEquals((int)3, (int)gridInfo.getColumnCount());
        FormLayoutTest.assertEquals((int)1, (int)gridInfo.getRowCount());
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        FormLayoutTest.assertEquals((int)3, (int)columnIntervals.length);
        FormLayoutTest.assertEquals((int)1, (int)rowIntervals.length);
        Assertions.assertThat((int)columnIntervals[2].length()).isGreaterThan(18);
        FormLayoutTest.assertFalse((boolean)columnIntervals[0].isEmpty());
        Assertions.assertThat((int)rowIntervals[0].length()).isGreaterThan(18);
        FormLayoutTest.assertFalse((boolean)rowIntervals[0].isEmpty());
    }

    @Test
    public void test_useJPannel_withFormLayout() throws Exception {
        FormLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new FormLayout());", "  }", "}"));
        FormLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyPanel());", "  }", "}");
        FormLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyPanel())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {empty} {/add(new MyPanel())/}", "    {implicit-layout: com.jgoodies.forms.layout.FormLayout} {implicit-layout} {}");
        panel.refresh();
        FormLayoutTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_withJTable() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    getContentPane().setLayout(new FormLayout(new ColumnSpec[] {", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        RowSpec.decode('default:grow'),}));", "    {", "      JTable table = new JTable();", "      getContentPane().add(table, '1, 1, fill, fill');", "    }", "  }", "}");
        frame.refresh();
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo table = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        FormLayoutTest.assertTrue((table.getBounds().width > 300 ? 1 : 0) != 0, (String)("Actual size: " + String.valueOf(table.getBounds().getSize())));
        FormLayoutTest.assertTrue((table.getBounds().height > 200 ? 1 : 0) != 0, (String)("Actual size: " + String.valueOf(table.getBounds().getSize())));
    }

    @Test
    public void test_DimensionsProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        Property property = layout.getPropertyByTitle("columnSpecs");
        FormLayoutTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        FormLayoutTest.assertTrue((boolean)property.isModified());
        property.setValue((Object)this);
        FormLayoutTest.assertEquals((Object)"related gap, default", (Object)FormLayoutTest.getPropertyText(property));
        property = layout.getPropertyByTitle("rowSpecs");
        FormLayoutTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        FormLayoutTest.assertTrue((boolean)property.isModified());
        property.setValue((Object)this);
        FormLayoutTest.assertEquals((Object)"default", (Object)FormLayoutTest.getPropertyText(property));
    }

    @Test
    public void test_editColumnsRowsActions() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {},", "      new RowSpec[] {}));", "  }", "}");
        MenuManager menuManager = FormLayoutTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(panel), (ObjectInfo)panel, (IMenuManager)menuManager);
        FormLayoutTest.assertNotNull((Object)FormLayoutTest.findChildAction((IContributionManager)menuManager, "Edit c&olumns..."));
        FormLayoutTest.assertNotNull((Object)FormLayoutTest.findChildAction((IContributionManager)menuManager, "Edit &rows..."));
    }

    @Test
    public void test_setColumns() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        FormLayoutTest.assertEquals((int)2, (int)layout.getColumns().size());
        layout.setColumns(new ArrayList());
        FormLayoutTest.assertEquals((int)0, (int)layout.getColumns().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
    }

    @Test
    public void test_setRows() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        FormLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        layout.setRows(new ArrayList());
        FormLayoutTest.assertEquals((int)0, (int)layout.getRows().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {}));", "  }", "}");
    }

    @Test
    public void test_getMinimumSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '1,1,2,1');", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        Dimension minimumSize = layout.getMinimumSize();
        FormLayoutTest.assertEquals((int)2, (int)minimumSize.width);
        FormLayoutTest.assertEquals((int)1, (int)minimumSize.height);
    }

    @Test
    public void test_gridInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        ColumnSpec.decode('120px'),", "        ColumnSpec.decode('50px'),", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        RowSpec.decode('40px'),", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '1,1,2,1');", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IGridInfo gridInfo = layout.getGridInfo();
        FormLayoutTest.assertEquals((int)3, (int)gridInfo.getColumnCount());
        FormLayoutTest.assertEquals((int)2, (int)gridInfo.getRowCount());
        FormLayoutTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)gridInfo.getInsets());
        Assertions.assertThat((int)gridInfo.getVirtualColumnSize()).isGreaterThan(18);
        Assertions.assertThat((int)gridInfo.getVirtualColumnGap()).isGreaterThan(3);
        Assertions.assertThat((int)gridInfo.getVirtualRowSize()).isGreaterThan(18);
        Assertions.assertThat((int)gridInfo.getVirtualRowGap()).isGreaterThan(3);
        Rectangle cells = gridInfo.getComponentCells((IAbstractComponentInfo)button);
        FormLayoutTest.assertEquals((Object)new Rectangle(0, 0, 2, 1), (Object)cells);
        Rectangle cellsRectangle = gridInfo.getCellsRectangle(cells);
        FormLayoutTest.assertEquals((int)0, (int)cellsRectangle.x);
        FormLayoutTest.assertEquals((int)0, (int)cellsRectangle.y);
        FormLayoutTest.assertEquals((int)171, (int)cellsRectangle.width);
        FormLayoutTest.assertEquals((int)41, (int)cellsRectangle.height);
        FormLayoutTest.assertSame((Object)button, (Object)gridInfo.getOccupied(0, 0));
        FormLayoutTest.assertSame((Object)button, (Object)gridInfo.getOccupied(1, 0));
        FormLayoutTest.assertNull((Object)gridInfo.getOccupied(0, 1));
        FormLayoutTest.assertNull((Object)gridInfo.getOccupied(1, 1));
    }

    @Test
    public void test_gridInfo_insets() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setBorder(new EmptyBorder(10, 20, 30, 40));", "    setLayout(new FormLayout());", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        FormLayoutTest.assertEquals((Object)new Insets(10, 20, 30, 40), (Object)gridInfo.getInsets());
    }

    @Test
    public void test_normalizeSpanning_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '1, 1');", "    add(new JButton(), '2, 2');", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '1, 1');", "    add(new JButton(), '2, 2');", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '2, 2');", "    add(new JButton(), '4, 4');", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '2, 2');", "    add(new JButton(), '4, 4');", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.UNRELATED_GAP_COLSPEC,", "        FormSpecs.PREF_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.UNRELATED_GAP_ROWSPEC,", "        FormSpecs.PREF_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '2, 2');", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.UNRELATED_GAP_COLSPEC,", "        FormSpecs.PREF_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.UNRELATED_GAP_ROWSPEC,", "        FormSpecs.PREF_ROWSPEC,}));", "    add(new JButton(), '2, 2');", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.UNRELATED_GAP_COLSPEC,", "        FormSpecs.PREF_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.UNRELATED_GAP_ROWSPEC,", "        FormSpecs.PREF_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '4, 4');", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '2, 2');", "  }", "}");
    }

    @Test
    public void test_getColumnComponentsCounts() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    add(new JButton(), '1,1,2,1');", "    add(new JButton(), '1,2,1,1');", "    add(new JButton(), '3,2,1,1');", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 1;
        FormLayoutTest.assertArrayEquals((int[])nArray, (int[])layout.getColumnComponentsCounts());
        FormLayoutTest.assertArrayEquals((int[])new int[]{1, 2}, (int[])layout.getRowComponentsCounts());
    }

    @Test
    public void test_writeEmpty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {}));", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        layout.getColumns().clear();
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {},", "      new RowSpec[] {}));", "  }", "}");
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FormLayoutTest.setLayout(panel, FormLayout.class);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {},", "      new RowSpec[] {}));", "  }", "}");
    }

    @Test
    public void test_CREATE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FormLayoutTest.createJButton();
        layout.command_CREATE(newComponent, 1, false, 1, false);
        FormLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '1, 1');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(''));", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        FormLayoutTest.assertEquals((int)0, (int)layout.getColumns().size());
        FormLayoutTest.assertEquals((int)0, (int)layout.getRows().size());
        ComponentInfo newComponent = FormLayoutTest.createJButton();
        layout.command_CREATE(newComponent, 1, true, 1, true);
        FormLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints((ComponentInfo)newComponent);
        FormLayoutTest.assertEquals((int)2, (int)ReflectionUtils.getFieldInt((Object)constraints, (String)"x"));
        FormLayoutTest.assertEquals((int)2, (int)ReflectionUtils.getFieldInt((Object)constraints, (String)"y"));
        FormLayoutTest.assertEquals((int)2, (int)layout.getColumns().size());
        FormLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '2, 2');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton('111');", "      add(button, '2, 2');", "    }", "    {", "      JButton button = new JButton('222');", "      add(button, '4, 4');", "    }", "    {", "      JButton button = new JButton('col span');", "      add(button, '1, 6, 6, 1');", "    }", "    {", "      JButton button = new JButton('row span');", "      add(button, '6, 1, 1, 6');", "    }", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        FormLayoutTest.assertEquals((int)6, (int)layout.getColumns().size());
        FormLayoutTest.assertEquals((int)6, (int)layout.getRows().size());
        ComponentInfo newComponent = FormLayoutTest.createJButton();
        layout.command_CREATE(newComponent, 3, true, 3, true);
        FormLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        FormLayoutTest.assertEquals((int)8, (int)layout.getColumns().size());
        FormLayoutTest.assertEquals((int)8, (int)layout.getRows().size());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton('111');", "      add(button, '2, 2');", "    }", "    {", "      JButton button = new JButton();", "      add(button, '4, 4');", "    }", "    {", "      JButton button = new JButton('222');", "      add(button, '6, 6');", "    }", "    {", "      JButton button = new JButton('col span');", "      add(button, '1, 8, 8, 1');", "    }", "    {", "      JButton button = new JButton('row span');", "      add(button, '8, 1, 1, 8');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout());", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FormLayoutTest.createJButton();
        layout.command_CREATE(newComponent, 4, false, 4, false);
        FormLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '4, 4');", "    }", "  }", "}");
    }

    @Test
    public void test_PASTE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      button.setEnabled(false);", "      add(button, '1, 1');", "    }", "  }", "}");
        panel.refresh();
        final FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ComponentInfo newComponent = (ComponentInfo)memento.create((JavaInfo)layout);
                layout.command_CREATE(newComponent, 3, false, 3, false);
                memento.apply();
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      button.setEnabled(false);", "      add(button, '1, 1');", "    }", "    {", "      JButton button = new JButton();", "      button.setEnabled(false);", "      add(button, '3, 3');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '2, 2');", "    }", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_MOVE(button, 1, false, 1, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '1, 1');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, '1, 1');", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "  }", "}");
        panel.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        panel.startEdit();
        layout.command_ADD(button, 2, false, 2, false);
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints((ComponentInfo)button);
        FormLayoutTest.assertEquals((int)2, (int)ReflectionUtils.getFieldInt((Object)constraints, (String)"x"));
        FormLayoutTest.assertEquals((int)2, (int)ReflectionUtils.getFieldInt((Object)constraints, (String)"y"));
        FormLayoutTest.assertEquals((int)1, (int)ReflectionUtils.getFieldInt((Object)constraints, (String)"width"));
        FormLayoutTest.assertEquals((int)1, (int)ReflectionUtils.getFieldInt((Object)constraints, (String)"height"));
        FormLayoutTest.assertEquals((Object)CellConstraints.DEFAULT, (Object)ReflectionUtils.getFieldObject((Object)constraints, (String)"alignH"));
        FormLayoutTest.assertEquals((Object)CellConstraints.DEFAULT, (Object)ReflectionUtils.getFieldObject((Object)constraints, (String)"alignV"));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, '1, 1');", "    }", "    {", "      JButton button = new JButton();", "      add(button, '2, 2');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_OUT() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, '1, 1');", "    }", "    {", "      JButton button = new JButton();", "      add(button, '2, 2');", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)innerPanel.getLayout();
        flowLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JPanel panel = new JPanel();", "      add(panel, '1, 1');", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "  }", "}");
        try {
            FormLayoutInfo.getConstraints((ComponentInfo)button);
            FormLayoutTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_DELETE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '1, 1');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        try {
            FormLayoutInfo.getConstraints((ComponentInfo)button);
            FormLayoutTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_canChangeDimensions_constructor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout());", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        FormLayoutTest.assertTrue((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_canChangeDimensions_implicit() throws Exception {
        FormLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new FormLayout());", "  }", "}"));
        FormLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        FormLayoutTest.assertFalse((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_checkForActive_whenContributeProperties() throws Exception {
        String[] lines = new String[]{"public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new FormLayout());", "  }", "}"};
        FormLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource(lines));
        FormLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridLayout());", "    add(new JButton());", "  }", "}");
        FormLayoutTest.assertHierarchy("{this: test.MyPanel} {this} {/setLayout(new GridLayout())/ /add(new JButton())/}", "  {new: java.awt.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FormLayoutTest.assertNull((Object)button.getPropertyByTitle("Constraints"));
    }
}

