/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout.form;

import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class FormLayoutAlignmentDetectionTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getAlignment_single_noConstraints() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertEquals((int)0, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).alignment);
    }

    @Test
    public void test_getAlignment_single_left() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertEquals((int)0, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).alignment);
    }

    @Test
    public void test_getAlignment_single_right() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.right = new FormAttachment(100, -50);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertEquals((int)1, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).alignment);
    }

    @Test
    public void test_getAlignment_single_left_as_trailing() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(100, -50);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertEquals((int)1, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).alignment);
    }

    @Test
    public void test_getAlignment_single_forBothSidesAttached_right() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.right = new FormAttachment(100, -50);", "      data.left = new FormAttachment(100, -150);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertEquals((int)1, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).alignment);
    }

    @Test
    public void test_getAlignment_single_forBothSidesAttached_left() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      data.right = new FormAttachment(0, 150);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertEquals((int)0, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).alignment);
    }

    @Test
    public void test_getAlignment_single_forBothSidesAttached_left_and_right() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      data.right = new FormAttachment(100, -150);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertTrue((boolean)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).resizable);
    }

    @Test
    public void test_getAlignment_single_forBothSidesAttached_left_and_right_numerators() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(50, 0);", "      data.right = new FormAttachment(100, -150);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutAlignmentDetectionTest.assertTrue((boolean)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).resizable);
    }

    @Test
    public void test_getAlignment_complex_forBothSidesAttached_left_and_right() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button1 = new Button(this, SWT.NONE);", "    button1.setText(\"Button 1\");", "    Button button2 = new Button(this, SWT.NONE);", "    button2.setText(\"Button 2\");", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 40);", "      button1.setLayoutData(data);", "    }", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(button1, 20);", "      data.right = new FormAttachment(100, -120);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        FormLayoutAlignmentDetectionTest.assertTrue((boolean)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button, (boolean)true).resizable);
    }

    @Test
    public void test_getAlignment_complex_forBothSidesAttached_left_and_right_indirect() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button1 = new Button(this, SWT.NONE);", "    button1.setText(\"Button 1\");", "    Button button2 = new Button(this, SWT.NONE);", "    button2.setText(\"Button 2\");", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      data.right = new FormAttachment(100, -150);", "      button1.setLayoutData(data);", "    }", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(button1, 10, SWT.LEFT);", "      data.right = new FormAttachment(button1, 0, SWT.RIGHT);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        FormLayoutAlignmentDetectionTest.assertTrue((boolean)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button1, (boolean)true).resizable);
        FormLayoutAlignmentDetectionTest.assertTrue((boolean)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button2, (boolean)true).resizable);
    }

    @Test
    public void test_getAlignment_complex_forBothSidesAttached_notResizeable_indirect() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button1 = new Button(this, SWT.NONE);", "    button1.setText(\"Button 1\");", "    Button button2 = new Button(this, SWT.NONE);", "    button2.setText(\"Button 2\");", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      data.right = new FormAttachment(0, 150);", "      button1.setLayoutData(data);", "    }", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(button1, 10, SWT.LEFT);", "      data.right = new FormAttachment(button1, 0, SWT.RIGHT);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(1);
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        FormLayoutAlignmentDetectionTest.assertEquals((int)0, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button1, (boolean)true).alignment);
        FormLayoutAlignmentDetectionTest.assertEquals((int)0, (int)this.getImpl((CompositeInfo)shell).getAlignment((IAbstractComponentInfo)button2, (boolean)true).alignment);
    }

    private FormLayoutInfoImplAutomatic<ControlInfo> getImpl(CompositeInfo shell) {
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        return (FormLayoutInfoImplAutomatic)layout.getImpl();
    }
}

