/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.wb.internal.rcp.model.jface.WindowInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class WindowTopBoundsSupportTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_apply_defaultSize() throws Exception {
        WindowInfo window = (WindowInfo)this.parseJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends Window {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        window.refresh();
        WindowTopBoundsSupportTest.assertEquals((Object)new Dimension(450, 300), (Object)window.getBounds().getSize());
    }

    @Test
    public void test_apply_getInitialSize() throws Exception {
        WindowInfo window = (WindowInfo)this.parseJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends Window {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Point getInitialSize() {", "    return new Point(500, 300);", "  }", "}");
        window.refresh();
        WindowTopBoundsSupportTest.assertEquals((Object)new Dimension(500, 300), (Object)window.getBounds().getSize());
    }

    @Test
    public void test_setSize_defaultSize() throws Exception {
        WindowInfo window = (WindowInfo)this.parseJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends Window {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        window.refresh();
        WindowTopBoundsSupportTest.assertEquals((Object)new Dimension(450, 300), (Object)window.getBounds().getSize());
        window.getTopBoundsSupport().setSize(200, 200);
        window.refresh();
        WindowTopBoundsSupportTest.assertEquals((Object)new Dimension(200, 200), (Object)window.getBounds().getSize());
    }

    @Test
    public void test_setSize_getInitialSize() throws Exception {
        WindowInfo window = (WindowInfo)this.parseJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends Window {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Point getInitialSize() {", "    return new Point(500, 300);", "  }", "}");
        window.refresh();
        WindowTopBoundsSupportTest.assertEquals((Object)new Dimension(500, 300), (Object)window.getBounds().getSize());
        window.getTopBoundsSupport().setSize(200, 200);
        window.refresh();
        WindowTopBoundsSupportTest.assertEquals((Object)new Dimension(200, 200), (Object)window.getBounds().getSize());
        this.assertEditor("import org.eclipse.jface.window.*;", "public class Test extends Window {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Point getInitialSize() {", "    return new Point(200, 200);", "  }", "}");
    }
}

