/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import java.util.List;
import org.eclipse.wb.core.editor.structure.property.PropertyCategoryProviderProvider;
import org.eclipse.wb.core.editor.structure.property.PropertyListProcessor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.Test;

public class ComponentsPropertiesPageTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_PropertyCategoryProvider_Provider() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t// filler filler filler\n\t}\n}");
        TestBundle testBundle = new TestBundle();
        try {
            Class<CategoryProvider2> providerClass = CategoryProvider2.class;
            testBundle.addClass(providerClass);
            testBundle.addExtension("org.eclipse.wb.core.propertiesPageCategoryProviders", "<provider class='" + providerClass.getName() + "'/>");
            testBundle.install();
            try {
                this.canvas.select(panel);
                Property property = this.m_propertyTable.forTests_getProperty(0);
                ComponentsPropertiesPageTest.assertSame((Object)PropertyCategory.NORMAL, (Object)this.m_propertyTable.getCategory(property));
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_PropertyList_Processor() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t// filler filler filler\n\t}\n}");
        TestBundle testBundle = new TestBundle();
        try {
            Class<PropertyProcessor> processorClass = PropertyProcessor.class;
            testBundle.addClass(processorClass);
            testBundle.addExtension("org.eclipse.wb.core.propertiesPageProcessors", "<processor class='" + processorClass.getName() + "'/>");
            testBundle.install();
            try {
                this.canvas.select(panel);
                ComponentsPropertiesPageTest.assertEquals((int)1, (int)this.m_propertyTable.forTests_getPropertiesCount());
                Property property = this.m_propertyTable.forTests_getProperty(0);
                ComponentsPropertiesPageTest.assertEquals((Object)"ALL", (Object)property.getTitle());
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    public static class CategoryProvider2
    implements PropertyCategoryProviderProvider {
        public PropertyCategoryProvider get(List<ObjectInfo> objects) {
            return new PropertyCategoryProvider(){

                public PropertyCategory getCategory(Property property) {
                    return PropertyCategory.NORMAL;
                }
            };
        }
    }

    public static class PropertyProcessor
    implements PropertyListProcessor {
        private static ComplexProperty m_propertyProcessorWrapper = new ComplexProperty("ALL", "(all properties)");

        public void process(List<ObjectInfo> objects, List<Property> properties) {
            m_propertyProcessorWrapper.setProperties(properties);
            properties.clear();
            properties.add((Property)m_propertyProcessorWrapper);
        }
    }
}

